/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.service.redisinfo.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.core.MongoDaoSupport;
import com.biz.eisp.redisInfo.RedisInfoAddMongo;
import com.biz.eisp.redisInfo.RedisInfoCPU;
import com.biz.eisp.redisInfo.RedisInfoClients;
import com.biz.eisp.redisInfo.RedisInfoCluster;
import com.biz.eisp.redisInfo.RedisInfoKeyspace;
import com.biz.eisp.redisInfo.RedisInfoMemory;
import com.biz.eisp.redisInfo.RedisInfoPersistence;
import com.biz.eisp.redisInfo.RedisInfoReplication;
import com.biz.eisp.redisInfo.RedisInfoServer;
import com.biz.eisp.redisInfo.RedisInfoStats;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.service.redisinfo.RedisInfoService;
import com.biz.eisp.utils.ReflectionUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service(value="redisInfoService")
public class RedisInfoServiceImpl
extends MongoDaoSupport<RedisInfoAddMongo>
implements RedisInfoService {
    private static final Logger log = LoggerFactory.getLogger(RedisInfoServiceImpl.class);
    @Autowired
    private RedisService redisService;

    @Override
    public void addRedisInfo() {
        RedisInfoAddMongo vo = this.bulidParams();
        this.save(vo);
    }

    @Override
    public RedisInfoAddMongo findCurrentRedisInfo() {
        return this.bulidParams();
    }

    @Override
    public List<RedisInfoAddMongo> findPeriodRedisInfo(String startTime, String endTime) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startTimeDate = format.parse(startTime);
        Date endTimeDate = format.parse(endTime);
        Query q = new Query();
        q.addCriteria((CriteriaDefinition)Criteria.where((String)"createDate").gte((Object)startTimeDate).lte((Object)endTimeDate));
        List<RedisInfoAddMongo> result = this.find(q);
        return result;
    }

    private RedisInfoAddMongo bulidParams() {
        RedisInfoAddMongo vo = new RedisInfoAddMongo();
        String dateStr = DateUtils.getDataString((SimpleDateFormat)DateUtils.date_sdf);
        String timeStr = DateUtils.getDataString((SimpleDateFormat)DateUtils.short_time_sdf);
        vo.setDateStr(dateStr);
        vo.setTimeStr(timeStr);
        vo.setCreateDate(new Date());
        RedisInfoClients clients = new RedisInfoClients();
        RedisInfoCluster cluster = new RedisInfoCluster();
        RedisInfoCPU CPU = new RedisInfoCPU();
        RedisInfoKeyspace keyspace = new RedisInfoKeyspace();
        RedisInfoMemory memory = new RedisInfoMemory();
        RedisInfoPersistence persistence = new RedisInfoPersistence();
        RedisInfoReplication replication = new RedisInfoReplication();
        RedisInfoServer server = new RedisInfoServer();
        RedisInfoStats stats = new RedisInfoStats();
        Properties clientsProperties = this.redisService.getRedisClientsInfo();
        Properties clusterProperties = this.redisService.getRedisClusterInfo();
        Properties cpuProperties = this.redisService.getRedisCPUInfo();
        Properties keyspaceProperties = this.redisService.getRedisKeyspaceInfo();
        Properties memoryProperties = this.redisService.getRedisMemoryInfo();
        Properties persistenceProperties = this.redisService.getRedisPersistenceInfo();
        Properties replicationProperties = this.redisService.getRedisReplicationInfo();
        Properties serverProperties = this.redisService.getRedisServerInfo();
        Properties statsProperties = this.redisService.getRedisStatsInfo();
        this.putPropertiesToObject(clientsProperties, clients);
        this.putPropertiesToObject(clusterProperties, cluster);
        this.putPropertiesToObject(cpuProperties, CPU);
        this.putPropertiesToObject(memoryProperties, memory);
        this.putPropertiesToObject(persistenceProperties, persistence);
        this.putPropertiesToObject(replicationProperties, replication);
        this.putPropertiesToObject(serverProperties, server);
        this.putPropertiesToObject(statsProperties, stats);
        this.putPropertiesToKeyspace(keyspaceProperties, keyspace);
        vo.setClients(clients);
        vo.setCluster(cluster);
        vo.setCPU(CPU);
        vo.setKeyspace(keyspace);
        vo.setMemory(memory);
        vo.setPersistence(persistence);
        vo.setReplication(replication);
        vo.setServer(server);
        vo.setStats(stats);
        return vo;
    }

    private void putPropertiesToKeyspace(Properties keyspaceProperties, RedisInfoKeyspace keyspace) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : keyspaceProperties.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().toString());
        }
        keyspace.setDbs(map);
    }

    private void putPropertiesToObject(Properties clientsProperties, Object clients) {
        HashMap<String, Object> map = null;
        try {
            map = ReflectionUtils.Reflect(clients);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage());
            throw new BusinessException("\u53cd\u5c04\u83b7\u53d6\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        for (String key : map.keySet()) {
            for (Map.Entry<Object, Object> entry : clientsProperties.entrySet()) {
                if (!key.equals(entry.getKey())) continue;
                ReflectionUtils.invokeSetterMethod(clients, key, entry.getValue());
            }
        }
    }
}

