/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.service.track.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.core.MongoDaoSupport;
import com.biz.eisp.service.track.KnlMongoTrackDistanceService;
import com.biz.eisp.service.track.KnlMongoTrackService;
import com.biz.eisp.worktrack.entity.TrackPointDistanceMongoEntity;
import com.biz.eisp.worktrack.entity.TrackPointMongoEntity;
import com.biz.eisp.worktrack.track.BasePoint;
import com.biz.eisp.worktrack.track.trackterminal.TrackTerminalLastVo;
import com.biz.eisp.worktrack.vo.CountUserVo;
import com.biz.eisp.worktrack.vo.GetTrackPramsVo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.mapreduce.GroupBy;
import org.springframework.data.mongodb.core.mapreduce.GroupByResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service(value="knlMongoTrackService")
public class KnlMongoTrackServiceImpl
extends MongoDaoSupport<TrackPointMongoEntity>
implements KnlMongoTrackService {
    @Autowired
    private KnlMongoTrackDistanceService knlMongoTrackDistanceService;

    @Override
    public void saveTrackPoint(TrackPointMongoEntity entity) {
        String dateStr = DateUtils.getDataString((SimpleDateFormat)DateUtils.date_sdf);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"dateStr").is((Object)dateStr));
        query.with(new Sort(Sort.Direction.DESC, new String[]{"createDate"})).limit(1);
        List lastList = this.find(query);
        if (CollectionUtil.listNotEmptyNotSizeZero(lastList)) {
            this.knlMongoTrackDistanceService.calcAndSaveDistance((TrackPointMongoEntity)lastList.get(0), entity);
        }
        this.save(entity);
    }

    @Override
    public List<TrackTerminalLastVo> queryUserList(String userIds) {
        ArrayList<TrackTerminalLastVo> result = new ArrayList<TrackTerminalLastVo>();
        if (StringUtil.isNotEmpty((CharSequence)userIds)) {
            String[] ids = userIds.split(",");
            for (int i = 0; i < ids.length; ++i) {
                result.add(this.queryUserByUserId(ids[i]));
            }
        }
        return result;
    }

    @Override
    public Double queryDistance(String userId, String dateStr) {
        return this.getDistance(userId, dateStr);
    }

    @Override
    public List<TrackPointMongoEntity> queryTracksByMongo(GetTrackPramsVo vo) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"dateStr").is((Object)vo.getDateTime()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)vo.getEntityName()));
        query.with(new Sort(Sort.Direction.DESC, new String[]{"createDate"}));
        List<TrackPointMongoEntity> list = this.find(query);
        return list;
    }

    @Override
    public List<CountUserVo> queryPointGroupByUserAndDateStr(String dateStr) {
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        Criteria[] criteriaArray = new Criteria[]{};
        if (dateStr != null) {
            Criteria isState = Criteria.where((String)"dateStr").is((Object)dateStr);
            criteriaList.add(isState);
        }
        if (criteriaList.size() > 0) {
            criteriaArray = new Criteria[criteriaList.size()];
            for (int i = 0; i < criteriaList.size(); ++i) {
                criteriaArray[i] = (Criteria)criteriaList.get(i);
            }
        }
        GroupBy groupBy = new GroupBy(new String[]{"userId"}).initialDocument("{ count: 0 }").reduceFunction("function (doc,pre){pre.count +=1 ;}");
        GroupByResults groupByResults = this.mongoTemplate.group(new Criteria().andOperator(criteriaArray), "trackPointMongoEntity", groupBy, CountUserVo.class);
        Iterator iterator = groupByResults.iterator();
        ArrayList<CountUserVo> result = new ArrayList<CountUserVo>();
        while (iterator.hasNext()) {
            CountUserVo vo = (CountUserVo)iterator.next();
            result.add(vo);
        }
        return result;
    }

    private TrackTerminalLastVo queryUserByUserId(String userId) {
        TrackTerminalLastVo vo = new TrackTerminalLastVo();
        String dateStr = DateUtils.getDataString((SimpleDateFormat)DateUtils.date_sdf);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"dateStr").is((Object)dateStr));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId));
        query.with(new Sort(Sort.Direction.DESC, new String[]{"createDate"}));
        List lastList = this.find(query);
        long count = this.count(query);
        if (CollectionUtil.listNotEmptyNotSizeZero(lastList)) {
            TrackPointMongoEntity temp = (TrackPointMongoEntity)lastList.get(0);
            BasePoint latestLocation = new BasePoint();
            latestLocation.setLongitude(temp.getLongitude());
            latestLocation.setLatitude(temp.getLatitude());
            latestLocation.setProvince(temp.getProvince());
            latestLocation.setArea(temp.getArea());
            latestLocation.setCity(temp.getCity());
            latestLocation.setAddress(temp.getAddress());
            vo.setLatest_location(latestLocation);
        }
        Double totalDistance = this.getDistance(userId, dateStr);
        vo.setEntity_name(userId);
        vo.setDistance(totalDistance.doubleValue());
        vo.setPointNum(count);
        return vo;
    }

    private Double getDistance(String userId, String dateStr) {
        Query queryDis = new Query();
        queryDis.addCriteria((CriteriaDefinition)Criteria.where((String)"dateStr").is((Object)dateStr));
        queryDis.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId));
        queryDis.with(new Sort(Sort.Direction.DESC, new String[]{"createDate"}));
        List distanceList = this.knlMongoTrackDistanceService.find(queryDis);
        Double totalDistance = 0.0;
        for (TrackPointDistanceMongoEntity e : distanceList) {
            totalDistance = totalDistance + e.getDistance();
        }
        BigDecimal b = new BigDecimal(totalDistance / 1000.0);
        totalDistance = b.setScale(2, 4).doubleValue();
        return totalDistance;
    }
}

