/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.monitor.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.monitor.service.RamMonitorMongoService;
import com.biz.eisp.monitor.vo.RamMonitorDataVo;
import com.biz.eisp.monitor.vo.RamMonitorVo;
import com.biz.eisp.tools.DictUtil;
import com.biz.eisp.utils.StringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ramMonitorMongoController"})
public class RamMonitorMongoController {
    @Autowired
    private RamMonitorMongoService ramMonitorMongoService;

    @PostMapping(value={"saveRamMonitor"})
    public AjaxJson<RamMonitorVo> saveRamMonitor(@RequestBody RamMonitorVo ramMonitorVo) {
        AjaxJson ajaxJson = new AjaxJson();
        RamMonitorVo monitorVo = this.ramMonitorMongoService.save(ramMonitorVo, "RamMonitorVo");
        ajaxJson.setObj((Object)monitorVo);
        return ajaxJson;
    }

    @GetMapping(value={"getRamMonitorList"})
    public AjaxJson<RamMonitorVo> getRamMonitorList(@RequestParam(value="applicationName") String applicationName, @RequestParam(value="applicationPort") String applicationPort, @RequestParam(value="applicationIp") String applicationIp) {
        AjaxJson ajaxJson = new AjaxJson();
        String collectionName = "RamMonitorVo";
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"applicationName").is((Object)applicationName));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"applicationPort").is((Object)applicationPort));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"applicationIp").is((Object)applicationIp));
        query.with(new Sort(Sort.Direction.DESC, new String[]{"currentTime"}));
        query.limit(10);
        List<RamMonitorVo> list = this.ramMonitorMongoService.find(query, collectionName);
        ajaxJson.setObjList(list);
        return ajaxJson;
    }

    @PostMapping(value={"getHistoryRamMonitorList"})
    public AjaxJson<RamMonitorDataVo> getHistoryRamMonitorList(@RequestParam(value="beginTime") String beginTime, @RequestParam(value="endTime") String endTime) {
        AjaxJson json = new AjaxJson();
        ArrayList ramMonitorDataVos = new ArrayList();
        List dictList = DictUtil.getDictList((String)"sys_modular");
        dictList.forEach(item -> {
            RamMonitorDataVo ramMonitorDataVo = new RamMonitorDataVo();
            Map extendMap = item.getExtendMap();
            String applicationName = item.getDictValue();
            String applicationPort = "";
            String applicationIp = "";
            if (!extendMap.isEmpty()) {
                applicationPort = String.valueOf(extendMap.get("application_port"));
            }
            try {
                InetAddress address = InetAddress.getLocalHost();
                applicationIp = address.getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            AjaxJson ajaxJson = new AjaxJson();
            String collectionName = "RamMonitorVo";
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"applicationName").is((Object)applicationName));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"applicationPort").is((Object)applicationPort));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"applicationIp").is((Object)applicationIp));
            if (StringUtil.isNotEmpty(beginTime) && StringUtil.isNotEmpty(endTime)) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"currentTime").gte((Object)beginTime).lte((Object)endTime));
            } else {
                GregorianCalendar day = new GregorianCalendar();
                String begin = RamMonitorMongoController.getStartTime(day);
                String end = RamMonitorMongoController.getEndTime(day);
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"currentTime").gte((Object)begin).lte((Object)end));
            }
            query.with(new Sort(Sort.Direction.DESC, new String[]{"currentTime"}));
            List<RamMonitorVo> list = this.ramMonitorMongoService.find(query, collectionName);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                ramMonitorDataVo.setAllMemory(list.get(0).getAllMemory());
                ramMonitorDataVo.setFreeMemory(list.get(0).getFreeMemory());
                ramMonitorDataVo.setMaxMemory(list.get(0).getMaxMemory());
            }
            ramMonitorDataVo.setSysModular(applicationName);
            ramMonitorDataVo.setRamMonitorVos(list);
            ramMonitorDataVos.add(ramMonitorDataVo);
        });
        json.setObjList(ramMonitorDataVos);
        return json;
    }

    public static String getStartTime(Calendar day) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        day.set(11, 0);
        day.set(12, 0);
        day.set(13, 0);
        day.set(14, 0);
        return formatter.format(day.getTime());
    }

    public static String getEndTime(Calendar day) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        day.set(11, 23);
        day.set(12, 59);
        day.set(13, 59);
        day.set(14, 999);
        return formatter.format(day.getTime());
    }

    @GetMapping(value={"dropRamMonitorVo"})
    public AjaxJson dropRamMonitorVo(@RequestParam(value="collectionName") String collectionName) {
        AjaxJson ajaxJson = new AjaxJson();
        this.ramMonitorMongoService.dropRamMonitorVo(collectionName);
        return ajaxJson;
    }
}

