/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.core;

import com.biz.eisp.annotation.QueryField;
import com.biz.eisp.core.BaseMongoDAO;
import com.biz.eisp.utils.ReflectionUtils;
import com.biz.eisp.vo.Page;
import java.lang.reflect.Field;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public abstract class MongoDaoSupport<T>
implements BaseMongoDAO<T> {
    @Autowired
    @Qualifier(value="mongoTemplate")
    protected MongoTemplate mongoTemplate;

    @Override
    public T save(T bean) {
        this.mongoTemplate.save(bean);
        return bean;
    }

    @Override
    public void deleteById(T t) {
        this.mongoTemplate.remove(t);
    }

    @Override
    public void deleteByCondition(T t) {
        Query query = this.buildBaseQuery(t);
        this.mongoTemplate.remove(query, this.getEntityClass());
    }

    @Override
    public void updateById(String id, T t) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        Update update = this.buildBaseUpdate(t);
        this.update(query, update);
    }

    @Override
    public List<T> findByCondition(T t) {
        Query query = this.buildBaseQuery(t);
        return this.mongoTemplate.find(query, this.getEntityClass());
    }

    @Override
    public List<T> find(Query query) {
        return this.mongoTemplate.find(query, this.getEntityClass());
    }

    @Override
    public T findOne(Query query) {
        return (T)this.mongoTemplate.findOne(query, this.getEntityClass());
    }

    @Override
    public void update(Query query, Update update) {
        this.mongoTemplate.updateMulti(query, update, this.getEntityClass());
    }

    @Override
    public T findById(String id) {
        return (T)this.mongoTemplate.findById((Object)id, this.getEntityClass());
    }

    @Override
    public T findById(String id, String collectionName) {
        return (T)this.mongoTemplate.findById((Object)id, this.getEntityClass(), collectionName);
    }

    @Override
    public Page<T> findPage(Page<T> page, Query query) {
        query = query == null ? new Query((CriteriaDefinition)Criteria.where((String)"_id").exists(true)) : query;
        long count = this.count(query);
        page.setTotalCount((int)count);
        int currentPage = page.getCurrentPage();
        int pageSize = page.getPageSize();
        query.skip((long)((currentPage - 1) * pageSize)).limit(pageSize);
        List<T> rows = this.find(query);
        page.build(rows);
        return page;
    }

    @Override
    public long count(Query query) {
        return this.mongoTemplate.count(query, this.getEntityClass());
    }

    private Query buildBaseQuery(T t) {
        Field[] fields;
        Query query = new Query();
        for (Field field : fields = t.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                QueryField queryField;
                Object value = field.get(t);
                if (value == null || (queryField = field.getAnnotation(QueryField.class)) == null) continue;
                query.addCriteria((CriteriaDefinition)queryField.type().buildCriteria(queryField, field, value));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return query;
    }

    private Update buildBaseUpdate(T t) {
        Field[] fields;
        Update update = new Update();
        for (Field field : fields = t.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object value = field.get(t);
                if (value == null) continue;
                update.set(field.getName(), value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return update;
    }

    protected Class<T> getEntityClass() {
        return ReflectionUtils.getSuperClassGenricType(this.getClass());
    }

    @Override
    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }
}

