/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.controller.redisinfo;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.redisInfo.RedisInfoAddMongo;
import com.biz.eisp.service.redisinfo.RedisInfoService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/redisInfoApiController"})
public class RedisInfoApiController {
    private static final Logger log = LoggerFactory.getLogger(RedisInfoApiController.class);
    @Autowired
    private RedisInfoService redisInfoService;

    @PostMapping(value={"addRedisInfo"})
    public AjaxJson addRedisInfo() {
        AjaxJson json = new AjaxJson();
        try {
            this.redisInfoService.addRedisInfo();
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Throwable)e);
            json.setErrMsg("\u63d0\u4ea4\u5931\u8d25:");
        }
        return json;
    }

    @PostMapping(value={"findCurrentRedisInfo"})
    public AjaxJson<RedisInfoAddMongo> findCurrentRedisInfo() {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            RedisInfoAddMongo vo = this.redisInfoService.findCurrentRedisInfo();
            ajaxJson.setObj((Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u83b7\u53d6\u5bf9\u8c61\u5931\u8d25\uff01");
        }
        return ajaxJson;
    }

    @PostMapping(value={"findPeriodRedisInfo"})
    public AjaxJson<RedisInfoAddMongo> delDisplayConfId(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            List<RedisInfoAddMongo> list = this.redisInfoService.findPeriodRedisInfo(startTime, endTime);
            ajaxJson.setList(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff01");
        }
        return ajaxJson;
    }
}

