/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.config;

import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class OperatorInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(OperatorInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        String name = invocation.getMethod().getName();
        log.debug("Exec MethodName is {}", (Object)name);
        SqlCommandType sqlCommandType = null;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof MappedStatement) {
                MappedStatement ms = (MappedStatement)arg;
                sqlCommandType = ms.getSqlCommandType();
                if (sqlCommandType != SqlCommandType.INSERT && sqlCommandType != SqlCommandType.UPDATE) break;
                continue;
            }
            if (arg instanceof Map) {
                Map map = (Map)arg;
                this.putProperty(map, sqlCommandType);
                for (Object value : map.values()) {
                    if (value instanceof Collection) {
                        for (Object e : (Collection)value) {
                            this.setProperty(e, sqlCommandType);
                        }
                        continue;
                    }
                    this.setProperty(value, sqlCommandType);
                }
                continue;
            }
            this.setProperty(arg, sqlCommandType);
        }
        return invocation.proceed();
    }

    private void putProperty(Map map, SqlCommandType sqlCommandType) {
        try {
            UserRedis user = UserUtils.getUser();
            if (user == null) {
                return;
            }
            if (SqlCommandType.INSERT == sqlCommandType) {
                if (map.containsKey("createBy") && StringUtil.isBlank((CharSequence)"createBy")) {
                    map.putIfAbsent("createBy", user.getId());
                }
                if (map.containsKey("createName") && StringUtil.isBlank((CharSequence)"createName")) {
                    map.putIfAbsent("createName", user.getRealname());
                }
                if (map.containsKey("createDate") && StringUtil.isBlank((CharSequence)"createDate")) {
                    map.putIfAbsent("createDate", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (map.containsKey("updateBy") && StringUtil.isBlank((CharSequence)"updateBy")) {
                    map.putIfAbsent("updateBy", user.getId());
                }
                if (map.containsKey("updateName") && StringUtil.isBlank((CharSequence)"updateName")) {
                    map.putIfAbsent("updateName", user.getRealname());
                }
                if (map.containsKey("updateDate") && StringUtil.isBlank((CharSequence)"updateDate")) {
                    map.putIfAbsent("updateDate", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (map.containsKey("positionCode") && StringUtil.isBlank((CharSequence)"positionCode")) {
                    map.putIfAbsent("positionCode", user.getPosCode());
                }
                if (map.containsKey("positionName") && StringUtil.isBlank((CharSequence)"positionName")) {
                    map.putIfAbsent("positionName", user.getPosName());
                }
                if (map.containsKey("orgCode") && StringUtil.isBlank((CharSequence)"orgCode")) {
                    map.putIfAbsent("orgCode", user.getPosName());
                }
            } else if (SqlCommandType.UPDATE == sqlCommandType) {
                map.putIfAbsent("updateBy", user.getId());
                map.putIfAbsent("updateName", user.getRealname());
                map.putIfAbsent("updateDate", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void setProperty(Object obj, SqlCommandType sqlCommandType) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return;
        }
        try {
            UserRedis user = UserUtils.getUser();
            if (user == null) {
                return;
            }
            if (SqlCommandType.INSERT == sqlCommandType) {
                Map mapProperty = BeanUtils.describe((Object)obj);
                if (mapProperty.containsKey("createBy") && StringUtil.isBlank((CharSequence)((CharSequence)mapProperty.get("createBy")))) {
                    BeanUtils.setProperty((Object)obj, (String)"createBy", (Object)user.getId());
                }
                if (mapProperty.containsKey("createName") && StringUtil.isBlank((CharSequence)((CharSequence)mapProperty.get("createName")))) {
                    BeanUtils.setProperty((Object)obj, (String)"createName", (Object)user.getRealname());
                }
                if (mapProperty.containsKey("createDate") && StringUtil.isBlank((CharSequence)((CharSequence)mapProperty.get("createDate")))) {
                    BeanUtils.setProperty((Object)obj, (String)"createDate", (Object)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (mapProperty.containsKey("updateBy") && StringUtil.isBlank((CharSequence)((CharSequence)mapProperty.get("updateBy")))) {
                    BeanUtils.setProperty((Object)obj, (String)"updateBy", (Object)user.getId());
                }
                if (mapProperty.containsKey("updateName") && StringUtil.isBlank((CharSequence)((CharSequence)mapProperty.get("updateName")))) {
                    BeanUtils.setProperty((Object)obj, (String)"updateName", (Object)user.getRealname());
                }
                if (mapProperty.containsKey("updateDate") && StringUtil.isBlank((CharSequence)((CharSequence)mapProperty.get("updateDate")))) {
                    BeanUtils.setProperty((Object)obj, (String)"updateDate", (Object)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (mapProperty.containsKey("positionCode") && StringUtil.isBlank((CharSequence)((CharSequence)mapProperty.get("positionCode")))) {
                    BeanUtils.setProperty((Object)obj, (String)"positionCode", (Object)user.getPosCode());
                }
                if (mapProperty.containsKey("positionName") && StringUtil.isBlank((CharSequence)((CharSequence)mapProperty.get("positionName")))) {
                    BeanUtils.setProperty((Object)obj, (String)"positionName", (Object)user.getPosName());
                }
                if (mapProperty.containsKey("orgCode") && StringUtil.isBlank((CharSequence)((CharSequence)mapProperty.get("orgCode")))) {
                    BeanUtils.setProperty((Object)obj, (String)"orgCode", (Object)user.getOrgCode());
                }
            } else if (SqlCommandType.UPDATE == sqlCommandType) {
                BeanUtils.setProperty((Object)obj, (String)"updateBy", (Object)user.getId());
                BeanUtils.setProperty((Object)obj, (String)"updateName", (Object)user.getRealname());
                BeanUtils.setProperty((Object)obj, (String)"updateDate", (Object)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

