/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.monitor;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.SysParamUtil;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.monitor.vo.RamMonitorVo;
import com.biz.eisp.parameter.entity.KnlParameterManageEntity;
import com.biz.eisp.ram.RamMonitorFeign;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class RamMonitorScheduledTask {
    private static final Logger log = LoggerFactory.getLogger(RamMonitorScheduledTask.class);
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Value(value="${server.port}")
    private String applicationPort;
    private static RamMonitorFeign ramMonitorFeign;

    private static void initFein() {
        if (ramMonitorFeign == null) {
            ramMonitorFeign = (RamMonitorFeign)SpringApplicationContextUtil.getApplicationContext().getBean("ramMonitorFeign");
        }
    }

    @Scheduled(fixedRate=120000L)
    public AjaxJson<RamMonitorVo> getMonitorInfo() {
        String isopenRamMonitor;
        AjaxJson ajaxJson = new AjaxJson();
        KnlParameterManageEntity knlParameterManageEntity = SysParamUtil.getPatamByCode((String)"isopen_ram_monitor");
        String string = isopenRamMonitor = knlParameterManageEntity == null ? "N" : knlParameterManageEntity.getParameterValue();
        if (StringUtil.equals((String)isopenRamMonitor, (String)"Y")) {
            RamMonitorVo sysMonitorVo = new RamMonitorVo();
            sysMonitorVo.setApplicationName(this.applicationName);
            sysMonitorVo.setApplicationPort(this.applicationPort);
            try {
                InetAddress address = InetAddress.getLocalHost();
                sysMonitorVo.setApplicationIp(address.getHostAddress());
            }
            catch (UnknownHostException e) {
                log.error("", (Throwable)e);
            }
            MemoryMXBean memorymbean = ManagementFactory.getMemoryMXBean();
            MemoryUsage memoryUsage = memorymbean.getHeapMemoryUsage();
            BigDecimal bigDecimal1024 = new BigDecimal(1024);
            DecimalFormat df1 = new DecimalFormat("0.00");
            long heapInitLong = memoryUsage.getInit();
            BigDecimal bigDecimalHeapInit = new BigDecimal(heapInitLong);
            String heapInit = df1.format(bigDecimalHeapInit.divide(bigDecimal1024).divide(bigDecimal1024));
            sysMonitorVo.setHeapInit(heapInit);
            long heapMaxLong = memoryUsage.getMax();
            BigDecimal bigDecimalHeapMax = new BigDecimal(heapMaxLong);
            String heapMax = df1.format(bigDecimalHeapMax.divide(bigDecimal1024).divide(bigDecimal1024));
            sysMonitorVo.setHeapMax(heapMax);
            long heapUsedLong = memoryUsage.getUsed();
            BigDecimal bigDecimalHeapUsed = new BigDecimal(heapUsedLong);
            String heapUsed = df1.format(bigDecimalHeapUsed.divide(bigDecimal1024).divide(bigDecimal1024));
            sysMonitorVo.setHeapUsed(heapUsed);
            long heapCommittedLong = memoryUsage.getCommitted();
            BigDecimal bigDecimalHeapCommitted = new BigDecimal(heapCommittedLong);
            String heapCommitted = df1.format(bigDecimalHeapCommitted.divide(bigDecimal1024).divide(bigDecimal1024));
            sysMonitorVo.setHeapCommitted(heapCommitted);
            MemoryUsage memoryUsage1 = memorymbean.getNonHeapMemoryUsage();
            long methodAreaInitLong = memoryUsage1.getInit();
            BigDecimal bigDecimalMethodAreaInit = new BigDecimal(methodAreaInitLong);
            String methodAreaInit = df1.format(bigDecimalMethodAreaInit.divide(bigDecimal1024).divide(bigDecimal1024));
            sysMonitorVo.setMethodAreaInit(methodAreaInit);
            long methodAreaUsedLong = memoryUsage1.getUsed();
            BigDecimal bigDecimalMethodAreaUsed = new BigDecimal(methodAreaUsedLong);
            String methodAreaUsed = df1.format(bigDecimalMethodAreaUsed.divide(bigDecimal1024).divide(bigDecimal1024));
            sysMonitorVo.setMethodAreaUsed(methodAreaUsed);
            long methodAreaCommittedLong = memoryUsage1.getCommitted();
            BigDecimal bigDecimalMethodAreaCommitted = new BigDecimal(methodAreaCommittedLong);
            String methodAreaCommitted = df1.format(bigDecimalMethodAreaCommitted.divide(bigDecimal1024).divide(bigDecimal1024));
            sysMonitorVo.setMethodAreaCommitted(methodAreaCommitted);
            long methodAreaMaxLong = memoryUsage1.getMax();
            BigDecimal bigDecimalMethodAreaMax = new BigDecimal(methodAreaMaxLong);
            String methodAreaMax = df1.format(bigDecimalMethodAreaMax.divide(bigDecimal1024).divide(bigDecimal1024));
            sysMonitorVo.setMethodAreaMax(methodAreaMax);
            List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
            long totle = Runtime.getRuntime().totalMemory();
            BigDecimal bigDecimaltotle = new BigDecimal(totle);
            String allMemory = df1.format(bigDecimaltotle.divide(bigDecimal1024).divide(bigDecimal1024));
            sysMonitorVo.setAllMemory(allMemory);
            long free = Runtime.getRuntime().freeMemory();
            BigDecimal bigDecimalfree = new BigDecimal(free);
            String freeMemory = df1.format(bigDecimalfree.divide(bigDecimal1024).divide(bigDecimal1024));
            sysMonitorVo.setFreeMemory(freeMemory);
            long max = Runtime.getRuntime().maxMemory();
            BigDecimal bigDecimalmax = new BigDecimal(max);
            String maxMemory = df1.format(bigDecimalmax.divide(bigDecimal1024).divide(bigDecimal1024));
            sysMonitorVo.setMaxMemory(maxMemory);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sysMonitorVo.setCurrentTime(formatter.format(new Date()));
            RamMonitorScheduledTask.initFein();
            ajaxJson = ramMonitorFeign.saveRamMonitor(sysMonitorVo);
        }
        return ajaxJson;
    }
}

