/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="redisService")
public class RedisService {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setSeconds(String key, Object value, long time) {
        if (time == 0L) {
            return false;
        }
        try {
            this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setMinutes(String key, Object value, long time) {
        if (time == 0L) {
            return false;
        }
        try {
            this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.MINUTES);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setHours(String key, Object value, long time) {
        if (time == 0L) {
            return false;
        }
        try {
            this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.HOURS);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setDays(String key, Object value, long time) {
        if (time == 0L) {
            return false;
        }
        try {
            this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.DAYS);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public List hvals(String key) {
        return this.redisTemplate.opsForHash().values((Object)key);
    }

    public DataType type(String key) {
        return this.redisTemplate.type((Object)key);
    }
}

