/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class LockUtils {
    private static final Logger log = LoggerFactory.getLogger(LockUtils.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    private static final int defaultExpire = 120;

    public boolean lock(String key) {
        return this.lock2(key, 120);
    }

    public boolean lock2(String key, int expire) {
        Object oldValue;
        long val = System.currentTimeMillis() + (long)(expire * 1000);
        String value = String.valueOf(val);
        if (this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value).booleanValue()) {
            return true;
        }
        Object currentValue = this.redisTemplate.opsForValue().get((Object)key);
        return currentValue != null && Long.parseLong(currentValue.toString()) < System.currentTimeMillis() && (oldValue = this.redisTemplate.opsForValue().getAndSet((Object)key, (Object)value)) != null && oldValue.toString().equals(currentValue.toString());
    }

    public void unLock(String key) {
        try {
            Object currentValue = this.redisTemplate.opsForValue().get((Object)key);
            if (currentValue != null) {
                this.redisTemplate.opsForValue().getOperations().delete((Object)key);
            }
        }
        catch (Exception e) {
            log.error("\u3010redis\u5206\u5e03\u5f0f\u9501\u3011\u89e3\u9501\u5f02\u5e38, {}", (Throwable)e);
        }
    }
}

