/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.monitor.endpoint;

import com.biz.eisp.api.feign.ram.RamMonitorFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.service.RedisService;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/monitor/{sid}")
public class RamMonitorEndpoint {
    private static final Logger log = LoggerFactory.getLogger(RamMonitorEndpoint.class);
    private static RamMonitorFeign ramMonitorFeign;
    private static RedisService redisService;
    private static CopyOnWriteArraySet<RamMonitorEndpoint> webSocketSet;
    private Session session;
    private String sid = "";

    private static void initFein() {
        if (ramMonitorFeign == null) {
            ramMonitorFeign = (RamMonitorFeign)SpringApplicationContextUtil.getApplicationContext().getBean("ramMonitorFeign");
        }
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="sid") String sid) {
        this.session = session;
        webSocketSet.add(this);
        RamMonitorEndpoint.updateCount(1);
        log.info("\u6709\u65b0\u7a97\u53e3\u5f00\u59cb\u76d1\u542c:" + sid + "");
        this.sid = sid;
    }

    @OnClose
    public void onClose() {
        webSocketSet.remove(this);
        RamMonitorEndpoint.updateCount(-1);
        log.info("\u6709\u4e00\u8fde\u63a5\u5173\u95ed\uff01");
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        log.info("\u6536\u5230\u6765\u81ea\u7a97\u53e3" + this.sid + "\u7684\u4fe1\u606f:" + message);
        for (RamMonitorEndpoint item : webSocketSet) {
            try {
                item.sendMessage(message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        log.error("\u53d1\u751f\u9519\u8bef");
        error.printStackTrace();
    }

    public void sendMessage(String message) throws IOException {
        this.session.getBasicRemote().sendText(message);
    }

    public static AjaxJson sendInfo(String message) throws IOException {
        AjaxJson ajaxJson = new AjaxJson();
        boolean flag = false;
        for (RamMonitorEndpoint item : webSocketSet) {
            try {
                item.sendMessage(message);
                flag = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!flag) {
            ajaxJson.setErrMsg("\u6d88\u606f\u63a8\u9001\u5931\u8d25");
        }
        return ajaxJson;
    }

    public static Integer getOnlineCount() {
        Object object;
        if (redisService == null) {
            redisService = (RedisService)SpringApplicationContextUtil.getApplicationContext().getBean("redisService");
        }
        if ((object = redisService.get("GLOBAL_USER_COUNT_")) == null) {
            return 0;
        }
        return Integer.valueOf(object.toString());
    }

    public static synchronized void updateCount(Integer count) {
        Integer nowCount = RamMonitorEndpoint.getOnlineCount();
        nowCount = nowCount + count;
        redisService.setDays("GLOBAL_USER_COUNT_", (Object)nowCount, 1L);
    }

    static {
        webSocketSet = new CopyOnWriteArraySet();
    }
}

