/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.user.endpoint;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserLoginRedis;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.service.RedisService;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/user/{sid}")
public class UserEndpoint {
    private static final Logger log = LoggerFactory.getLogger(UserEndpoint.class);
    private static RedisService redisService;
    private static CopyOnWriteArraySet<UserEndpoint> webSocketSet;
    private Session session;
    private String sid = "";

    @OnOpen
    public void onOpen(Session session, @PathParam(value="sid") String sid) {
        this.session = session;
        webSocketSet.add(this);
        UserEndpoint.updateCount(1);
        log.info("\u6709\u65b0\u7a97\u53e3\u5f00\u59cb\u76d1\u542c:" + sid + "");
        this.sid = sid;
        this.saveUser(sid);
    }

    public void saveUser(String sid) {
        Object object = redisService.get("WEBSOCKT_KEY_" + sid);
        if (object == null) {
            return;
        }
        String key = object.toString();
        UserRedis userRedis = UserUtils.getUser((String)key);
        if (userRedis == null) {
            return;
        }
        UserLoginRedis userLoginRedis = new UserLoginRedis();
        BeanUtils.copyProperties((Object)userRedis, (Object)userLoginRedis);
        userLoginRedis.setToken(key);
        userLoginRedis.setLoginTime(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        userLoginRedis.setId(sid);
        String userKey = "GLOBAL_USER_";
        redisService.hset(userKey, sid, (Object)userLoginRedis);
    }

    @OnClose
    public void onClose() {
        String userKey = "GLOBAL_USER_";
        redisService.hdel(userKey, new Object[]{this.sid});
        webSocketSet.remove(this);
        UserEndpoint.updateCount(-1);
        log.info("\u6709\u4e00\u8fde\u63a5\u5173\u95ed\uff01");
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        log.info("\u6536\u5230\u6765\u81ea\u7a97\u53e3" + this.sid + "\u7684\u4fe1\u606f:" + message);
        for (UserEndpoint item : webSocketSet) {
            try {
                item.sendMessage(message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        log.error("\u53d1\u751f\u9519\u8bef");
        error.printStackTrace();
    }

    public void sendMessage(String message) throws IOException {
        this.session.getBasicRemote().sendText(message);
    }

    public static AjaxJson sendInfo(String message, @PathParam(value="sid") String sid) throws IOException {
        AjaxJson ajaxJson = new AjaxJson();
        log.info("\u63a8\u9001\u6d88\u606f\u5230\u7a97\u53e3" + sid + "\uff0c\u63a8\u9001\u5185\u5bb9:" + message);
        if (StringUtil.isEmpty((String)sid)) {
            ajaxJson.setErrMsg("excel\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        boolean flag = false;
        for (UserEndpoint item : webSocketSet) {
            try {
                if (!item.sid.equals(sid)) continue;
                item.sendMessage(message);
                flag = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!flag) {
            ajaxJson.setErrMsg("\u7528\u6237\u5df2\u4e0b\u7ebf,\u6d88\u606f\u63a8\u9001\u5931\u8d25");
        }
        return ajaxJson;
    }

    public static Integer getOnlineCount() {
        Object object;
        if (redisService == null) {
            redisService = (RedisService)SpringApplicationContextUtil.getApplicationContext().getBean("redisService");
        }
        if ((object = redisService.get("GLOBAL_USER_COUNT_")) == null) {
            return 0;
        }
        return Integer.valueOf(object.toString());
    }

    public static synchronized void updateCount(Integer count) {
        Integer nowCount = UserEndpoint.getOnlineCount();
        nowCount = nowCount + count;
        redisService.setDays("GLOBAL_USER_COUNT_", (Object)nowCount, 1L);
    }

    static {
        webSocketSet = new CopyOnWriteArraySet();
    }
}

