/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.api.controller;

import com.alibaba.fastjson.JSON;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.monitor.endpoint.RamMonitorEndpoint;
import com.biz.eisp.monitor.vo.RamMonitorDataVo;
import com.biz.eisp.monitor.vo.RamMonitorVo;
import com.biz.eisp.ram.RamMonitorFeign;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"websocket-\u6d88\u606f\u63a8\u9001"}, description="websocket-\u6d88\u606f\u63a8\u9001")
@RestController
@RequestMapping(value={"/websocketApi/ramMonitorApiController"})
public class RamMonitorApiController {
    private static final Logger log = LoggerFactory.getLogger(RamMonitorApiController.class);
    private static RamMonitorFeign ramMonitorFeign;

    private static void initFein() {
        if (ramMonitorFeign == null) {
            ramMonitorFeign = (RamMonitorFeign)SpringApplicationContextUtil.getApplicationContext().getBean("ramMonitorFeign");
        }
    }

    @ApiOperation(value="Ram\u76d1\u63a7\u6d88\u606f\u63a8\u9001", httpMethod="POST")
    @RequestMapping(value={"/sendRamMessage"}, method={RequestMethod.POST})
    public AjaxJson sendRamMessage(@RequestBody List<RamMonitorVo> ramMonitorVos) {
        AjaxJson ajaxJson = new AjaxJson();
        ArrayList ramMonitorDataVos = new ArrayList();
        try {
            RamMonitorApiController.initFein();
            ramMonitorVos.forEach(item -> {
                RamMonitorDataVo ramMonitorDataVo = new RamMonitorDataVo();
                AjaxJson j = ramMonitorFeign.getRamMonitorList(item.getApplicationName(), item.getApplicationPort(), item.getApplicationIp());
                ramMonitorDataVo.setSysModular(item.getApplicationName());
                if (j.isSuccess()) {
                    ramMonitorDataVo.setRamMonitorVos(j.getObjList());
                    if (CollectionUtil.listNotEmptyNotSizeZero((List)j.getObjList())) {
                        ramMonitorDataVo.setAllMemory(((RamMonitorVo)j.getObjList().get(0)).getAllMemory());
                        ramMonitorDataVo.setMaxMemory(((RamMonitorVo)j.getObjList().get(0)).getMaxMemory());
                        ramMonitorDataVo.setFreeMemory(((RamMonitorVo)j.getObjList().get(0)).getFreeMemory());
                        ramMonitorDataVos.add(ramMonitorDataVo);
                    }
                }
            });
            ajaxJson = RamMonitorEndpoint.sendInfo(JSON.toJSONString(ramMonitorDataVos));
        }
        catch (IOException e) {
            ajaxJson.setErrMsg("\u63a8\u9001\u5931\u8d25");
            e.printStackTrace();
        }
        return ajaxJson;
    }
}

