/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.api.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserLoginRedis;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.user.endpoint.UserEndpoint;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5728\u7ebf\u7528\u6237\u7ba1\u7406"}, description="\u5728\u7ebf\u7528\u6237\u7ba1\u7406")
@RestController
@RequestMapping(value={"/websocketApi/onlieUserApiController"})
public class OnlieUserApiController {
    private static final Logger log = LoggerFactory.getLogger(OnlieUserApiController.class);
    @Autowired
    private RedisService redisService;

    @ApiOperation(value="\u83b7\u53d6\u5728\u7ebf\u7528\u6237", httpMethod="POST")
    @RequestMapping(value={"/getOnlieUserList"}, method={RequestMethod.POST})
    public List<UserLoginRedis> getOnlieUserList(@RequestBody UserLoginRedis userLoginRedis) {
        ArrayList<UserLoginRedis> loginRedis = new ArrayList<UserLoginRedis>();
        CopyOnWriteArraySet<UserEndpoint> userEndpoints = UserEndpoint.getWebSocketSet();
        if (userEndpoints != null) {
            userEndpoints.forEach(item -> {
                UserLoginRedis userLoginRedisTemp = item.userLoginRedis;
                if (userLoginRedisTemp != null) {
                    loginRedis.add(userLoginRedisTemp);
                }
            });
        }
        Collections.sort(loginRedis, Comparator.comparing(UserLoginRedis::getLoginTime).reversed().thenComparing(UserLoginRedis::getId));
        return loginRedis;
    }

    @ApiOperation(value="\u8e22\u51fa\u5728\u7ebf\u7528\u6237", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5728\u7ebf\u7528\u6237sid", required=true, dataType="String", paramType="path")})
    @RequestMapping(value={"/offLineUser/{id}"}, method={RequestMethod.GET})
    public AjaxJson offLineUser(@PathVariable(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            UserEndpoint.sendInfo("\u4f60\u5df2\u7ecf\u88ab\u8feb\u4e0b\u7ebf\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55", id);
            UserEndpoint.offLineUser(id);
        }
        catch (Exception e) {
            ajaxJson.setErrMsg("\u8e22\u51fa\u7528\u6237\u5931\u8d25");
            log.error("", (Throwable)e);
        }
        return ajaxJson;
    }

    @RequestMapping(value={"/sendMsgUser/{id}"}, method={RequestMethod.GET})
    public AjaxJson sendMsgUser(@PathVariable(value="id") String id, @RequestParam(value="msg") String msg) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            ajaxJson = UserEndpoint.sendInfo(msg, id);
        }
        catch (Exception e) {
            ajaxJson.setErrMsg("\u6d88\u606f\u53d1\u9001\u5931\u8d25");
            log.error("", (Throwable)e);
        }
        return ajaxJson;
    }

    @RequestMapping(value={"/getOnLineUser/{id}"}, method={RequestMethod.GET})
    public AjaxJson<UserLoginRedis> getOnLineUser(@PathVariable(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            UserLoginRedis userLoginRedis = UserEndpoint.getOnLineUser(id);
            ajaxJson.setObj((Object)userLoginRedis);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ajaxJson;
    }
}

