/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.withholding;

import com.alibaba.fastjson.JSON;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.vo.CacheEntityVo;
import com.biz.eisp.service.RedisService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/withholding/{sid}")
public class Withholdingpoint {
    private static final Logger log = LoggerFactory.getLogger(Withholdingpoint.class);
    private static RedisService redisService;
    private static CopyOnWriteArraySet<Withholdingpoint> webSocketSet;
    private Session session;
    private String sid = "";

    @OnOpen
    public void onOpen(Session session, @PathParam(value="sid") String sid) {
        this.session = session;
        webSocketSet.add(this);
        log.info("\u6709\u65b0\u7a97\u53e3\u5f00\u59cb\u76d1\u542c:" + sid + "");
        this.sid = sid;
    }

    @OnClose
    public void onClose() {
        webSocketSet.remove(this);
        log.info("\u6709\u4e00\u8fde\u63a5\u5173\u95ed\uff01");
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        log.info("\u6536\u5230\u6765\u81ea\u7a97\u53e3" + this.sid + "\u7684\u4fe1\u606f:" + message);
        for (Withholdingpoint item : webSocketSet) {
            try {
                item.sendMessage(message);
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable error) {
        log.error("\u53d1\u751f\u9519\u8bef");
        error.printStackTrace();
    }

    public void sendMessage(String message) throws IOException {
        this.session.getBasicRemote().sendText(message);
    }

    public static AjaxJson sendInfo(ArrayList<CacheEntityVo> list, @PathParam(value="sid") String sid) throws IOException {
        AjaxJson ajaxJson = new AjaxJson();
        log.info("\u63a8\u9001\u6d88\u606f\u5230\u7a97\u53e3" + sid + "\uff0c\u63a8\u9001\u5185\u5bb9:" + JSON.toJSONString(list));
        if (StringUtil.isEmpty((String)sid)) {
            ajaxJson.setErrMsg("\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        boolean flag = false;
        for (Withholdingpoint item : webSocketSet) {
            try {
                if (!item.sid.equals(sid)) continue;
                item.sendMessage(JSON.toJSONString(list));
                flag = true;
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        if (!flag) {
            ajaxJson.setErrMsg("\u6d88\u606f\u63a8\u9001\u5931\u8d25");
        }
        return ajaxJson;
    }

    static {
        webSocketSet = new CopyOnWriteArraySet();
    }
}

