<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>买赠_产品+价格组</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        #content {
            padding :0!important;
        }
        .layout-split-north {
            border-bottom: 1px solid #ffffff;
        }
        .biz-tags-box {
            width: 1000px;
            min-height: 100px;
        }
    </style>
    <script type="text/javascript" src="/resources/actprice/price.js"></script>
</head>
<body class="easyui-layout">
<div data-options="region:'north',split:true" style="height:200px;">
    <t:formvalid action="/act/ttActPriceController/saveOrUpdate" layout="div"
                 dialog="true" formid="buyProductForm">
        <t:dgFormList layoutStyle="horizontal" >
            <t:dgFormColumn field="categoriesCode" hidden="true" defaultVal="${categoriesCode}" formClass="form" labelName="categoriesCode" optionType="input" required="false"/>
            <t:dgFormColumn field="actSubclassName" hidden="false" formClass="biz-col-33 mb5 form" labelName="活动细类" optionType="choseDialog" required="true"
                            onclick="selectActSubClass()" />
            <t:dgFormColumn field="actSubclassCode" hidden="true" formClass="biz-col-33 mb5 form" labelName="活动细类" optionType="input" required="true"
            />
            <t:dgFormColumn field="productNum" hidden="false" formClass="biz-col-33 mb5 form" labelName="本品数量" optionType="input" required="true"
                            />
            <t:dgFormColumn field="giftNum" hidden="false" formClass="biz-col-33 mb5 form" labelName="赠品数量" optionType="input" required="true"
            />
            <t:dgFormColumn field="priceGroup" hidden="false" formClass="biz-col-33 mb5 form" labelName="价格组" optionType="select" required="true"
                             typeGroupCode="price_group" />
            <t:dgFormColumn field="isStack" hidden="false" formClass="form" labelName="是否叠加" optionType="radio" typeGroupCode="is_no" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="giftName_1" hidden="false"  formClass="form" labelName="赠品" optionType="tags"  required="false"
                            formTags="${vo.orgFormTags}"  onclick="selectProductGiftCheck();"  />
            <t:dgFormColumn field="giftCostPrice" hidden="true" formClass="biz-col-33 mb5 form" labelName="赠品最高成本价" optionType="input" required="false"
            />
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">
    <t:datagrid name="productDetailList" checkbox="true" fitColumns="false" idField="id" fit="true" singleSelect="false"
                queryMode="group"
                actionUrl=""
                pagination="false" autoLoadData="false"
    >
        <t:dgCol title="id" field="id" hidden="true"/>
        <t:dgCol title="商品编码" field="productInfoCode"   width="150"/>
        <t:dgCol title="商品名称" field="productInfoName" width="250"/>
        <t:dgCol title="标准价" field="standPrice" width="100"/>
        <t:dgCol title="预计销量" field="forecastSalesNum" editor="{type:'numberbox',options:{min:0,value:'',missingMessage:'预计销量必填',required:'true'}}" width="100"/>
        <t:dgCol title="预计销售额" field="forecastSalesAmount" width="100"/>
        <t:dgCol title="申请费用金额" field="amount" width="100"/>
        <t:dgCol title="比例" field="scale"  width="100"/>
        <t:dgToolBar title="选择商品" funname="selectProductCheck" icon="icon-add"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="编辑" funname="updateProductDetail" icon="icon-edit"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="删除" funname="delProductDetail" icon="icon-remove"
                     url=""></t:dgToolBar>
    </t:datagrid>
</div>
</body>

</html>

<script>
    //赠品array
    var giftArray = [];
    $(function () {
        $("#giftName_1").on('click', '.biz-tag-close', function () {
            //删除了复选框中的某一个对象后重新获得赠品的价格
            $(this).parent().remove();
            var wareCode = $(this).parent().attr("code");
            giftArray.forEach(function (item,index) {
                if (item.code == wareCode) {
                    giftArray.splice(index,1);
                }
            })
            console.log(giftArray);
            if (giftArray.length > 0) {
                giftArray.sort(function (a, b) {
                    return b.costPrice - a.costPrice;
                });
                console.log(giftArray[0].costPrice);
                $("#giftCostPrice").val(giftArray[0].costPrice);
            }else{
                $("#giftCostPrice").val("");
            }
            //重新计算产品明细中的值
            forecastSalesNumblurAll();
        });
        $('#productDetailList').datagrid({
            onDblClickCell: function(index,field,value){
                if(field=="forecastSalesNum"){
                    initEditor(index);
                }else{
                    endEidtProductDetail();
                    forecastSalesNumblurAll();
                }

            }
        });
        var edit = '${edit}';
        if(edit=="0"){
            var rows = parent.getPaData();
            $("#actSubclassName").val(rows[0].actSubclassName);
            $("#actSubclassCode").val(rows[0].actSubclassCode);
            $("#productNum").val(rows[0].productNum);
            $("#giftNum").val(rows[0].giftNum);
            $("#giftCostPrice").val(rows[0].giftCostPrice);
            $("#priceGroup").val(rows[0].priceGroup);
            $('input[name=isStack][value="' + rows[0].isStack + '"]').attr("checked",true);
            var giftJson = rows[0].giftJson;
            if(!isEmpty(giftJson)){
                var myobj = JSON.parse(giftJson);
                var tagArray = [];
                $(myobj).each(function(index,item){
                    var tag = {};
                    tag["name"] = item.name;
                    tag["code"] = item.code;
                    tagArray.push(tag);
                });
                renderTag("giftName_1", tagArray);
            }
            console.log(rows)
            $('#productDetailList').datagrid('insertRow',{
                index: 0,
                row: {
                    id:rows[0].id,
                    productInfoCode: rows[0].productCode,
                    productInfoName: rows[0].productName,
                    standPrice:rows[0].standPrice,
                    forecastSalesNum:rows[0].forecastSalesNum,
                    forecastSalesAmount:rows[0].forecastSalesAmount,
                    amount:rows[0].amount,
                    scale:rows[0].scale
                }
            });
            initEditor(0);
        }

    });
    //选择活动细类
    function selectActSubClass(){
        var tableType = "act_price";
        var categoriesCode = $("#categoriesCode").val();
        triggerId = "actSubclassCode";
        triggerName = "actSubclassName";
        url = "/page/ttApiFineController/goApiActFineMain?tableType="+tableType+"&categoriesCode="+categoriesCode;
        width = 1000;
        height = 450;
        id = "actSubclassList";
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: width,
            height: height,
            title: '新增',
            opacity: 0.3,
            zIndex:2600,
            parent:'addProductDetailDialog',
            id:'addProductDetailDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        var myobj=eval(rowsData);
                        $("#" + triggerId).val(myobj[0].fineCode);
                        $("#" + triggerName).val(myobj[0].fineName);
                        $("#actSubclassName").focus();
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    //选择产品
    function selectProductCheck() {
        selectProduct();
    }
    /* 选择赠品 */
    function selectProductGiftCheck() {
        selectgiftProduct();
    }

    function selectgiftProduct(){
        //查询成本价大于0的产品，costPriceGreaterZero为成本价大于0查询字段
        url = "/page/tmApiWareController/goCostPriceWareListMain?check=false";
        width = 1000;
        height = 450;
        id = "wareCostList";
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: width,
            height: height,
            title: '新增',
            opacity: 0.3,
            zIndex:2600,
            parent:'selectProductDialog',
            id:'selectProductDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        var myobj=eval(rowsData);
                        $(myobj).each(function(index,item){
                            var tag = {};
                            tag["name"] = item.wareName;
                            tag["code"] = item.wareCode;
                            tag["costPrice"] = item.costPrice;
                            giftArray.push(tag);
                        });

                        renderTag("giftName_1", giftArray);
                        if (giftArray.length > 0) {
                            giftArray.sort(function (a, b) {
                                return b.costPrice - a.costPrice;
                            });
                            console.log(giftArray[0].costPrice);
                            $("#giftCostPrice").val(giftArray[0].costPrice);
                            //重新计算产品明细中的值
                            forecastSalesNumblurAll();
                        }
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    //清空复选框
    function clearTags(event) {
        $("#giftCostPrice").val("");
        $(event).parents(".biz-tags-box").find(".biz-tags-content").html("");
        giftArray = [];
        //重新计算产品明细中的值
        forecastSalesNumblurAll();
    }

    function selectProduct(){
        var dictValue = '${dictValue}';
        var rowsDatas = $('#productDetailList').datagrid('getRows');
        //赠品数量
        var giftNum = $("#giftNum").val();
        //本品数量
        var productNum = $("#productNum").val();
        //赠品成本价
        var giftCostPrice = $("#giftCostPrice").val();
        if (productNum == "") {
            tip("请填写本品数量");
            return;
        }
        if (giftNum == "") {
            tip("请填写赠品数量");
            return;
        }
        if (giftCostPrice == "") {
            tip("请选择赠品");
            return;
        }
        var priceGroup = $("#priceGroup").val();
        if (priceGroup == "") {
            tip("请选择价格组");
            return;
        }
        url = "/page/tmApiWareController/goStandPriceWareListMain?check=false&priceGroup="+priceGroup;
        width = 1000;
        height = 450;
        id = "wareList";
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: width,
            height: height,
            title: '新增',
            opacity: 0.3,
            zIndex:2600,
            parent:'selectProductDialog',
            id:'selectProductDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        if (dictValue == "Y") {
                            for(var i=0;i<rowsData.length;i++){
                                $('#productDetailList').datagrid('insertRow',{
                                    index: 0,
                                    row: {
                                        id:generateUUID(),
                                        productInfoCode: rowsData[i].wareCode,
                                        productInfoName: rowsData[i].wareName,
                                        standPrice:rowsData[i].standPrice
                                    }
                                });
                            }
                        }else{
                            rowsData.forEach(function(item,index){
                                if(!isContain(item,rowsDatas)){
                                    $('#productDetailList').datagrid('insertRow',{
                                        index: 0,
                                        row: {
                                            id:generateUUID(),
                                            productInfoCode: rowsData[index].wareCode,
                                            productInfoName: rowsData[index].wareName,
                                            standPrice:rowsData[index].standPrice
                                        }
                                    });
                                }
                            });
                        }
                        editorAll();
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    function isContain(obj,arr2) {
        let contain = false;
        arr2.forEach(function(item2){
            if(obj.wareCode==item2.productInfoCode){
                contain = true;
                return false;
            }
        })
        return contain;
    }

    function forecastSalesNumblurAll() {
        var rows = $('#productDetailList').datagrid('getRows');
        for(var i=0;i<rows.length;i++){
            var index = i;
            var rows = $('#productDetailList').datagrid('getRows');
            var row = rows[index];
            //标准价
            var standPrice = row.standPrice;
            //预计销量
            var forecastSalesNum = row.forecastSalesNum;
            //预计销售额(标准价*预计销量)
            var forecastSalesAmount = numMulti(standPrice,forecastSalesNum);
            //赠品最高成本价
            var giftCostPrice = $("#giftCostPrice").val();
            //赠品数量
            var giftNum = $("#giftNum").val();
            //本品数量
            var productNum = $("#productNum").val();
            $('#productDetailList').datagrid('endEdit' ,index);
            if (!isEmpty(forecastSalesNum)) {
                //申请费用金额(赠品最高成本*（赠品数量*(预计销量/本品数量)（向下取整））)
                var amount = numMulti(numMulti(Math.floor(numDiv(forecastSalesNum,productNum)),giftNum),giftCostPrice);
                amount = returnFloat(amount);
                var scale = numDiv(amount,forecastSalesAmount);
                scale = returnFloat(scale);
                $('#productDetailList').datagrid('updateRow',{
                    index: index,
                    row: {
                        amount:amount,
                        forecastSalesAmount:forecastSalesAmount,
                        scale:scale,
                        forecastSalesNum:forecastSalesNum
                    }
                });
            }
        }
        editorAll();
    }

    function forecastSalesNumblur(index,newValue) {
        if(isEmpty(newValue)){
            return;
        }
        endEidtProductDetail();
        forecastSalesNumblurAll();

    }

    //初始化编辑
    function initEditor(index) {
        $("#productDetailList").datagrid('beginEdit',index);
        var forecastSalesNumEd = $('#productDetailList').datagrid('getEditor', {index:index,field:'forecastSalesNum'});
        forecastSalesNumEd.target.numberbox({
            onChange:function(newValue,oldValue){
                forecastSalesNumblur(index,newValue);
            }
        })
    }

    //修改产品
    //修改产品
    function updateProductDetail() {
        var rowsData = $('#productDetailList').datagrid('getSelections');
        if (rowsData.length==0 ) {
            tip("请至少选择一条数据");
        }else{
            for(var i=0;i<rowsData.length;i++){
                var index = $("#productDetailList").datagrid("getRowIndex",rowsData[i]);
                initEditor(index);
            }
        }
    }

    //删除产品
    function delProductDetail() {
        var rowsData = $('#productDetailList').datagrid('getSelections');

        if (rowsData.length==0 ) {
            tip("请至少选择一条数据");
        }else{
            for(var i=rowsData.length-1;i>=0;i--){
                var index = $("#productDetailList").datagrid("getRowIndex",rowsData[i]);
                $("#productDetailList").datagrid("deleteRow",index);
            }
        }
    }

    //减法
    function accSub(arg1, arg2) {
        var r1, r2, m, n;
        try { r1 = arg1.toString().split(".")[1].length } catch (e) { r1 = 0}
        try { r2 = arg2.toString().split(".")[1].length } catch (e) { r2 = 0}
        m = Math.pow(10, Math.max(r1, r2));
        n = (r1 >= r2) ? r1 : r2;
        return ((arg1 * m - arg2 * m) / m).toFixed(n);
    }
    /**
     * 乘法运算，避免数据相乘小数点后产生多位数和计算精度损失。
     *
     * @param num1被乘数 | num2乘数
     */
    function numMulti(num1, num2) {
        var baseNum = 0;
        try {
            baseNum += num1.toString().split(".")[1].length;
        } catch (e) {
        }
        try {
            baseNum += num2.toString().split(".")[1].length;
        } catch (e) {
        }
        return Number(num1.toString().replace(".", "")) * Number(num2.toString().replace(".", "")) / Math.pow(10, baseNum);
    };
    /**
     * 除法运算，避免数据相除小数点后产生多位数和计算精度损失。
     *
     * @param num1被除数 | num2除数
     */
    function numDiv(num1, num2) {
        var baseNum1 = 0, baseNum2 = 0;
        var baseNum3, baseNum4;
        var baseNum5;
        try {
            baseNum1 = num1.toString().split(".")[1].length;
        } catch (e) {
            baseNum1 = 0;
        }
        try {
            baseNum2 = num2.toString().split(".")[1].length;
        } catch (e) {
            baseNum2 = 0;
        }
        with (Math) {
            baseNum3 = Number(num1.toString().replace(".", ""));
            baseNum4 = Number(num2.toString().replace(".", ""));
            baseNum5 = (baseNum3 / baseNum4) * pow(10, baseNum2 - baseNum1);
            return baseNum5;
        }
    };

    /**
     * 保留两位小数
     * @param value
     * @returns {number}
     */
    function returnFloat(value){
        var value = Math.round(parseFloat(value) * 100) / 100;
        var s = value.toString().split(".");
        if(s.length== 1){
            value = value.toString() + ".00";
            return value;
        }
        if (s.length > 1) {
            if (s[1].length < 2) {
                value = value.toString() + "0";
            }
            return value;
        }
    }
</script>