<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="quota_list" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="pricelist" tagConf="${clickFunctionId}" controllerTarget="ttActPriceController" methedTarget="findTtActPricePage" idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/act/ttActPriceController/findTtActPricePage?clickFunctionId=${clickFunctionId}" pagination="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar1" field="extChar1"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar2" field="extChar2"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar3" field="extChar3"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar4" field="extChar4"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar5" field="extChar5"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar6" field="extChar6"  hidden="true"></t:dgCol>
            <t:dgCol title="审批状态" field="bpmStatus" dictionary="bpm_status"></t:dgCol>
            <t:dgCol title="流程编号" field="processKey" query="true"></t:dgCol>
            <t:dgCol title="活动编号" field="actCode" query="true"></t:dgCol>
            <t:dgCol title="活动名称" field="actName" query="true"></t:dgCol>
            <t:dgCol title="活动开始时间" field="beginDate" formatter="yyyy-MM-dd"></t:dgCol>
            <t:dgCol title="活动结束时间" field="endDate" formatter="yyyy-MM-dd"></t:dgCol>
            <t:dgCol title="预算名称" field="budgetName"></t:dgCol>
            <t:dgCol title="创建人" field="createName"></t:dgCol>
            <t:dgCol title="最近更新人" field="updateName" treefield="updateName"></t:dgCol>
            <t:dgCol title="最近更新时间" field="updateDate" treefield="updateDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>

            <t:dgToolBar title="新增" operationCode="add" icon="icon-add" width="1300" height="500" url=""
                         funname="addDetail"></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" width="1300" height="500" url=""
                         funname="updateDetail" ></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" icon="icon-edit" width="1300" height="500" url="/page/ttActPriceController/goUpdateOrAdd?clickFunctionId=${clickFunctionId}"
                         funname="detail"></t:dgToolBar>
            <t:dgToolBar operationCode="remove" title="删除" icon="icon-remove" url="/act/ttActPriceController/deleteTtAct"
                         funname="deleteALLSelect"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut"
                         url="/act/commonExcelController/excel" excelName="价格活动" excelSheetName="价格活动" funname="excelCommonExport"></t:dgToolBar>
            <c:if test="${isDisplay == '1' }">
                <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn"
                             onclick="importExcel(${importUploadUrl},impot)"></t:dgToolBar>
            </c:if>
            <t:dgToolBar title="提交流程" operationCode="commit" icon="icon-edit" width="900" height="500" url=""
                         funname="commit"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="/page/knlLogController/goShowLog"
                         width="1000" height="500" funname="update"></t:dgToolBar>
            <t:dgToolBar operationCode="bpmLog" title="流程日志" icon="icon-log" url="/page/knlLogController/goAuditTaskLogs"
                         width="1000" height="500"     funname="detail"></t:dgToolBar>
            <t:dgToolBar title="个性设置" operationCode="style" icon="icon-add" url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>

        </t:datagrid>
    </div>
</div>
<script>
    var pageCode = "jghd";
    /**提交工作流页面**/
    function commit(width,height) {
        var rowsDatas = $('#pricelist').datagrid('getSelections');
        if(rowsDatas.length!=1){
            tip("请选择一条数据操作");
            return;
        }
        if(rowsDatas[0].bpmStatus=='2'||rowsDatas[0].bpmStatus=='3'){
            tip("该条数据不能再次提交审批");
            return;
        }
        commitSub(width,height,pageCode);
    }
    /**执行提交**/
    function docommit(data){
        openProgressTop("正在提交.......");
        var rowsDatas = $('#pricelist').datagrid('getSelections');
        //封装参数
        data.businessObjId = rowsDatas[0].id;
        $.ajax({
            type: "POST",
            url: "/act/ttActPriceController/subActiviti",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            success: function(data){
                if(data.success){
                    $.dialog({id: "activitiSubId"}).close();
                    pricelistsearch();
                    tip(data.msg);
                }else{
                    $.dialog({id: "activitiSubId"}).content.tip(data.msg);
                }
            },
            complete:function () {
                closeProgressTop();
            }
        });
    }
    
    function checkData() {
        var rowsDatas = $('#pricelist').datagrid('getSelections');
        if(rowsDatas.length>0){
           for(var i=0;i<rowsDatas.length;i++){
               if(rowsDatas[i].bpmStatus=='2'||rowsDatas[i].bpmStatus=='3'){
                   tip("流程数据不能操作");
                   return false;
               }
           }
        }
        return true;
    }
    /*新增活动*/
    function addDetail() {
        var addurl = "/page/ttActPriceController/goUpdateOrAdd?clickFunctionId=${clickFunctionId}";
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 1300,
            height: 500,
            title: '新增',
            opacity: 0.3,
            parent:'addActMain',
            id:'addAct',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    iframe.saveData();
                    return false;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions).max();
    }
    /*修改活动*/
    function updateDetail() {
        if(!checkData()){
            return;
        }
        var rowsDatas = $('#pricelist').datagrid('getSelections');
        if(rowsDatas.length!=1){
            tip("请选择一条数据");
            return;
        }
        var addurl = "/page/ttActPriceController/goUpdateOrAdd?clickFunctionId=${clickFunctionId}&id="+rowsDatas[0].id;
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 1300,
            height: 500,
            title: '编辑',
            opacity: 0.3,
            parent:'addActMain',
            id:'addAct',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    iframe.saveData();
                    return false;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions).max();
    }

    function impot() {
        pricelistsearch();
    }
</script>