<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<!DOCTYPE html >
<html>
<head>
    <title>关键指标</title>
    <t:base type="jquery,easyui,tools"/>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:datagrid fitColumns="true" name="tagetList"
            actionUrl="/activiti/actTargetConfigController/getTargetListPage?processId=${taProcessId}" idField="id"
            pagination="false">
    <t:dgCol title="id" hidden="true" field="id"/>
    <t:dgCol title="属性" field="filed" editor="{type:'validatebox',options:{required:true}}" />
    <t:dgCol title="标题" field="name" editor="{type:'validatebox',options:{required:true}}"/>
    <t:dgCol title="宽度" field="width" editor="{type:'text',options:{required:true}}"/>
    <t:dgCol title="是否显示" field="isShow" replace="是_1,否_0" editor="{type:'combobox',options:{valueField:'id',textField:'text',required:true,editable:false,data:[{'id':'1','text':'是'},{'id':'0','text':'否'}]}}"/>
    <t:dgCol title="显示顺序" field="orderNum" editor="{type:'text',options:{required:true}}"/>
    <t:dgCol title="默认值" field="defaultValue" editor="{type:'text',options:{required:true}}"/>

    <t:dgToolBar title="添加" icon="icon-add" url="" funname="addOneself"></t:dgToolBar>
    <t:dgToolBar title="修改" icon="icon-edit" url="" funname="updateOneself"></t:dgToolBar>
    <t:dgToolBar title="保存" icon="icon-save" url="" funname="saveData"></t:dgToolBar>
    <t:dgToolBar title="删除" icon="icon-remove" url="" funname="deleteOneself"></t:dgToolBar>
</t:datagrid>
</body>
</html>
<script>

    function deleteOneself() {
        var rowsDetailDatas = $('#tagetList').datagrid('getSelections');
        for(var i=rowsDetailDatas.length-1;i>=0;i--){
            var index = $('#tagetList').datagrid('getRowIndex',rowsDetailDatas[i]);
            $('#tagetList').datagrid('deleteRow',index);
        }
    }
    
    function updateOneself() {
        var rowsDetailDatas = $('#tagetList').datagrid('getSelections');
        for(var i=0;i<rowsDetailDatas.length;i++){
            var index = $('#tagetList').datagrid('getRowIndex',rowsDetailDatas[i]);
            $('#tagetList').datagrid('beginEdit' ,index);
        }
    }
    
    function saveData() {
        endEditorALl();
        var taProcessId = '${taProcessId}';
        var rowsDetailDatas = $('#tagetList').datagrid('getRows');
        var objSave = {};
        objSave.processId = taProcessId;
        objSave.items = rowsDetailDatas;
        $.ajax({
            type: "POST",
            url: "/activiti/actTargetConfigController/saveDate",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(objSave),
            success: function(data){
                tip(data.msg);
                if (data.success) {
                    tagetListsearch();
                }else{
                    editorALl();
                }
            }
        });
    }
    /*结束编辑*/
    function endEditorALl() {
        var rowsDetailDatas = $('#tagetList').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
            var index = $('#tagetList').datagrid('getRowIndex',rowsDetailDatas[i]);
            $('#tagetList').datagrid('endEdit' ,index);
        }
    }

    function addOneself() {
        $('#tagetList').datagrid('insertRow', {
            index: 0,
            row: {
                id: uuid()
            }
        });
        $('#tagetList').datagrid('beginEdit' ,0);
    }
    /*打开编辑*/
    function editorALl() {
        var rowsDetailDatas = $('#tagetList').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
            var index = $('#tagetList').datagrid('getRowIndex',rowsDetailDatas[i]);
            $('#tagetList').datagrid('beginEdit' ,index);
        }
    }
    function uuid() {
        var s = [];
        var hexDigits = "0123456789abcdef";
        for (var i = 0; i < 36; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
        }
        s[14] = "4";
        s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);
        s[8] = s[13] = s[18] = s[23] = "-";
        var uuid = s.join("");
        uuid = uuid.replace("-","");
        return uuid;
    }


</script>
