<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="display_manage_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="displayList" tagConf="${clickFunctionId}" idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/sfaapi/tsAiDisPlayConfController/findAIDisPlayConfMain" pagination="true" singleSelect="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="陈列标准编码" field="displayCode"></t:dgCol>
            <t:dgCol title="陈列标准名称" field="displayName" query="true"></t:dgCol>
            <t:dgCol title="创建人" field="createName" ></t:dgCol>
            <t:dgCol title="创建时间" field="createDate" ></t:dgCol>
            <t:dgCol title="开始时间" field="beginDate"></t:dgCol>
            <t:dgCol title="结束时间" field="endDate" ></t:dgCol>
            <t:dgCol title="陈列要求描述" field="displayDesc" ></t:dgCol>
            <t:dgToolBar title="新增" width="1000" height="500" operationCode="add" icon="icon-add" funname="addDisplay" url="/page/tsAiDisPlayConfController/goTsAIDisPlayConfForm"></t:dgToolBar>
            <t:dgToolBar title="修改" width="1000" height="500" operationCode="add" icon="icon-edit" funname="updateDisplay" url="/page/tsAiDisPlayConfController/goTsAIDisPlayConfForm"></t:dgToolBar>
            <t:dgToolBar title="删除"  operationCode="delete" icon="icon-delete" funname="deleteALLSelect" url="/sfaapi/tsAiDisPlayConfController/delDisplayConfId?1=1"></t:dgToolBar>
            <t:dgToolBar title="个性设置" operationCode="style" icon="icon-add" url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>

<script>
    function addDisplay(){
        var url = "/page/tsAiDisPlayConfController/goTsAIDisPlayConfForm";
        var width = 1000;
        var height = 500;
        var myOptions = {
            opacity : 0.3,
            content: "url:" + url,
            lock: true,
            title: "新增陈列标准",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                var this_ = this;
                iframe = this.iframe.contentWindow;
                iframe.vm.save(function () {
                    $('#displayList').datagrid('reload');
                    this_.close();
                });
                return false;
            },
            cancelVal: '关闭',
            cancel: true
        };
        safeShowDialog(myOptions);
    }
    function updateDisplay(){
         var rows = getSelectRows();
         if(rows.length===0){
             tip("请先选择一条数据");
             return false;
         }
        var url = "/page/tsAiDisPlayConfController/goTsAIDisPlayConfForm?id="+rows[0].id;
        var width = 1000;
        var height = 500;
        var myOptions = {
            opacity : 0.3,
            content: "url:" + url,
            lock: true,
            title: "修改陈列标准",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                var this_ = this;
                iframe = this.iframe.contentWindow;
                iframe.vm.save(function () {
                    $('#displayList').datagrid('reload');
                    this_.close();
                });
                return false;
            },
            cancelVal: '关闭',
            cancel: true
        };
        safeShowDialog(myOptions);
    }

</script>
