<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>价格活动明细添加</title>
    <t:base type="jquery,easyui,tools"></t:base>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid action="/act/ttActPriceController/saveOrUpdateDetail"  layout="div"  dialog="true" formid="detailId">
    <t:dgFormList>
        <t:dgFormColumn field="id" hidden="true" defaultVal="${vo.id}" formClass="form" labelName="id" optionType="input" required="false"/>
        <t:dgFormColumn field="tempUuid" hidden="true" defaultVal="${tempUuid}" formClass="form" labelName="id" optionType="input" required="false"/>
        <t:dgFormColumn field="budgetCode" hidden="true" defaultVal="${budgetCode}" formClass="form" labelName="budgetCode" optionType="input" required="false"/>
        <t:dgFormColumn field="actDetailType" hidden="false" formClass="form" labelName="促销类型" optionType="select" required="true"
                        defaultVal="${vo.actDetailType }"  dataType="*" typeGroupCode="act_detail_type" />
        <t:dgFormColumn field="actSubclassName" hidden="false" formClass="form" labelName="活动细类" optionType="choseDialog" required="true"
                        onclick="selectActSubClass()" defaultVal="${vo.actSubclassName}" dataType="*"/>
        <input id="actSubclassCode" name="actSubclassCode" value="${vo.actSubclassCode}" type="hidden">
        <input id="categoriesCode" name="categoriesCode" value="${vo.categoriesCode}" type="hidden">
        <t:dgFormColumn field="productName" hidden="false" formClass="form" labelName="产品" optionType="choseDialog" required="true"
                        defaultVal="${vo.productName }"  onclick="selectProductCheck();"/>
        <input id="productCode" name="productCode" value="${vo.productCode}" type="hidden">
        <input id="productNameStr" value="${vo.productName}" type="hidden">
        <t:dgFormColumn field="companyCode" hidden="false" formClass="form" labelName="公司" optionType="select" required="true"
                        defaultVal="${vo.companyCode }" dataType="*" typeGroupCode="company_code"/>
        <t:dgFormColumn field="customerName" hidden="false" formClass="form" labelName="客户名称" optionType="choseDialog" required="false"
                        onclick="selectCustomer()" defaultVal="${vo.customerName}" />
        <input id="customerCode" name="customerCode" value="${vo.customerCode}" type="hidden">
        <t:dgFormColumn field="terminalName" hidden="false" formClass="form" labelName="门店名称" optionType="choseDialog" required="false"
                        onclick="selectTerminal()" defaultVal="${vo.terminalName}" />
        <input id="terminalCode" name="terminalCode" value="${vo.terminalCode}" type="hidden">
        <%--<t:dgFormColumn field="priceType" hidden="false" formClass="form" labelName="价格类型" optionType="select" required="false"
                        defaultVal="${vo.priceType }"   typeGroupCode="price_type" />--%>
        <t:dgFormColumn field="priceGroup" hidden="false" formClass="form" labelName="价格组" optionType="select" required="false"
                        defaultVal="${vo.priceGroup }"   typeGroupCode="price_group" />
        <t:dgFormColumn field="standPrice" hidden="false" formClass="form" labelName="标准价" optionType="input" required="false"
                        defaultVal="${vo.standPrice }" />
        <t:dgFormColumn field="applyPrice" hidden="false" formClass="form" labelName="申请价" optionType="input" required="false"
                        defaultVal="${vo.applyPrice }" />
        <t:dgFormColumn field="diffPrice" hidden="false" formClass="form" labelName="差价" optionType="input" required="false"
                        defaultVal="${vo.diffPrice }"  />
        <t:dgFormColumn field="productNum" hidden="false" formClass="form" labelName="本品数量" optionType="input" required="true"
                        defaultVal="${vo.productNum }" />
        <t:dgFormColumn field="giftName" hidden="false" formClass="form" labelName="赠品" optionType="choseDialog" required="false"
                        defaultVal="${vo.giftName }" onclick="selectGiftProduct();" />
        <input id="giftCode" name="giftCode" value="${vo.giftCode}" type="hidden">
        <input id="giftCostPrice" name="giftCostPrice" value="${vo.giftCostPrice}" type="hidden">
        <input id="giftStandPrice" name="giftStandPrice" value="${vo.giftStandPrice}" type="hidden">
        <t:dgFormColumn field="giftNum" hidden="false" formClass="form" labelName="赠品数量" optionType="input" required="false"
                        defaultVal="${vo.giftNum }" />
        <t:dgFormColumn field="forecastSalesNum" hidden="false" formClass="form" labelName="预计销量" optionType="input" required="true"
                        defaultVal="${vo.forecastSalesNum }" dataType="*" />
        <t:dgFormColumn field="forecastSalesAmount" hidden="false" formClass="form" labelName="预计销售额" optionType="input" required="true"
                        defaultVal="${vo.forecastSalesAmount }" dataType="*"/>
        <t:dgFormColumn field="amount" hidden="false" formClass="form" labelName="申请费用金额" optionType="input" required="false"
                        defaultVal="${vo.amount }"/>
        <%--<t:dgFormColumn field="payType" hidden="false" formClass="form" labelName="支付方式" optionType="select" required="true"
                        defaultVal="${vo.payType }" typeGroupCode="pay_type" dataType="*"/>--%>
        <t:dgFormColumn field="scale" hidden="false" formClass="form" labelName="比例" optionType="input" required="true"
                        defaultVal="${vo.scale }"  dataType="*"/>
        <t:dgFormColumn field="remarks" hidden="false" formClass="form" labelName="备注" optionType="textarea"  required="false"
                        rows="3" cols="5" defaultVal="${vo.remarks}" />
    </t:dgFormList>
    <div>

    </div>
</t:formvalid>
<script>

    $("#applyPrice").bind('input propertychange',function () {
        countPrice();
    })

    function countPrice() {
        var standPrice = $("#standPrice").val();
        var applyPrice = $("#applyPrice").val();
        var diffPrice = accSub(standPrice,applyPrice);
        $("#diffPrice").val(diffPrice);
    }
    //加法
    function accSub(arg1, arg2) {
        var r1, r2, m, n;
        try { r1 = arg1.toString().split(".")[1].length } catch (e) { r1 = 0}
        try { r2 = arg2.toString().split(".")[1].length } catch (e) { r2 = 0}
        m = Math.pow(10, Math.max(r1, r2));
        n = (r1 >= r2) ? r1 : r2;
        return ((arg1 * m - arg2 * m) / m).toFixed(n);
    }
    
    $("#forecastSalesNum").blur(function () {
        countAmount();
    })

    $("#giftNum").blur(function () {
        countAmount();
    })

    function countAmount(){

        //预计销量
        var forecastSalesNum = $("#forecastSalesNum").val();
        //标准价
        var standPrice = $("#standPrice").val();
        //申请价
        var applyPrice = $("#applyPrice").val();
        //差价
        var diffPrice = $("#diffPrice").val();
        //成本价
        var giftCostPrice = $("#giftCostPrice").val();
        //赠品数量
        var giftNum = $("#giftNum").val();
        //本品数量
        var productNum = $("#productNum").val();
        //如果活动大类编码有值则代表活动细类做了预算控制，需要计算申请费用金额
        var categoriesCode = $("#categoriesCode").val();
        //促销类型
        var actDetailType = $("#actDetailType").val();
        if (actDetailType == "discount_product" || actDetailType == "discount_group_product" || actDetailType == "discount_custom_product" || actDetailType == "discount_dept_product") {
            $("#forecastSalesAmount").val(numMulti(forecastSalesNum,applyPrice));//预计销售额（折价）=预计销量*申请价
            if (categoriesCode != "") {
                var amount = numMulti(forecastSalesNum,diffPrice);
                $("#amount").val(amount);//申请费用金额（折价）=差价*预计销量
                //比例（折价）=申请费用金额/（预计销量*标准价）
                var scale = numDiv(amount,numMulti(forecastSalesNum,standPrice));
                if (scale != "" && !isNaN(scale)) {
                    if (isFinite(scale)) {
                        $("#scale").val(returnFloat(scale));
                    }else{
                        tip("计算失败，请重新选择计算");
                    }
                }
            }
        }else if (actDetailType == "buy_product" || actDetailType == "buy_custom_product" || actDetailType == "buy_dept_product") {
            $("#forecastSalesAmount").val(numMulti(forecastSalesNum,standPrice));//预计销售额（买赠）=预计销售量*标准价
            if (categoriesCode != "") {
                //申请费用金额（买赠）=预计销量/本品数量（向下取整）*赠品数量*赠品成本
                var amount = numMulti(numMulti(numDiv(forecastSalesNum,productNum),giftNum),giftCostPrice);
                if (amount != "" && !isNaN(amount)) {
                    if (isFinite(amount)) {
                        $("#amount").val(amount);
                    }else{
                        tip("计算失败，请重新选择计算");
                    }
                }
                //赠品标准价
                var giftStandPrice = $("#giftStandPrice").val();
                //比例（买赠）=申请费用金额/（预计销量*赠品标准价）
                var scale = numDiv(amount,numMulti(forecastSalesNum,giftStandPrice));
                if (scale != "" && !isNaN(scale)) {
                    if (isFinite(scale)) {
                        $("#scale").val(returnFloat(scale));
                    }else{
                        tip("计算失败，请重新选择计算");
                    }
                }
            }
        }
    }

    //比例计算
    $("#amount").bind('input propertychange',function () {
        //标准价
        var standPrice = $("#standPrice").val();
        //申请费用金额
        var amount = $("#amount").val();
        //预计销量
        var forecastSalesNum = $("#forecastSalesNum").val();
        //促销类型
        var actDetailType = $("#actDetailType").val();
        if (amount != "") {
            if (actDetailType == "discount_product" || actDetailType == "discount_group_product" || actDetailType == "discount_custom_product" || actDetailType == "discount_dept_product") {
                //比例（折价）=申请费用金额/（预计销量*标准价）
                var scale = numDiv(amount,numMulti(forecastSalesNum,standPrice));
                if (scale != "" && !isNaN(scale)) {
                    if (isFinite(scale)) {
                        $("#scale").val(returnFloat(scale));
                    }else{
                        tip("计算失败，请重新选择计算");
                    }
                }
            }else if (actDetailType == "buy_product" || actDetailType == "buy_custom_product" || actDetailType == "buy_dept_product") {
                //赠品标准价
                var giftStandPrice = $("#giftStandPrice").val();
                //比例（买赠）=申请费用金额/（预计销量*赠品标准价）
                var scale = numDiv(amount,numMulti(forecastSalesNum,giftStandPrice));
                if (scale != "" && !isNaN(scale)) {
                    if (isFinite(scale)) {
                        $("#scale").val(returnFloat(scale));
                    }else{
                        tip("计算失败，请重新选择计算");
                    }
                }
            }
        }
    })

    /**
     * 乘法运算，避免数据相乘小数点后产生多位数和计算精度损失。
     *
     * @param num1被乘数 | num2乘数
     */
    function numMulti(num1, num2) {
        var baseNum = 0;
        try {
            baseNum += num1.toString().split(".")[1].length;
        } catch (e) {
        }
        try {
            baseNum += num2.toString().split(".")[1].length;
        } catch (e) {
        }
        return Number(num1.toString().replace(".", "")) * Number(num2.toString().replace(".", "")) / Math.pow(10, baseNum);
    };
    /**
     * 除法运算，避免数据相除小数点后产生多位数和计算精度损失。
     *
     * @param num1被除数 | num2除数
     */
    function numDiv(num1, num2) {
        var baseNum1 = 0, baseNum2 = 0;
        var baseNum3, baseNum4;
        var baseNum5;
        try {
            baseNum1 = num1.toString().split(".")[1].length;
        } catch (e) {
            baseNum1 = 0;
        }
        try {
            baseNum2 = num2.toString().split(".")[1].length;
        } catch (e) {
            baseNum2 = 0;
        }
        with (Math) {
            baseNum3 = Number(num1.toString().replace(".", ""));
            baseNum4 = Number(num2.toString().replace(".", ""));
            baseNum5 = (baseNum3 / baseNum4) * pow(10, baseNum2 - baseNum1);
            return baseNum5;
        }
    };

    /**
     * 保留两位小数
     * @param value
     * @returns {number}
     */
    function returnFloat(value){
       var value = Math.round(parseFloat(value) * 100) / 100;
       var s = value.toString().split(".");
       if(s.length== 1){
             value = value.toString() + ".00";
             return value;
           }
       if (s.length > 1) {
             if (s[1].length < 2) {
                   value = value.toString() + "0";
                 }
             return value;
           }
    }

    selectActType();
    $("#actDetailType").change(function () {
        selectActType();
    })

    function selectActType(){
        var productNameStr = $("#productNameStr").val();
        var actDetailType = $("#actDetailType").val();
        if (actDetailType == "discount_product") {
            $("#productName").parent().parent().show();
            $("#customerName").parent().parent().hide();
            $("#customerName").val("");
            $("#customerCode").val("");
            $("#terminalName").parent().parent().hide();
            $("#terminalName").val("");
            $("#terminalCode").val("");
            // $("#priceType").parent().parent().show();
            $("#priceGroup").parent().parent().hide();
            $("#priceGroup").val("");
            $("#standPrice").attr("readonly",true);
            $("#giftName").parent().parent().hide();
            $("#giftName").val("");
            $("#giftNum").parent().parent().hide();
            $("#giftNum").val("");
        }else if (actDetailType == "buy_product") {
            $("#productName").parent().parent().show();
            $("#customerName").parent().parent().hide();
            $("#customerName").val("");
            $("#customerCode").val("");
            $("#terminalName").parent().parent().hide();
            $("#terminalName").val("");
            $("#terminalCode").val("");
            $("#priceGroup").parent().parent().hide();
            $("#priceGroup").val("");
            $("#giftName").parent().parent().show();
            $("#giftNum").parent().parent().show();
        }else if (actDetailType == "discount_group_product"){
            $("#productName").parent().parent().show();
            $("#customerName").parent().parent().hide();
            $("#customerName").val("");
            $("#customerCode").val("");
            $("#terminalName").parent().parent().hide();
            $("#terminalName").val("");
            $("#terminalCode").val("");
            // $("#priceType").parent().parent().show();
            $("#priceGroup").parent().parent().show();
            $("#standPrice").attr("readonly",true);
            $("#giftName").parent().parent().hide();
            $("#giftName").val("");
            $("#giftNum").parent().parent().hide();
            $("#giftNum").val("");
        }else if (actDetailType == "discount_custom_product"){
            $("#productName").parent().parent().show();
            $("#customerName").parent().parent().show();
            $("#terminalName").parent().parent().hide();
            $("#terminalName").val("");
            $("#terminalCode").val("");
            $("#priceGroup").parent().parent().hide();
            $("#priceGroup").val("");
            $("#standPrice").attr("readonly",true);
            $("#giftName").parent().parent().hide();
            $("#giftName").val("");
            $("#giftNum").parent().parent().hide();
            $("#giftNum").val("");
        }else if (actDetailType == "buy_custom_product") {
            $("#productName").parent().parent().show();
            $("#customerName").parent().parent().show();
            $("#terminalName").parent().parent().hide();
            $("#terminalName").val("");
            $("#terminalCode").val("");
            $("#priceGroup").parent().parent().hide();
            $("#priceGroup").val("");
            $("#giftName").parent().parent().show();
            $("#giftNum").parent().parent().show();
        }else if (actDetailType == "discount_dept_product") {
            $("#productName").parent().parent().show();
            $("#customerName").parent().parent().hide();
            $("#customerName").val("");
            $("#customerCode").val("");
            $("#terminalName").parent().parent().show();
            $("#priceGroup").parent().parent().hide();
            $("#priceGroup").val("");
            $("#standPrice").attr("readonly",true);
            $("#giftName").parent().parent().hide();
            $("#giftName").val("");
            $("#giftNum").parent().parent().hide();
            $("#giftNum").val("");
        }else if (actDetailType == "buy_dept_product") {
            $("#productName").parent().parent().show();
            $("#customerName").parent().parent().hide();
            $("#customerName").val("");
            $("#customerCode").val("");
            $("#terminalName").parent().parent().show();
            $("#priceGroup").parent().parent().hide();
            $("#priceGroup").val("");
            $("#giftName").parent().parent().show();
            $("#giftNum").parent().parent().show();
        }
    }

    $("#companyCode").change(function () {
        getPrice();
    })
    $("#priceGroup").change(function () {
        getPrice();
    })

    function getPrice() {
        $("#standPrice").val("");
        $.ajax({
            url:"/act/ttActPriceController/getProductPrice",
            data:{
                tempUuid : $("#tempUuid").val(),
                productName : $("#productName").val(),
                productCode : $("#productCode").val(),
                companyCode : $("#companyCode").val(),
                priceGroup : $("#priceGroup").val(),
                customerCode : $("#customerCode").val()
            },
            dataType:'json',
            type:'post',
            async:false,
            success:function(data){
                $("#standPrice").val(data.obj);
            }
        })
    }

    function selectActSubClass(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        var tableType = "act_price";
        var budgetCode = $("#budgetCode").val();
        triggerId = "actSubclassCode";
        triggerName = "actSubclassName";
        url = "/page/ttApiFineController/goApiActFineMain?tableType="+tableType+"&budgetCode="+budgetCode;
        width = 1000;
        height = 450;
        id = "actSubclassList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].fineCode);
                    $("#" + triggerName).val(myobj[0].fineName);
                    $("#categoriesCode").val(myobj[0].categoriesCode);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    function selectCustomer(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "customerCode";
        triggerName = "customerName";
        url = "/page/tmApiCustomerController/goActCustomerListMain";
        width = 1000;
        height = 450;
        id = "customerList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].customerCode);
                    $("#" + triggerName).val(myobj[0].customerName);
                    getPrice();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    function selectTerminal(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        // var customerCode=$("#customerCode").val();
        // if (customerCode ==undefined || customerCode==''){
        //     tip("请选择客户");
        //     return ;
        // }
        triggerId = "terminalCode";
        triggerName = "terminalName";
        url = "/page/tmApiTerminalController/goTerminalListMain";
        width = 1000;
        height = 450;
        id = "terminalList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].terminalCode);
                    $("#" + triggerName).val(myobj[0].terminalName);
                    getPrice();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectProductCheck(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        //判断预算是否选择了产品
        var budgetCode = $("#budgetCode").val();
        $.post("/budget/ttFeeBudgetController/findFeeBudgetByCode",
            { "budgetCode": budgetCode },
            function(data){
             var bugdetEntity = data.obj;
                selectProduct(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId,bugdetEntity);
            }, "json");
    }

    function selectProduct(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId,bugdetEntity){

        //productCode
        triggerId = "productCode";
        triggerName = "productName";
        // valueField = "standPrice";
        if(bugdetEntity==null||isEmpty(bugdetEntity.productCode)){
            url = "/page/tmApiProductInfoController/goProductInfoListMain";
        }else{
            url = "/page/tmApiProductInfoController/goProductInfoListMain?productInfoCode="+bugdetEntity.productCode;
        }

        width = 1000;
        height = 450;
        id = "productinfoList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].productInfoCode);
                    $("#" + triggerName).val(myobj[0].productInfoName);
                    $("#standPrice").val("");
                    $("#applyPrice").val("");
                    $("#diffPrice").val("");
                    getPrice();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectGiftProduct(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        url = "/page/tmApiProductInfoController/goProductInfoListMain";
        width = 1000;
        height = 450;
        id = "productinfoList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#giftCode").val(myobj[0].productInfoCode);
                    $("#giftName").val(myobj[0].productInfoName);
                    $("#giftCostPrice").val(myobj[0].costPrice);
                    getGiftPrice();
                    $("#giftNum").val("");
                    $("#forecastSalesNum").val("");
                    $("#forecastSalesAmount").val("");
                    $("#amount").val("");
                    $("#scale").val("");
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function getGiftPrice() {
        $("#giftStandPrice").val("");
        $.ajax({
            url:"/act/ttActPriceController/getProductPrice",
            data:{
                tempUuid : $("#tempUuid").val(),
                productName : $("#giftName").val(),
                productCode : $("#giftCode").val(),
                companyCode : $("#companyCode").val(),
                priceGroup : $("#priceGroup").val(),
                customerCode : $("#customerCode").val()
            },
            dataType:'json',
            type:'post',
            async:false,
            success:function(data){
                $("#giftStandPrice").val(data.obj);
            }
        })
    }
</script>
</body>
</html>