<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>价格活动明细添加</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        .form-group {
            padding: 10px 10px 0 10px;
            box-sizing: border-box;
        }

        .form-input label {
            display: inline-block;
            width: 130px;
            text-align: right;
            line-height: 24px;
        }

        .form-input input {
            height: 24px;
            border: 1px solid #ddd;
            -moz-border-radius: 2px;
            -webkit-border-radius: 2px;
            border-radius: 2px;
            outline: none;
            padding: 3px 2px;
            width: 150px;
            box-sizing: border-box;
        }
    </style>
</head>
<body class="easyui-layout">
<div data-options="region:'center'" class="flex flex-column">
    <input type="hidden" id="categoriesCode" value="${categoriesCode}">
    <div class="form-group flex-none">
        <div class="flex flex-align-items-center mb10">
            <div class="form-input flex-1">
                <label>促销类型: <span style="color:red;">*</span></label>
                <t:dictSelect field="actDetailType" id="actDetailType" dataType="*" type="select"  typeGroupCode="act_detail_type">
                </t:dictSelect>
            </div>
        </div>
    </div>
    <div class="iframe-content flex-auto">
        <iframe id="priceIframe" frameborder=0 width="100%" height="100%"
               src="/page/ttActPriceController/goAddActDetailForOne?page=buyProductForm&categoriesCode=${categoriesCode}"></iframe>
    </div>
</div>
<script>
    $(function () {
        $("#actDetailType").attr("style","width : 145px");
        $("#actDetailType").change(function () {
            changeSelect();
        });
        var edit = '${edit}';
        if(edit=='0') {
            var rows = getPaData();
            var actDetailType = rows[0].actDetailType;
            $("#actDetailType").val(actDetailType);
            changeSelect();
        }
    });
    
    function getPaData() {
        //编辑状态 初始化数据
        var api = frameElement.api, W = api.opener;
        var rows = W.getSelectsRows();
        return rows;
    }
    
    function changeSelect() {
        var categoriesCode = $("#categoriesCode").val();
        let value = $("#actDetailType").val();
        switch (value) {
            case "buy_product"://买赠：产品
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=buyProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "buy_group_product"://买赠：产品+价格组
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=buyGroupProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "buy_custom_product"://买赠：产品+客户
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=buyCustomerProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "buy_dept_product"://买赠：产品+门店
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=buyDeptProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "special_product"://特价：产品
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=specialProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "special_group_product"://特价：价格组+产品
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=specialGroupProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "special_customer_product"://特价：客户+产品
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=specialCustomerProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "special_dept_product"://特价：门店+产品
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=specialDeptProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "discount_product"://折价：产品
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=discountProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "discount_custom_product"://折价：客户+产品
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=discountCustomerProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "discount_group_product"://折价：价格组+产品
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=discountGroupProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "discount_dept_product"://折价：门店+产品
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=discountDeptProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "amount_product"://金额：产品
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=amountProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "amount_customer_product"://金额：客户+产品
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=amountCustomerProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
            case "amount_group_product"://金额：价格组+产品
                $("#priceIframe").attr("src","/page/ttActPriceController/goAddActDetailForOne?page=amountGroupProductForm&edit=${edit}&categoriesCode="+categoriesCode);
                break;
        }
    }

    function saveData() {
        let priceIframe = $("#priceIframe")[0];
        var data = priceIframe.contentWindow.createData();
        return data;
    }

    function getActDetailType() {
        return $("#actDetailType").val();
    }

</script>
</body>
</html>