<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>添加活动</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        #content{
            height: auto!important;
            padding:0px !important;
        }
        .layout-split-north {
            border-bottom: 1px solid #0072ae00;
        }
        .datagrid-header, .datagrid-toolbar, .datagrid-footer-inner {
            border-color: transparent;
        }
    </style>
</head>
<body class="easyui-layout" fit="true">
<div data-options="region:'north'" style="height: 210px">
    <div class="form-group" id="app">
        <%--关键指标html开始--%>
        <target-table ref="targetTable" :id="id" :page="page" :show-target="isActiviti" :view-status="viewStatus"
                      @refresh="handleRefresh"></target-table>
        <%--关键指标html结束--%>
    </div>
        <t:formvalid action="/act/ttActQuotaController/saveOrUpdate" beforeSubmit="checkproductSubmit" layout="div"
                     dialog="true" formid="detailId">
            <t:dgFormList layoutStyle="horizontal" tagConf="${clickFunctionId}" expandParam="${clickFunctionId}">
                <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                                defaultVal="${vo.id }"/>
                <t:dgFormColumn field="headTarget" hidden="true" formClass="form" labelName="headTarget" optionType="input" required="false"
                                />
                <t:dgFormColumn field="processKeyTemp" hidden="true" formClass="form" labelName="processKeyTemp" optionType="input" required="false"
                />
                <t:dgFormColumn field="itemTarget" hidden="true" formClass="form" labelName="itemTarget" optionType="input" required="false"
                />
                <t:dgFormColumn field="tempUuid" hidden="true" formClass="biz-col-50 mb5 form" labelName="tempUuid" optionType="input" required="false"
                                defaultVal="${tempUuid }"/>
                <t:dgFormColumn field="productJson" hidden="true" formClass="form" labelName="productJson" optionType="input" required="false"
                                defaultVal=""/>
                <t:dgFormColumn field="actName" hidden="false" formClass="biz-col-50 mb5 form" labelName="活动名称" optionType="input"  required="true"
                                defaultVal="${vo.actName}"/>
                <t:dgFormColumn field="beginDate" extendField="endDate" extendFieldVal="${vo.endDate}" hidden="false" formClass="biz-col-50 mb5 form" labelName="起止时间" optionType="date_begin_end"  required="true"
                                defaultVal="${vo.beginDate}"/>
                <t:dgFormColumn field="budgetCode" hidden="false" formClass="biz-col-50 mb5 form" labelName="预算选择" optionType="choseDialog" required="true"
                                onclick="selectbudget()" defaultVal="${vo.budgetCode}"/>
                <t:dgFormColumn field="budgetName" hidden="true" formClass="biz-col-50 mb5 form" labelName="budgetName" optionType="input" required="false"
                                defaultVal="${vo.budgetName}"/>
                <t:dgFormColumn field="orderBeginDate" extendField="orderEndDate" extendFieldVal="${vo.orderEndDate}" hidden="false" formClass="biz-col-50 mb5 form" labelName="订货期间" optionType="date_begin_end"  required="true"
                                defaultVal="${vo.orderBeginDate}"/>
                <t:dgFormColumn field="categoriesName" hidden="false" formClass="biz-col-50 mb5 form" labelName="活动大类" optionType="choseDialog" required="true"
                                onclick="selectCategories()" defaultVal="${vo.categoriesName}" />
                <t:dgFormColumn field="categoriesCode" hidden="true" formClass="biz-col-33 mb5 form" labelName="活动大类名称" optionType="input" required="false"
                                defaultVal="${vo.categoriesCode }"/>
                <t:dgFormColumn field="remarks" hidden="false" formClass="biz-col-100 mb5 form" labelName="备注" optionType="textarea"  required="false"
                                rows="2" cols="5" defaultVal="${vo.remarks}" style="width: 93%"/>
            </t:dgFormList>
        </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">
    <div style="height: 200px">
        <t:datagrid name="quotaDetailList" checkbox="true" fitColumns="false" idField="id" fit="true"
                    queryMode="group"
                    actionUrl="/act/ttActQuotaController/findTtActQuotaDetailPage?tempUuid=${tempUuid}&id=${vo.id}"
                    pagination="false" specialSearch="true"
                    onLoadSuccess="loadSuccess"
        >
            <t:dgCol title="id" field="id" hidden="true"/>
            <t:dgCol title="活动细类" field="actSubclassName" sortable="false"/>
            <t:dgCol title="客户名称" field="customerName" query="true" sortable="false"/>
            <t:dgCol title="门店名称" field="terminalName" sortable="false"/>
            <t:dgCol title="申请金额" field="amount" sortable="false"/>
            <t:dgCol title="支付方式" field="payType" dictionary="pay_type" sortable="false"/>
            <t:dgCol title="预估销售额(客户)" field="fsalesAmountCustomer" sortable="false"/>
            <t:dgCol title="预估销售额(门店)" field="fsalesAmountTerminal" sortable="false"/>
            <t:dgCol title="备注" field="remarks" width="73" sortable="false" />
            <t:dgToolBar title="新增" funname="addDetail" detail="false" icon="icon-add"
                         url=""></t:dgToolBar>

            <t:dgToolBar title="编辑" funname="updateDetail" detail="false" icon="icon-edit"
                         url=""></t:dgToolBar>
            <c:if test="${isDisplay == '1' }">
                <t:dgToolBar title="导入"  detail="false" icon="icon-dataIn"
                             onclick="detailExcel()"></t:dgToolBar>
            </c:if>
            <t:dgToolBar title="删除" funname="deleteALLSelect" detail="false" icon="icon-remove"
                         url="/act/ttActQuotaController/delDetail"></t:dgToolBar>
            <t:dgToolBar title="附件" onclick="addAttach('${tempUuid}','${attachmentType}','${load}')" url="" icon="icon-attach"></t:dgToolBar>
        </t:datagrid>
    </div>
    <div class="p10 mb20">
        <table id="templeteTable" style="width: 100%;" cellpadding="0" cellspacing="1"
               class="formtable">
            <tbody>
            <tr >
                <td>
                               <span style="position: relative;">
                                   <input field="formtable" name="productLevelCode" id="productLevelCode"
                                          type="hidden"
                                          style="width: 150px">
                                    <input field="formtable" name="productLevelName" id="productLevelName" type="text"
                                           style="width: 150px" class="inputxt" >
                                    <a href="javascript:void(0);"
                                       onclick="selectProductLevel(this)" class="easyui-linkbutton"
                                       style="position: absolute;right:0;height: 24px;box-sizing: border-box;margin-right: 0;"
                                       plain="true" iconCls="icon-search"></a>
                                </span>

                </td>
                <%--<td>
                               <span style="position: relative;">
                                   <input field="formtable" name="productCode" id="productCode"
                                          type="hidden"
                                          style="width: 150px">
                                    <input field="formtable" name="productName" id="productName" type="text"
                                           style="width: 150px" class="inputxt" nocheck="true">
                                    <a href="javascript:void(0);"
                                       onclick="selectProductInfo(this)" class="easyui-linkbutton"
                                       style="position: absolute;right:0;height: 24px;box-sizing: border-box;margin-right: 0;"
                                       plain="true" iconCls="icon-search"></a>
                                </span>

                </td>--%>
                <td>
                    <input field="formtable" name="scale"
                           type="text"
                           style="width: 150px" class="inputxt">
                </td>
                <td>
                    <input field="formtable" name="remarks"
                           type="text"
                           nocheck="true"
                           style="width: 150px" class="inputxt">
                </td>
                <td>
                    <a iconCls="icon-remove" href="#" onclick="deleteTrTable(this)">删除</a>
                </td>
            </tr>
            </tbody>
        </table>
        <div id="actproduct"
                <c:if test="${needShare!=null and needShare == 0}">
                    class="hidden"
                </c:if> >
            <div class="p5">
                <span class="mr20">产品分摊信息</span>
                <a class="toolbar-btn" id="addTrBtn" href="#" onclick="addTrTable()">添加一行</a>
            </div>
            <table id="showTable" class="table-dynamic">
                <thead>
                <tr>
                    <th>产品层级</th>
                    <%--<th>产品</th>--%>
                    <th>比例%</th>
                    <th>备注</th>
                    <th>操作</th>
                </tr>
                </thead>
                <tbody>
                <c:if test="${needShare!=null and needShare == 1}">
                    <c:forEach items="${vo.products}" var="item">
                        <tr id='trId___'>
                            <td>
                               <span style="position: relative;">
                                   <input field="formtable" name="productLevelCode"
                                          type="hidden" value="${item.productLevelCode}"
                                          style="width: 150px">
                                    <input field="formtable" name="productLevelName"  type="text" value="${item.productLevelName}"
                                           style="width: 150px" class="inputxt" >
                                    <a href="javascript:void(0);"
                                       onclick="selectProductLevel(this)" class="easyui-linkbutton"
                                       style="position: absolute;right:0;height: 24px;box-sizing: border-box;margin-right: 0;"
                                       plain="true" iconCls="icon-search"></a>
                                </span>

                            </td>
                            <%--<td>
                               <span style="position: relative;">
                                   <input field="formtable" name="productCode"
                                          type="hidden" value="${item.productCode}"
                                          style="width: 150px">
                                    <input field="formtable" name="productName"  type="text" value="${item.productName}"
                                           style="width: 150px" class="inputxt" nocheck="true">
                                    <a href="javascript:void(0);"
                                       onclick="selectProductInfo(this)" class="easyui-linkbutton"
                                       style="position: absolute;right:0;height: 24px;box-sizing: border-box;margin-right: 0;"
                                       plain="true" iconCls="icon-search"></a>
                                </span>

                            </td>--%>
                            <td>
                                <input field="formtable" name="scale" value="${item.scale}"
                                       type="text"
                                       style="width: 150px" class="inputxt">
                            </td>
                            <td>
                                <input field="formtable" name="remarks"  value="${item.remarks}"
                                       type="text"
                                       nocheck="true"
                                       style="width: 150px" class="inputxt">
                            </td>
                            <td>
                                <a  iconCls="icon-remove" href="#" onclick="deleteTrTable(this)">删除</a>
                            </td>
                        </tr>
                    </c:forEach>
                </c:if>
                </tbody>
            </table>
        </div>
    </div>
</div>
</body>
</html>

<script src="/resources/act/attachment/js/attachment.js"></script>

<script type="text/javascript">

    //关键指标js开始
    let vm = new Vue({
        el: "#app",
        data: function () {
            return {
                id: "${vo.id}",
                page: "dehd",
                viewStatus: "${viewStatus}",
                isActiviti: "${isActiviti}"
            }
        },
        methods: {
            handleRefresh: function (target) {
                let this_ = this;
                canSubmit = true;
                let data = createData();
                if (canSubmit) {
                    let postParams = data;
                    $.ajax({
                        url: "/act/ttActQuotaController/refresh",
                        type: "post",
                        dataType: "json",
                        data: JSON.stringify(postParams),
                        contentType: "application/json",
                        complete: function () {
                        },
                        success: function (res) {
                            closeProgressTop();
                            if (res.success) {
                                this_.$refs.targetTable.setTargetData(res.obj);
                            } else {
                                tip(res.msg);
                            }
                        },
                        error: function () {
                            closeProgressTop();
                        }
                    })
                }
            },
        }
    })
    //关键指标js结束

    $.fn.parseForm=function(){
        var serializeObj={};
        var array=this.serializeArray();
        var str=this.serialize();
        $(array).each(function(){
            if(serializeObj[this.name]){
                if($.isArray(serializeObj[this.name])){
                    serializeObj[this.name].push(this.value);
                }else{
                    serializeObj[this.name]=[serializeObj[this.name],this.value];
                }
            }else{
                serializeObj[this.name]=this.value;
            }
        });
        return serializeObj;
    };

    function createData(){
        checkproductSubmit();
        var data = $("#detailId").parseForm();
        data.target = vm.$refs.targetTable.getTargetData();
        return data;
    }

    function addDetail(){
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        if (categoriesCode == "") {
            tip("请先选择活动大类");
            return false;
        }else{
            id = "quotaDetailList";
            gridname = id;
            var addurl = "/page/ttActQuotaController/goUpdateOrAddDetail?1=1&tempUuid=${tempUuid}&categoriesCode="+categoriesCode+"&budgetCode="+budgetCode;
            createwindow("新增", addurl,  400, 400, {});
        }
    }
    function updateDetail() {
        var rowsData = $('#quotaDetailList').datagrid('getSelections');
        var myobj=eval(rowsData);
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        if (categoriesCode == "") {
            tip("请先选择活动大类");
            return false;
        }else{
            id = "quotaDetailList";
            gridname = id;
            var addurl = "/page/ttActQuotaController/goUpdateOrAddDetail?1=1&tempUuid=${tempUuid}&categoriesCode="+categoriesCode+"&id="+myobj[0].id+"&budgetCode="+budgetCode;;
            createwindow("编辑", addurl,  400, 400, {});
        }
    }

    $(document.body).css({
        "overflow-x": "auto",
        "overflow-y": "auto"
    });
    var trId = 0;
    var cloneTrTemp = "";
    $(function () {
        $('#templeteTable').hide();
        $('#addTrBtn').linkbutton({
            iconCls: 'icon-add'
        });
        var detail = '${load}';
        if(detail=="detail"){
            $('#addTrBtn').hide();
        }
        // addTrTable();
    });

    function loadSuccess() {
        setTimeout(function(){
            $("#quotaDetailList").datagrid("resize");
        },500);
    }

    function addTrTable() {
        var tr = $("#templeteTable tbody").html();
        cloneTrTemp = tr;
        var replaceName = tr.replace(/___/g, trId);
        $("#showTable tbody").append(replaceName);
        trId++;
    }

    function deleteTrTable(event) {
        $(event).parents("tr").remove();
    }

    function removeTempLete() {
        $('#templeteTable').remove();
    }

    //提交前处理
    function checkproductSubmit() {
        var b=true;
        var needShare = ${needShare};
        if (needShare == 1) {
            settingStatus();
        }
        if (ischeckProduct){
            b=checkTable()
        }
        if("${isActiviti}"=="1"){
            var target = vm.$refs.targetTable.getTargetData();
            $("#headTarget").val(JSON.stringify(target.headTarget));
            $("#itemTarget").val(JSON.stringify(target.itemTarget));
            $("#processKeyTemp").val(target.processKey);
        }
        return b;
    }

    //校验table
    function checkTable() {
        var canSubmit = true;
        var tableData = [];

        $("#showTable tbody tr").each(function () {
            if (canSubmit) {
                var obj = {};
                /*var productLevelName = $(this).find("input[name=productLevelName]").val();
                var productName = $(this).find("input[name=productName]").val();
                if (productLevelName == "" && productName == "") {
                    canSubmit = false;
                    tip("产品层级和产品需要选择一种");
                    return false;
                }*/
                $(this).find("td").each(function (index) {
                    if (canSubmit) {
                        $(this).find("input[field=formtable]").each(function () {
                            var inputName = $(this).attr("name");
                            obj[inputName] = $(this).val();
                            if (!$(this).val() && $(this).attr("type") !== "hidden" && $(this).attr("nocheck")!=="true") {
                                canSubmit = false;
                                $(this).focus();
                                var name = $("#showTable thead tr th").eq(index).text();
                                tip(name + "不能为空");
                                return false;
                            }
                        })

                    } else {
                        return false;
                    }
                });
                tableData.push(obj);
            } else {
                return false;
            }
        });
        let total = 0;
        tableData.forEach(function (item) {
           total = (parseFloat(total)*1000 + parseFloat(item.scale)*1000)/1000
        });
        if(total>100){
            canSubmit = false;
            tip("比例超过100%");
        }
        if (canSubmit) {
            $("#productJson").val(JSON.stringify(tableData))
        }
        return canSubmit;
    }
    var ischeckProduct=false;
    //该方法表示需要分摊产品 打开 产品分摊显示
    function settingStatus(){
        $("#actproduct").removeClass("hidden");
        ischeckProduct=true;
    }

    //选择产品层级
    function selectProductLevel(obj){
        url = "/page/tmApiProductLevelController/goProductListMain";
        width = 1000;
        height = 450;
        id = "productLevelList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData == '' || rowsData == null) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj=eval(rowsData);
                    $(obj).parent().find("input[name='productLevelCode']").val(myobj[0].text);
                    $(obj).parent().find("input[name='productLevelName']").val(myobj[0].src);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    //选择产品
    function selectProductInfo(obj){
        var url = "/page/tmApiProductInfoController/goProductInfoListMain";
        var width = 900;
        var height = 500;
        id = "productinfoList";
        var gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {

                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData == '' || rowsData == null) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj=eval(rowsData);
                    $(obj).parent().find("input[name='productCode']").val(myobj[0].productInfoCode);
                    $(obj).parent().find("input[name='productName']").val(myobj[0].productInfoName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectbudget(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "budgetCode";
        triggerName = "budgetName";
        url = "/page/ttApiBudgetController/goApiBudgetMain";
        width = 900;
        height = 500;
        id = "ttApibudgetList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#budgetCode").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetCode);
                    $("#" + triggerName).val(myobj[0].budgetName);
                    var budgetCode = myobj[0].budgetCode;
                    $.ajax({
                        url:"/budget/ttApiCostTypeCategoriesController/getCategoriesListByBudgetCode?budgetCode="+budgetCode,
                        dataType:'json',
                        type:'post',
                        async:false,
                        success:function(data){
                            if (data.length == 1) {
                                $("#categoriesCode").val(data[0].categoriesCode);
                                $("#categoriesName").val(data[0].categoriesName);
                            }else{
                                $("#categoriesCode").val("");
                                $("#categoriesName").val("");
                            }
                        }
                    })
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectCategories() {
        var budgetCode = $("#budgetCode").val();
        if (budgetCode == "") {
            tip("请先选择预算");
            return;
        }
        triggerId = "categoriesCode";
        triggerName = "categoriesName";
        url = "/page/ttApiCostTypeCategoriesController/goApiActSelectCategoriesMain?budgetCode="+budgetCode;
        width = 600;
        height = 500;
        id = "categoriesList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#categoriesCode").focus();
                if (rowsData.length == 0) {
                    iframe.tip("请至少选择一条数据");
                    return false;
                } else {
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].categoriesCode);
                    $("#" + triggerName).val(myobj[0].categoriesName);
                    $("#categoriesName").focus();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function impot() {
        quotaDetailListsearch();
    }

    function detailExcel() {
        var tempId = "${tempUuid}";
        <c:if test="${not empty importUploadUrl}">
            var data = ${importUploadUrl};
            data.strExtend1 = tempId;
            importExcel(data,impot)
        </c:if>
    }
</script>