<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="quota_list" class="easyui-layout" fit="true">
    <div region="center">
        <t:datagrid name="quotalist"  tagConf="${clickFunctionId}" controllerTarget="ttActQuotaController" methedTarget="findTtActQuotaPage" idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/act/ttActQuotaController/findTtActQuotaPage?clickFunctionId=${clickFunctionId}" pagination="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar1" field="extChar1"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar2" field="extChar2"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar3" field="extChar3"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar4" field="extChar4"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar5" field="extChar5"  hidden="true"></t:dgCol>
            <t:dgCol title="extChar6" field="extChar6"  hidden="true"></t:dgCol>
            <t:dgCol title="审批状态" field="bpmStatus" dictionary="bpm_status"  query="true"></t:dgCol>
            <t:dgCol title="流程编号" field="processKey" query="true"></t:dgCol>
            <t:dgCol title="活动编号" field="actCode" query="true"></t:dgCol>
            <t:dgCol title="活动名称" field="actName" query="true"></t:dgCol>
            <t:dgCol title="申请人" field="applyUserName"></t:dgCol>
            <t:dgCol title="申请时间" field="applyTime" formatter="yyyy-MM-dd" formType="date"></t:dgCol>
            <t:dgCol title="申请金额" field="amount"></t:dgCol>
            <t:dgCol title="预估销售额(客户)" field="fsalesAmountCustomer"></t:dgCol>
            <t:dgCol title="预估销售额(门店)" field="fsalesAmountTerminal"></t:dgCol>
            <t:dgCol title="创建人" field="createName" ></t:dgCol>
            <t:dgCol title="更新人" field="updateName" ></t:dgCol>
            <t:dgCol title="更新时间" field="updateDateStr"  formatter="yyyy-MM-dd" query="true" formType="date"></t:dgCol>

            <t:dgToolBar title="新增" operationCode="add" icon="icon-add" width="900" height="500" url="/page/ttActQuotaController/goUpdateOrAdd?clickFunctionId=${clickFunctionId}"
                         funname="add"></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" width="900" height="500" url="/page/ttActQuotaController/goUpdateOrAdd?clickFunctionId=${clickFunctionId}"
                         funname="update" callBackBefor="checkData"></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" icon="icon-edit" width="900" height="500" url="/page/ttActQuotaController/goUpdateOrAdd?clickFunctionId=${clickFunctionId}"
                         funname="detail"></t:dgToolBar>
            <t:dgToolBar operationCode="remove" title="删除" icon="icon-remove" url="/act/ttActQuotaController/deleteTtAct"
                         funname="deleteALLSelect"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut"
                         url="/act/commonExcelController/excel" excelName="定额活动" excelSheetName="定额活动" funname="excelCommonExport"></t:dgToolBar>
            <c:if test="${isDisplay == '1' }">
                <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn"
                             onclick="importExcel(${importUploadUrl}),impot"></t:dgToolBar>
            </c:if>
            <t:dgToolBar title="提交流程" operationCode="commit" icon="icon-edit" width="1400" height="600" url=""
                         funname="commit"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="/page/knlLogController/goShowLog"
                         width="1000" height="500"     funname="detail"></t:dgToolBar>
            <t:dgToolBar operationCode="bpmLog" title="流程日志" icon="icon-log" url="/page/knlLogController/goAuditTaskLogs"
                         width="1000" height="500"     funname="detail"></t:dgToolBar>
            <t:dgToolBar title="个性设置" operationCode="style" icon="icon-add" url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>
<script type="text/javascript">
    var pageCode = "dehd";
    /* 检查数据是否能够编辑*/
    function checkData() {
        var rowsDatas = $('#quotalist').datagrid('getSelections');
        if(rowsDatas.length!=1){
            tip("请选择一条数据操作");
            return false;
        }
        if(rowsDatas[0].bpmStatus=='2'||rowsDatas[0].bpmStatus=='3'){
            tip("该条数据不能进行编辑");
            return false;
        }
        return true;
    }
    /**提交工作流页面**/
    function commit(width,height) {
        var rowsDatas = $('#quotalist').datagrid('getSelections');
        if(rowsDatas.length!=1){
            tip("请选择一条数据操作");
            return;
        }
        if(rowsDatas[0].bpmStatus=='2'||rowsDatas[0].bpmStatus=='3'){
            tip("该条数据不能再次提交审批");
            return;
        }
        commitSub(width,height,pageCode);
    }
    /**执行提交**/
    function docommit(data){
        openProgressTop("正在提交.......");
        var rowsDatas = $('#quotalist').datagrid('getSelections');
        //封装参数
        data.businessObjId = rowsDatas[0].id;
        $.ajax({
            type: "POST",
            url: "/act/ttActQuotaController/subActiviti",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            success: function(data){
                if(data.success){
                    $.dialog({id: "activitiSubId"}).close();
                    quotalistsearch();
                    tip(data.msg);
                }else{
                    $.dialog({id: "activitiSubId"}).content.tip(data.msg);
                }
            },
            complete:function () {
                closeProgressTop();
            }
        });
    }

    function impot() {
        quotalistsearch();
    }
</script>
