<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools"/>
<div class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="processInstanceList"
                    actionUrl="/activiti/taProcessInstanceController/findProcessInstanceList?1=1" fitColumns="true"
                    idField="id" fit="true" queryMode="group">
            <t:dgCol title="编号" field="id" query="true"/>
            <t:dgCol title="流程Key" field="processDefinitionKey" query="true" width="80"/>
            <t:dgCol title="流程名称" field="processDefinitionName" query="true" width="80"/>
            <t:dgCol title="流程标题" field="processTitle" query="true" width="120"/>
            <t:dgCol title="流程实例ID" field="processInstanceId" hidden="true" width="120"/>
            <t:dgCol title="业务编码" field="businessObjNum" query="true" width="120"/>
            <t:dgCol title="发起人" field="startFullName" width="90" query="true"/>
            <t:dgCol title="当前任务名称" field="activityName" width="120"/>
            <t:dgCol title="当前任务处理人" field="activityUser" width="90"/>
            <t:dgCol title="开始时间" field="startTime" formatter="yyyy-MM-dd hh:mm:ss" width="120" query="true"/>
            <t:dgCol title="结束时间" field="endTime" formatter="yyyy-MM-dd hh:mm:ss" width="120" query="true"/>
            <t:dgCol title="耗时" field="spendTimes" width="100"/>
            <t:dgCol title="任务Id" field="taskId" hidden="true"/>
            <t:dgCol title="审批状态" sortable="false" field="runtimeStatusCode" width="80" query="true"
                     list="runtimeStatusList" selectValue="code" selectText="description" style="background:red;_true"/>
            <t:dgCol title="流程状态" sortable="false" field="isSuspended" width="80" query="true"
                     replace="已结束_finished,启动_false,暂停_true" style="background:red;_true"/>

            <t:dgToolBar  icon="icon-stop" id="stopId" url="/activiti/taProcessInstanceController/suspend" operationCode="stop"
                          funname="systemConfirmSelf"
                         params="processInstanceId" title="暂停"  callBackBefor="checkData"/>
            <t:dgToolBar  icon="icon-start" id="startId" operationCode="strat"
                         url="/activiti/taProcessInstanceController/restart"
                          funname="systemConfirmSelf"
                         params="processInstanceId" title="启动"/>
            <t:dgToolBar  icon="icon-remove" id="closeId" operationCode="close"
                         url="/activiti/taProcessInstanceController/closeProcessInstance"
                         funname="systemConfirmSelf" params="processInstanceId" title="关闭"/>
            <t:dgToolBar  icon="icon-check_back" operationCode="delegate"
                         url="/page/taTaskController/goReassignForm?view=false"
                          funname="add" params="taskId"
                         title="委派"/>
            <t:dgToolBar  icon="icon-look" id="processView" operationCode="look"
                         url="/page/taTaskController/goInstanceHandleTabForm?isView=true&isReadFlag=false" funname="view"
                         params="processInstanceId" title="查看"/>
            <t:dgToolBar  icon="icon-look" id="copyView" operationCode="copyView"
                         url="/page/taCarbonCopyController/goCopyPersonInfoMain?1=1" funname="view" params="processInstanceId"
                         title="查看抄送" width="600" height="400"/>
        </t:datagrid>
    </div>
</div>
<script type="text/javascript">
    //日期格式查询条件 开始日期
    $("input[name='startTime']").attr("class", "Wdate").click(function () {
        WdatePicker({dateFmt: 'yyyy-MM-dd'});
    });
    //日期格式查询条件 结束日期
    $("input[name='endTime']").attr("class", "Wdate").click(function () {
        WdatePicker({dateFmt: 'yyyy-MM-dd'});
    });
    function checkData() {
        debugger;
        var rowsDatas = $('#processInstanceList').datagrid('getSelections');
        if (rowsDatas.length >0) {
            for(var i=0;i<rowsDatas.length;i++){
                if(rowsDatas[i].isSuspended=="finished"){
                    tip("已结束不能操作");
                    return false;
                }
            }
        }
        return true;
    }

    function systemConfirmSelf(title, url, gridname, width, height, params) {
        debugger;
        var rowData = $('#' + gridname).datagrid('getSelected');
        if (rowData == null) {
            tip('请选择数据');
            return;
        }
        if(rowData.isSuspended=="finished"){
            tip("已结束不能操作");
            return ;
        }
        url = url+"?processInstanceId="+rowData.processInstanceId;
        createdialog('提示', '确认要操作？', url, gridname);
    }

</script>