<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>

<body>
<div class="easyui-layout" fit="true">
    <div region="center" style="width:300px;">
        <div tools="#tt" class="easyui-panel" style="" fit="true" border="false" id="function-panel">
            <t:datagrid name="sendCopyList" title="已选项"
                        actionUrl="/activiti/taCarbonCopyController/findCarbonCopyByTaProcessId?taProcessId=${taProcessId}"
                        idField="id" fit="true" fitColumns="true" queryMode="group" pagination="false"
                        singleSelect="false">
                <t:dgCol title="id" field="id" hidden="true"></t:dgCol>
                <t:dgCol title="角色/职位编码" field="code" query="true"></t:dgCol>
                <t:dgCol title="角色/职位名称" field="name" query="true"></t:dgCol>
                <t:dgCol title="类型" field="state" query="true" replace="角色_0,职位_1"></t:dgCol>
                <t:dgCol title="过滤条件" field="chooseCondition" replace="职位_0,当前组织_1,组织及组织以上_2,角色下所有职位_3"></t:dgCol>
                <t:dgToolBar title="移除" icon="icon-remove" url="" funname="delCC"></t:dgToolBar>
            </t:datagrid>
        </div>
    </div>
    <div region="west" style="width:380px;" split="true">
        <input type="hidden" id="taProcessId" value="${taProcessId}">
        <div id="useSendCopyListtb">

            <div class="datagrid-toolbar-but">
				<span style="float:left;">
                    <a href="#" id="addXpsact" class="easyui-linkbutton" plain="true" icon="icon-add"
                       onclick="saveSendCopyList()">添加</a>
				</span>
                <span style="float: right;">
                    <a href="#" id="addXpsact" class="easyui-linkbutton" icon="icon-search" onclick="loadData()">查询</a>
                    <a href="#" id="addXpsact" class="easyui-linkbutton" icon="icon-search"
                       onclick="resetQuery()">重置</a>
                </span>
            </div>
            <div class="datagrid-toolbar-search">
                <form id="useSendCopyListForm">
                    <div>
                        <label>抄送类型</label>
                        <select name="sendType" title="抄送类型" onchange="divShow()">
                            <option value="">---请选择---</option>
                            <option value="0">按角色</option>
                            <option value="1">按职位</option>
                        </select>
                    </div>
                    <div id="departDiv" style="display:none">
                        <label title="所属组织">所属组织</label>
                        <input style="width:100px" onkeypress="EnterPress(event)" onkeydown="EnterPress()" type="text"
                               id="orgTree" name="orgId" class="inuptxt"/>
                    </div>
                    <div id="posDiv" style="display:none">
                        <div>
                            <label>职位编码</label>
                            <input type="text" name="posCode" id="posCode">
                        </div>
                        <div>
                            <label>职位名称</label>
                            <input style="width:100px" type="text" name="posName" id="posName"/>
                        </div>
                    </div>
                    <div id="chooseCondition" style="display:none">
                        <label>筛选条件</label>
                        <select name="chooseCondition" id="chooseCondition" style="width:100px">
                            <option value="1">当前组织</option>
                            <option value="2">当前组织及以上</option>
                            <option value="3">角色下所有职位</option>
                        </select>
                    </div>
                    <div id="roleDiv" style="display:none">
                        <div>
                            <label>角色编码</label>
                            <input type="text" name="roleCode" id="roleCode">
                        </div>
                        <div>
                            <label>角色名称</label>
                            <input type="text" name="roleName" id="roleName"/>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <t:datagrid title="备选项" name="useSendCopyList"
                    actionUrl="/activiti/taCarbonCopyController/getRolesOrPositions?1=1"
                    idField="id" fit="true" fitColumns="true" queryMode="group" checkbox="false"
                    autoLoadData="false" singleSelect="false">
            <t:dgCol title="id" field="id" hidden="true"/>
            <t:dgCol title="角色/职位编码" field="roleCode" query="true" width="120"/>
            <t:dgCol title="角色/职位名称" field="roleName" query="true" width="120"/>
        </t:datagrid>
    </div>
</div>
<script type="text/javascript">
    $(function () {
        //FIXME 替换成通用的接口
        // $("#orgTree").combotree({
        //     url: 'tmOrgController.do?getParentOrg',
        //     onSelect: function (node) {
        //         $("#orgTree").val(node.id);
        //     }
        // });
    });

    function saveSendCopyList() {
        var taProcessId = $('#taProcessId').val();
        var chooseCon = $('#chooseCondition option:selected').val();
        var rowsData = $('#useSendCopyList').datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('至少选中一条');
            return;
        }
        var sendType = $("[name='sendType']").val();
        var codes = [];
        var names = [];
        for (var i = 0; i < rowsData.length; i++) {
            if (sendType == 0) {
                codes.push(rowsData[i].roleCode);
                names.push(rowsData[i].roleName);
            } else {
                codes.push(rowsData[i].positionCode);
                names.push(rowsData[i].positionName);
            }
        }
        $.ajax({
            url: "/activiti/taCarbonCopyController/saveCarbonCopy",
            type: 'post',
            data: {
                state: sendType,
                chooseCondition: chooseCon,
                taProcessId: taProcessId,
                code: codes.join(','),
                name: names.join(',')
            },
            cache: false,
            async: false,
            success: function (d) {
                var msg = d.msg;
                tip(msg);
                if (d.success) {
                    loadData();
                    $("#sendCopyList").datagrid('reload');
                }
            }
        });
    }

    function delCC() {
        var selectTarget = $("#sendCopyList").datagrid("getSelections");
        var delId = [];
        for (var i = 0; i < selectTarget.length; i++) {
            delId.push(selectTarget[i].id);
        }
        $.ajax({
            url: "/activiti/taCarbonCopyController/delCarbonCopyById",
            type: 'post',
            data: {
                delIds: delId.join(',')
            },
            cache: false,
            async: false,
            success: function (d) {
                var msg = d.msg;
                tip(msg);
                if (d.success) {
                    $("#sendCopyList").datagrid('reload');
                }
            }
        });
    }

    /**
     * 选择抄送类型。根据值显示相关的div
     */
    function divShow() {
        $("#posCode").val("");
        $("#posName").val("");
        $("#roleCode").val("");
        $("#roleName").val("");
        loadData();
        var sendType = $("[name='sendType']").val();
        if (sendType == "") {
            tip('请选择抄送类型!');
            return;
        }
        if (sendType == 0) {
            $("#departDiv").hide();
            $("#posDiv").hide();
            $("#roleDiv").show();
            $("#chooseCondition").show();
        } else {
            $("#departDiv").show();
            $("#posDiv").show();
            $("#roleDiv").hide();
            $("#chooseCondition").hide();
        }
    }

    function resetQuery() {
        var sendType = $("[name='sendType']").val();
        $("#posCode").val("");
        $("#posName").val("");
        $("#roleCode").val("");
        $("#roleName").val("");
        $("#orgTree").combotree('setValue', '');
        if (sendType == 0) {
            $("#useSendCopyList").datagrid({
                url: "/activiti/taCarbonCopyController/getRolesOrPositions",
                queryParams: {
                    sendType: sendType,
                    field: "id,roleCode,roleName"
                },
                columns: [[
                    {field: 'id', title: 'id', hidden: true},
                    {field: 'roleCode', title: '角色编码', width: 120},
                    {field: 'roleName', title: '角色名称', width: 120}
                ]]
            });
        } else {
            $("#useSendCopyList").datagrid({
                url: "/activiti/taCarbonCopyController/getRolesOrPositions",
                queryParams: {
                    sendType: sendType,
                    field: "id,roleCode,roleName"
                },
                columns: [[
                    {field: 'id', title: 'id', hidden: true},
                    {field: 'positionCode', title: '职位编码', width: 120},
                    {field: 'positionName', title: '职位名称', width: 120},
                    {field: 'orgName', title: '组织名称', width: 120}
                ]]
            });
        }
    }

    /**当选择了抄送类型后加载相应的数据*/
    function loadData() {
        var sendType = $("[name='sendType']").val();
        if (sendType == "") {
            tip('请选择抄送类型!');
            return;
        }
        if (sendType == 0) {
            $("#useSendCopyList").datagrid({
                url: "/activiti/taCarbonCopyController/getRolesOrPositions",
                queryParams: {
                    sendType: sendType,
                    roleName: $("#roleName").val(),
                    roleCode: $("#roleCode").val(),
                    orgId: '',
                    positionName: '',
                    field: "id,roleCode,roleName"
                },
                columns: [[
                    {field: 'id', title: 'id', hidden: true},
                    {field: 'roleCode', title: '角色编码', width: 120},
                    {field: 'roleName', title: '角色名称', width: 120}
                ]]
            });
        } else {
            $("#useSendCopyList").datagrid({
                url: "/activiti/taCarbonCopyController/getRolesOrPositions",
                queryParams: {
                    sendType: sendType,
                    roleName: '',
                    orgId: $("[name='orgId']").val(),
                    positionName: $("#posName").val(),
                    positionCode: $("#posCode").val(),
                    field: "id,roleCode,roleName"
                },
                columns: [[
                    {field: 'id', title: 'id', hidden: true},
                    {field: 'positionCode', title: '职位编码', width: 120},
                    {field: 'positionName', title: '职位名称', width: 120},
                    {field: 'orgName', title: '组织名称', width: 120}
                ]]
            });
        }
    }
</script>
</body>
