<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>活动大类</title>
    <t:base type="jquery,easyui,tools"></t:base>
</head>
<body class="easyui-layout" fit="true">
    <div data-options="region:'west',split:true" style="width:380px;">
        <t:formvalid action="/budget/ttCostTypeController/saveOrUpdateCategories" layout="div"  dialog="true" beforeSubmit="sumFineIds" formid="budgetSubjectsForm">
            <t:dgFormList expandParam="${clickFunctionId}" tagConf="${clickFunctionId}">
                <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                                defaultVal="${vo.id }"/>
                <t:dgFormColumn field="extChar1" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar1" optionType="input" required="false"
                                defaultVal="${vo.extChar1 }"/>
                <t:dgFormColumn field="extChar2" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar2" optionType="input" required="false"
                                defaultVal="${vo.extChar2 }"/>
                <t:dgFormColumn field="extChar3" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar3" optionType="input" required="false"
                                defaultVal="${vo.extChar3 }"/>
                <t:dgFormColumn field="extChar4" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar4" optionType="input" required="false"
                                defaultVal="${vo.extChar4 }"/>
                <t:dgFormColumn field="extChar5" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar5" optionType="input" required="false"
                                defaultVal="${vo.extChar5 }"/>
                <t:dgFormColumn field="categoriesCode" hidden="false" formClass="form" labelName="活动大类编号" optionType="input" required="false"
                                defaultVal="${vo.categoriesCode}" readOnly="true" />
                <t:dgFormColumn field="categoriesName" hidden="false" formClass="form" labelName="活动大类名称" optionType="input" required="true"
                                defaultVal="${vo.categoriesName}" />
                <t:dgFormColumn field="financialFeeCode" hidden="false" formClass="form" labelName="财务费用归类" optionType="select" typeGroupCode="financial_fee" required="true"
                                defaultVal="${vo.financialFeeCode}"/>
                <t:dgFormColumn field="businessFeeCode" hidden="false" formClass="form" labelName="业务费用归类" optionType="select" typeGroupCode="business_fee" required="true"
                                defaultVal="${vo.businessFeeCode}"/>
                <t:dgFormColumn field="budgetSubjectsCode" hidden="false" formClass="form" labelName="预算科目编码" optionType="choseDialog" required="true"
                                defaultVal="${vo.budgetSubjectsCode}" onclick="goSbudgetSubjects();" onClean="cleanSbudgetSubjects()" readOnly="true" />
                <t:dgFormColumn field="budgetSubjectsName" hidden="false" formClass="form" labelName="预算科目名称" optionType="input" required="false"
                                defaultVal="${vo.budgetSubjectsName}" readOnly="true" />
                <t:dgFormColumn field="orgJson" hidden="true" formClass="form" labelName="组织json" optionType="input" required="false"/>
                <t:dgFormColumn field="extendJson" hidden="true" formClass="form" labelName="扩展属性json" optionType="input" required="false"/>
                <t:dgFormColumn field="orgCodes_1" hidden="false"  formClass="form" labelName="可选组织" optionType="tags"  required="false"
                                formTags="${vo.orgFormTags}"  onclick="goOrg();" />
                <t:dgFormColumn field="orgTypeJson" hidden="true" formClass="form" labelName="可选组织类型json" optionType="input" required="false"/>
                <t:dgFormColumn field="orgTypes_1" hidden="false"  formClass="form" labelName="可选组织类型" optionType="tags"  required="false"
                                formTags="${vo.orgTypeFormTags}"  onclick="goOrgType();" />
                <t:dgFormColumn field="fineIds" hidden="true"   formClass="form" labelName="活动细类选择ids" optionType="input" typeGroupCode="above_audit" required="false"
                                defaultVal="${vo.fineIds}" lineNum="4"/>
                <t:dgFormColumn field="notes" hidden="false"  formClass="form"
                                defaultVal="${vo.notes}"
                                labelName="备注" optionType="textarea" rows="5" cols="500" required="false"/>
            </t:dgFormList>
        </t:formvalid>
    </div>
    <div data-options="region:'center'" >
        <t:datagrid  name="fineList" idField="id" queryMode="group" fit="true" fitColumns="true" singleSelect="false" checkbox="true"
                     actionUrl="/budget/ttCostTypeController/getFineListByCategories?code=${vo.categoriesCode}" pagination="false">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="活动细类编号" field="fineCode" ></t:dgCol>
            <t:dgCol title="活动细类名称" field="fineName" ></t:dgCol>
            <t:dgCol title="最近更新人" field="updateName" hidden="true" treefield="updateName"></t:dgCol>
            <t:dgCol title="最近更新时间" field="updateDate" hidden="true" treefield="updateDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <c:if test="${show eq '0'}">
                <t:dgToolBar title="关联活动细类" icon="icon-add" url="" funname="selfSelectFine" ></t:dgToolBar>
                <t:dgToolBar title="解除关联细类" icon="icon-remove" url="" funname="delteSelectFine" ></t:dgToolBar>
            </c:if>
        </t:datagrid>
    </div>
    <div data-options="region:'east',split:true" style="width:580px;">
        <t:datagrid  name="extendList" idField="id" queryMode="group" fit="true" checkbox="true" fitColumns="false" singleSelect="false" onLoadSuccess="initData"
                     actionUrl="/budget/categoriesExtendController/getMaiListPage?categoriesCode=${vo.categoriesCode}" pagination="false">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="字段编码" field="field" editor="{type:'validatebox',options:{required:true}}" ></t:dgCol>
            <t:dgCol title="字段名称" field="name" editor="{type:'validatebox',options:{required:true}}" ></t:dgCol>
            <t:dgCol title="是否显示" field="isShow" replace="是_1,否_0" editor="{type:'combobox',options:{valueField:'id',textField:'text',required:true,editable:false,data:[{'id':'1','text':'是'},{'id':'0','text':'否'}]}}" ></t:dgCol>
            <t:dgCol title="是否必填" field="required" replace="是_Y,否_N" editor="{type:'combobox',options:{valueField:'id',textField:'text',required:true,editable:false,data:[{'id':'Y','text':'是'},{'id':'N','text':'否'}]}}" ></t:dgCol>
            <t:dgCol title="类型" field="opType" replace="文本_text,下拉_select,选择_choose,年月_dateYearMonth" editor="{type:'combobox',options:{valueField:'id',textField:'text',required:true,editable:false,data:[{'id':'text','text':'文本'},{'id':'select','text':'下拉'},{'id':'choose','text':'选择'},{'id':'dateYearMonth','text':'年月'}]}}" ></t:dgCol>
            <t:dgCol title="排序" field="orderNum" editor="{type:'validatebox',options:{required:true}}" ></t:dgCol>
            <t:dgCol title="宽度" field="wideNum" editor="{type:'validatebox',options:{required:true}}" ></t:dgCol>
            <t:dgToolBar title="添加" detail="false" icon="icon-add" url="" funname="addExtend" ></t:dgToolBar>
            <t:dgToolBar title="修改" detail="false" icon="icon-edit" url="" funname="updateExtend" ></t:dgToolBar>
            <t:dgToolBar title="删除" detail="false" icon="icon-remove" url="" funname="removeExtend" ></t:dgToolBar>
        </t:datagrid>
    </div>
</body>
<script type="text/javascript">
    $(function () {
        $("#orgCodes_1").on('click', '.biz-tag-close', function () {
            $(this).parent().remove();
        });
        $("#orgTypes_1").on('click', '.biz-tag-close', function () {
            $(this).parent().remove();
        });
    });

    /**
     * 初始化扩展字段
     */
    function initData() {
        var rowsDetailDatas = $('#extendList').datagrid('getRows');
         if(rowsDetailDatas.length==0){
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'extChar5',name:'扩展字段5',required:'N',orderNum:'26',isShow:'0',opType:'text',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'extChar4',name:'扩展字段4',required:'N',orderNum:'25',isShow:'0',opType:'text',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'extChar3',name:'扩展字段3',required:'N',orderNum:'24',isShow:'0',opType:'text',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'extChar2',name:'扩展字段2',required:'N',orderNum:'23',isShow:'0',opType:'text',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'extChar1',name:'扩展字段1',required:'N',orderNum:'22',isShow:'0',opType:'text',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'productNum',name:'数量',required:'N',orderNum:'21',isShow:'0',opType:'text',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'price',name:'单价',required:'N',orderNum:'20',isShow:'0',opType:'text',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'unit',name:'单位',required:'N',orderNum:'19',isShow:'0',opType:'text',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'feeRate',name:'费率',required:'N',orderNum:'18',isShow:'0',opType:'text',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'orgName',name:'组织名称',required:'N',orderNum:'17',isShow:'0',opType:'choose',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'orgCode',name:'组织编码',required:'N',orderNum:'16',isShow:'0',opType:'choose',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'actYearMonth',name:'年月',required:'N',orderNum:'15',isShow:'0',opType:'dateYearMonth',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'fsalesAmountTerminal',name:'预估销售额(门店)',required:'N',orderNum:'14',isShow:'0',opType:'text',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'fsalesAmountCustomer',name:'预估销售额(客户)',required:'N',orderNum:'13',isShow:'0',opType:'text',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'payType',name:'支付方式',required:'N',orderNum:'12',isShow:'0',opType:'select',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'amount',name:'申请金额',required:'N',orderNum:'11',isShow:'0',opType:'text',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'productPolicyCode',name:'政策编码',required:'N',orderNum:'10',isShow:'0',opType:'choose',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'productPolicyName',name:'政策名称',required:'N',orderNum:'9',isShow:'0',opType:'choose',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'productCode',name:'产品编码',required:'N',orderNum:'8',isShow:'0',opType:'choose',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'productName',name:'产品名称',required:'N',orderNum:'7',isShow:'0',opType:'choose',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'terminalName',name:'门店名称',required:'N',orderNum:'6',isShow:'0',opType:'choose',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'terminalCode',name:'门店编码',required:'N',orderNum:'5',isShow:'0',opType:'choose',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'customerName',name:'客户名字',required:'N',orderNum:'4',isShow:'0',opType:'choose',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'customerCode',name:'客户编码',required:'N',orderNum:'3',isShow:'0',opType:'choose',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'actSubclassName',name:'细类名称',required:'N',orderNum:'2',isShow:'0',opType:'choose',wideNum:'130'}});
             $('#extendList').datagrid('insertRow',{index: 0,row: {id: generateUUID(),field:'actSubclassCode',name:'细类编码',required:'Y',orderNum:'1',isShow:'0',opType:'choose',wideNum:'130'}});
      }
    }

    /* 删除扩展信息 */
    function removeExtend() {
        var rowsData = $('#extendList').datagrid('getSelections');
        if(rowsData.length==0){
            tip("请选择要删除的数据");
            return;
        }
        for(var i=rowsData.length-1;i>=0;i--){
            var index = $('#extendList').datagrid('getRowIndex',rowsData[i]);
            $('#extendList').datagrid('deleteRow',index);
        }
    }

    /*** 新增扩展信息 */
    function addExtend() {
        $('#extendList').datagrid('insertRow',{
            index: 0,
            row: {
                id: generateUUID()
            }
        });
        $('#extendList').datagrid('beginEdit' ,0);
    }
    /*** 修改扩展信息 */
    function updateExtend() {
        var rowsDetailDatas = $('#extendList').datagrid('getSelections');
        if(rowsDetailDatas.length==0){
            tip("请选择一条数据");
            return;
        }
        for(var i=0;i<rowsDetailDatas.length;i++){
            var index = $('#extendList').datagrid('getRowIndex',rowsDetailDatas[i]);
            $('#extendList').datagrid('beginEdit' ,index);
        }
    }

    /*打开编辑*/
    function editorALl() {
        var rowsDetailDatas = $('#extendList').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
            var index = $('#extendList').datagrid('getRowIndex',rowsDetailDatas[i]);
            $('#extendList').datagrid('beginEdit' ,index);
        }
    }

    /*结束编辑*/
    function endEditorALl() {
        var rowsDetailDatas = $('#extendList').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
            var index = $('#extendList').datagrid('getRowIndex',rowsDetailDatas[i]);
            $('#extendList').datagrid('endEdit' ,index);
        }
    }


    /*** 解除活动关联 */
    function delteSelectFine() {
        var rowsData = $('#fineList').datagrid('getSelections');
        for(var i=rowsData.length-1;i>=0;i--){
            var index = $('#fineList').datagrid('getRowIndex',rowsData[i]);
            $('#fineList').datagrid('deleteRow',index);
        }
    }

    /** 汇总活动细类id,可选组织数据，字段扩展信息 */
    function sumFineIds() {
        var rowsData = $('#fineList').datagrid('getRows');
        var ids="";
        for(var i=0;i<rowsData.length;i++){
            if(i==0){
                ids+=rowsData[i].id;
            }else{
                ids+=","+rowsData[i].id;
            }
        }
        $("#fineIds").val(ids);
        var tags = getTags("orgCodes_1");
        $("#orgJson").val(JSON.stringify(tags));
        endEditorALl();
        var rowsDetailDatas = $('#extendList').datagrid('getRows');
        var extendJson =  JSON.stringify(rowsDetailDatas);
        $("#extendJson").val(extendJson);

        var orgTypeTags = getTags("orgTypes_1");
        $("#orgTypeJson").val(JSON.stringify(orgTypeTags));

    }

    /** 关联活动细类 */
    function selfSelectFine() {
        var title = "关联活动细类";
        var options = {};
        var addurl = "/page/ttCostTypeController/goFineSelectMain?dataType=0&categoriesCode=${vo.categoriesCode}";
        var width = 860;
        var height = 410
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            parent:'fineParent',
            id:'fine',
            cache: false,
            /* 为true等价于function(){} */
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    //选择好的数据
                    var rowsDatas = iframe.getSelectData();
                    if(rowsDatas.length==0){
                    }else{
                        var rowsSelectData = $('#fineList').datagrid('getRows');
                           for(var j=0;j<rowsDatas.length;j++){
                               var flag = true;
                               for(var i=0;i<rowsSelectData.length;i++){
                                 if(rowsDatas[j].id==rowsSelectData[i].id){
                                     flag = false;
                                 }
                               }
                               if(flag){
                                   insertFine(rowsDatas[j]);
                               }
                           }
                    }
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.extend(myOptions, options);
        safeShowDialog(myOptions);
    }
    /**将选择的细类加入*/
    function insertFine(rowsData) {
        $('#fineList').datagrid('insertRow',{
            index: 1,
            row: {
                id: rowsData.id,
                fineCode: rowsData.fineCode,
                fineName: rowsData.fineName,
                updateName: rowsData.updateName,
                updateDate: rowsData.updateDate
            }
        });
    }
    /** 清除预算科目 */
    
    function cleanSbudgetSubjects() {
        $("#budgetSubjectsCode").val("");
        $("#budgetSubjectsName").val("");
    }
    
    /** 选择科目 */
    function goSbudgetSubjects(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "budgetSubjectsCode";
        triggerName = "budgetSubjectsName";
        url = "/page/ttApiBudgetController/goBudgetSubjects";
        width = 1000;
        height = 450;
        id = "budgetSubjectsList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetSubjectsCode);
                    $("#" + triggerName).val(myobj[0].budgetSubjectsName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    /** 选择组织 */
    function goOrg(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "budgetDepartCode";
        triggerName = "budgetDepartName";
        url = "/page/tmApiOrgController/goOrgListMain?singleSelect=false";
        width = 1000;
        height = 450;
        id = "orgList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).treegrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj=eval(rowsData);
                    var tagArray = [];
                    $(myobj).each(function(index,item){
                        var tag = {};
                        tag["name"] = item.src;
                        tag["code"] = item.text;
                        tagArray.push(tag);
                    });

                    renderTag("orgCodes_1", tagArray);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /** 选择组织类型 */
    function goOrgType(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        url = "/page/tmApiOrgController/goOrgTypeListMain?singleSelect=false";
        width = 500;
        height = 450;
        id = "orgTypeList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj=eval(rowsData);
                    var tagArray = [];
                    $(myobj).each(function(index,item){
                        var tag = {};
                        tag["name"] = item.dictValue;
                        tag["code"] = item.dictCode;
                        tagArray.push(tag);
                    });

                    renderTag("orgTypes_1", tagArray);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
</script>
</html>