<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>添加活动</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        #content{
            height: auto!important;
        }
    </style>
</head>
<body class="easyui-layout" fit="true">
    <div region="center" style="overflow: auto;">
        <t:formvalid action=""  layout="div"
                     dialog="true" formid="detailId">
            <t:dgFormList layoutStyle="horizontal">
                <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                                defaultVal="${vo.id }"/>
                <t:dgFormColumn field="updatedJsonData" hidden="true" formClass="form" labelName="updatedJsonData" optionType="input" required="false"
                                defaultVal=""/>
                <t:dgFormColumn field="tempUuid" hidden="true" formClass="form" labelName="tempUuid" optionType="input" required="false"
                                defaultVal="${tempUuid}"/>
                <t:dgFormColumn field="auditCode" hidden="false" formClass="biz-col-50 mb5 form" labelName="核销总单编码" optionType="input"  required="false"
                             readOnly="true"   defaultVal="${vo.auditCode}"/>
                <t:dgFormColumn field="auditName" hidden="false" formClass="biz-col-50 mb5 form" labelName="核销总单名称" optionType="input"  required="true"
                              dataType="*"  defaultVal="${vo.auditName}"/>

                <t:dgFormColumn field="remarks" hidden="false" formClass="biz-col-100 mb5 form" labelName="备注" optionType="textarea"  required="false"
                                rows="3" cols="5" defaultVal="${vo.remarks}" style="width: 77%"/>
            </t:dgFormList>
        </t:formvalid>
        <t:datagrid name="ttAuditActDetaillist"   idField="id" queryMode="group" fit="true" fitColumns="true"
                specialSearch="true"    actionUrl="/pay/ttAuditActDetailController/findTtAuditActDetailPage?tempUuid=${tempUuid}" pagination="false">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="核销明细编号" field="auditDetailCode" query="false"></t:dgCol>
            <t:dgCol title="申请明细编号" field="actDetailCode" query="false"></t:dgCol>
            <t:dgCol title="客户" field="customerName" query="true"></t:dgCol>
            <t:dgCol title="门店" field="terminalName"  query="false"></t:dgCol>
            <t:dgCol title="活动细类" field="actSubclassName"  query="true"></t:dgCol>
            <t:dgCol title="支付方式" field="payType" dictionary="pay_type"  query="false"></t:dgCol>
            <t:dgCol title="申请金额" field="amount" ></t:dgCol>
            <t:dgCol title="已核销金额" field="auditAmount"  ></t:dgCol>
            <t:dgCol title="超额核销比例" field="extraAuditRatio" hidden="true"  ></t:dgCol>
            <t:dgCol title="最大核销金额" field="maxAuditAmount" hidden="true" ></t:dgCol>

            <t:dgCol title="本次核销金额" field="currentAmount" editor="{type:'numberbox',options:{min:0,value:''}}"></t:dgCol>
            <t:dgCol title="完全核销" field="auditStatus" dictionary="is_no" editor="{type:'combobox',options:{valueField:'id',textField:'text',panelHeight:45,required:true,editable:false,data:[{'id':'1','text':'是'},{'id':'0','text':'否'}]}}"></t:dgCol>
            <t:dgCol title="申请备注" field="actRemarks"  ></t:dgCol>
            <t:dgCol title="核销备注" field="auditRemarks" editor="text"></t:dgCol>

            <t:dgToolBar title="新增" icon="icon-add" width="1200" height="600" url="/page/ttApiActController/goApiActDetailMain"
                         funname="selectActDetail"></t:dgToolBar>
            <t:dgToolBar title="删除" icon="icon-delete" width="1200" height="600" url="/pay/ttAuditActDetailController/delActDetail"
                         funname="deleteALLSelect_"></t:dgToolBar>
            <t:dgToolBar title="导入" icon="icon-dataIn" width="1200" height="600" url="/pay/ttAuditActDetailController/dataIn"
                         funname="detail"></t:dgToolBar>
        </t:datagrid>
    </div>
<script type="text/javascript">
    var tempUuid='${tempUuid}';
    function selectActDetail(){
        var url = "/page/ttApiActController/goApiActDetailMain?tempUuid="+tempUuid;
        var width = 1000;
        var height = 450;
        id = "actDetailSelectlist";
        var gridname = id;
        var myOptions = {
            opacity : 0.3,
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData == '' || rowsData == null) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }
                } else {
                    //提交数据到后台表里
                    $.ajax({
                        url : "/pay/ttAuditActDetailController/saveAuditActDetail",
                        type : 'post',
                        data : {"tempUuid":tempUuid,"acts":JSON.stringify(rowsData)},
                        cache : false,
                        success : function(data) {
                            tip(data.msg);
                            if (!data.success) {
                                tip(data.msg);
                                return false;
                            }
                            $('#ttAuditActDetaillist').datagrid('reload');
                        }
                    });
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        };
        safeShowDialogParent(myOptions);
    }

    function deleteALLSelect_(title, url, gname, deleteCallback) {
        gridname = gname;
        var ids = [];
        var rows = $("#" + gname).datagrid('getSelections');
        if (rows.length > 0) {
            $.dialog.setting.zIndex = 3000;
            getSafeJq().dialog.confirm("你确定永久删除该数据吗?", function (r) {
                if (r) {
                    for (var i = 0; i < rows.length; i++) {
                        ids.push(rows[i].id);
                    }
                    $.ajax({
                        url: url,
                        type: 'post',
                        dataType: 'json',
                        data: {
                            ids: ids.join(',')
                        },
                        cache: false,
                        success: function (data) {
                            var msg = data.msg;
                            if (data.success) {
                                tip(msg, 'info');
                                reloadTable();
                                if (deleteCallback) {
                                    deleteCallback();
                                }
                                $("#" + gname).datagrid('unselectAll');
                                ids = '';
                            } else {
                                tip(msg, 'error');

                            }
                        },
                        error: function () {
                            tip("客户端请求错误", 'error');
                            return false;
                        }
                    });
                }
            });
        } else {
            tip("请选择需要删除的数据");
        }
    }

    $(document).ready(function(){
        //初始化编码器，及添加单击行事件开始编辑
        $("#ttAuditActDetaillist").datagrid({
            onClickRow:function(rowIndex, rowData){
                $(this).datagrid('beginEdit', rowIndex);
                //
                var editors=$(this).datagrid('getEditors',rowIndex);

            }
        });
    });
    //保存修改操作
    function doSave(){
        var b=true;
        if(formName_detailId.check()){
            // var updated=$("#ttAuditActDetaillist").datagrid("getChanges","updated");
            var rows=$("#ttAuditActDetaillist").datagrid("getRows");
            var lineNo;
            //最大可核销金额
            var maxAmountTemp = 0;
            for(var index = 0;index<rows.length;index++){
                row = rows[index];
                var rowIndex=$("#ttAuditActDetaillist").datagrid("getRowIndex",row);
                $("#ttAuditActDetaillist").datagrid('endEdit', rowIndex);
                var maxAuditAmount = row.maxAuditAmount;
                var auditAmount = row.auditAmount;
                var currentAmount = row.currentAmount;
                if(parseFloat(maxAuditAmount)<parseFloat(auditAmount)+parseFloat(currentAmount)){
                    maxAmountTemp = parseFloat(maxAuditAmount)-parseFloat(auditAmount);
                    lineNo = rowIndex;
                    b = false;
                    break;
                }
            }
            if(!b){
                tip("第"+(lineNo+1)+"行超过允许最大核销金额："+maxAmountTemp);
                return b;
            }
            if (!(rows==null || rows==undefined|| rows.length==0)){  //有修改时需要提交一次方法
                $("#updatedJsonData").val(JSON.stringify(rows));
                b=sub();
            }else{
                $("#updatedJsonData").val('[]');
                b=sub();
            }
        }else{
            b = false;
        }
        return b;
    }

    function sub(){
        var b=false;
        $.ajax({
            url : "/pay/ttAuditController/saveAudit",
            type : 'post',
            async: false,
            data : $("#detailId").serialize(),
            cache : false,
            success : function(data) {
                if (data.success) { //提交form数据
                    b= data.success;
                }
                tip(data.msg)
            }
        });
        return b;
    }
</script>
</body>
</html>
