<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="estimate_extract_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="estimateExtractList" tagConf="${clickFunctionId}" controllerTarget="ttEstimateExtractController" methedTarget="findTtEstimateExtractPage" idField="id" queryMode="group" fit="true" fitColumns="false"
                    actionUrl="/pay/ttEstimateExtractController/findTtEstimateExtractPage?clickFunctionId=${clickFunctionId}" pagination="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="预提类型" field="estimateType" query="true" dictionary="estimate_type"></t:dgCol>
            <t:dgCol title="预提明细编号" field="estimateCode" query="true"></t:dgCol>
            <t:dgCol title="预提年月" field="year" query="true" dictionary="financial_year"></t:dgCol>
            <t:dgCol title="活动年月" field="actYear" query="true" dictionary="financial_year"></t:dgCol>
            <t:dgCol title="活动总单号" field="actCode" ></t:dgCol>
            <t:dgCol title="活动明细编号" field="actDetailCode" ></t:dgCol>
            <t:dgCol title="活动名称" field="actName" ></t:dgCol>
            <t:dgCol title="组织" field="orgName" ></t:dgCol>
            <t:dgCol title="客户" field="custName" ></t:dgCol>
            <t:dgCol title="预算科目" field="budgetSubjectsName" ></t:dgCol>
            <t:dgCol title="活动大类" field="categoriesName" ></t:dgCol>
            <t:dgCol title="活动细类" field="fineName" ></t:dgCol>
            <t:dgCol title="产品层级" field="productLevelName" ></t:dgCol>
            <t:dgCol title="物料" field="productName" ></t:dgCol>
            <t:dgCol title="活动开始时间" field="beginTime"  formatter="yyyy-MM-dd"></t:dgCol>
            <t:dgCol title="活动结束时间" field="endTime"  formatter="yyyy-MM-dd"></t:dgCol>
            <t:dgCol title="支付方式" field="payType" dictionary="pay_type"></t:dgCol>
            <t:dgCol title="活动申请金额" field="actAmount" ></t:dgCol>
            <t:dgCol title="预提金额" field="estimateAmount" ></t:dgCol>

            <t:dgToolBar title="手工预提" operationCode="add" icon="icon-add" width="400" height="500" url="/page/ttEstimateExtractController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="add"></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" width="400" height="500" url="/page/ttEstimateExtractController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="manualUpdate" ></t:dgToolBar>
            <t:dgToolBar title="申请预提" operationCode="edit" icon="icon-edit" width="400" height="250" url=""
                         funname="applyEstimate" ></t:dgToolBar>
            <%--<t:dgToolBar title="合同费用" operationCode="edit" icon="icon-edit" width="400" height="250" url=""
                         funname="contractCostEstimate" ></t:dgToolBar>--%>
            <t:dgToolBar title="费用池余额" operationCode="edit" icon="icon-edit" width="400" height="250" url=""
                         funname="feePoolAmount" ></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" icon="icon-edit" width="400" height="500" url="/page/ttEstimateExtractController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="detail"></t:dgToolBar>
            <t:dgToolBar operationCode="remove" title="删除" icon="icon-remove" url="/pay/ttEstimateExtractController/deleteTtEstimateExtract"
                         funname="deleteALLSelect"></t:dgToolBar>
            <t:dgToolBar operationCode="log" title="日志" icon="icon-log" url="/page/knlLogController/goShowLog"
                         width="1000" height="500"     funname="detail"></t:dgToolBar>
            <t:dgToolBar operationCode="style" title="个性设置" icon="icon-add" url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>

        </t:datagrid>
    </div>
</div>
<script>
    function manualUpdate() {
        var rowsData = $('#estimateExtractList').datagrid('getSelections');
        var myobj=eval(rowsData);
        //修改只允许修改手工预提
        if (myobj[0].estimateType != "30") {
            tip("只有手工预提可以编辑！");
            return false;
        }else{
            var addurl = "/page/ttEstimateExtractController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}&id="+myobj[0].id;
            createwindow("编辑", addurl,  400, 400, {});
        }
    }

    function applyEstimate() {
        getSafeJq().dialog.confirm("你确定申请预提吗?", function (r) {
            if (r) {
                $.ajax({
                    url: "/pay/ttEstimateExtractController/applyEstimate",
                    type: 'post',
                    dataType: 'json',
                    data: {
                    },
                    cache: false,
                    success: function (data) {
                        tip(data.msg);
                        if (data.success) {
                            $("#estimateExtractList").datagrid("reload");
                        }
                    },
                    error: function () {
                    }
                });
            }
        });
    }
    function feePoolAmount() {
        getSafeJq().dialog.confirm("你确定费用池余额预提吗?", function (r) {
            if (r) {
                $.ajax({
                    url: "/pay/ttEstimateExtractController/feePoolAmountEstimate",
                    type: 'post',
                    dataType: 'json',
                    data: {
                    },
                    cache: false,
                    success: function (data) {
                        tip(data.msg);
                        if (data.success) {
                            $("#estimateExtractList").datagrid("reload");
                        }
                    },
                    error: function () {
                    }
                });
            }
        });
    }

    // function contractCostEstimate() {
    //     getSafeJq().dialog.confirm("你确定合同费用预提吗?", function (r) {
    //         if (r) {
    //             $.ajax({
    //                 url: "/pay/ttEstimateExtractController/contractCostEstimate",
    //                 type: 'post',
    //                 dataType: 'json',
    //                 data: {
    //                 },
    //                 cache: false,
    //                 success: function (data) {
    //                     tip(data.msg);
    //                     if (data.success) {
    //                         $("#estimateExtractList").datagrid("reload");
    //                     }
    //                 },
    //                 error: function () {
    //                 }
    //             });
    //         }
    //     });
    // }

</script>
