<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div class="easyui-layout" fit="true" id="visitGroupList">
    <div region="center" style="padding:1px;">
        <t:datagrid name="visitGroupDataGrid" checkbox="true" singleSelect="false"  fitColumns="true" title=""
                    actionUrl="/sfaapi/visitGroupController/findVisitGroupPage?1=1" idField="id" fit="true" queryMode="group">
            <t:dgCol title="id" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="操作" field="opt"></t:dgCol>
            <t:dgCol title="用户主键" field="userId" hidden="true"></t:dgCol>
            <t:dgCol title="人员账号" field="userName" hidden="true" sortable="false"></t:dgCol>
            <t:dgCol title="人员新明" field="fullName" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="职位主键" field="posId" hidden="true"></t:dgCol>
            <t:dgCol title="职位编码" field="posCode" hidden="true"></t:dgCol>
            <t:dgCol title="职位名称" field="posName" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="组织主键" field="orgId" hidden="true"></t:dgCol>
            <t:dgCol title="组织编码" field="orgCode" hidden="true"></t:dgCol>
            <t:dgCol title="所属组织" field="orgName" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="线路组名称" field="groupName" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="状态" field="status" sortable="false" dictionary="enable_status" query="true"></t:dgCol>
            <t:dgCol title="创建日期" field="createDate" sortable="false" formatter="yyyy-MM-dd HH:mm:ss"></t:dgCol>
            <t:dgCol title="创建人" field="createName" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="修改日期" field="createDate" sortable="false" formatter="yyyy-MM-dd HH:mm:ss"></t:dgCol>
            <t:dgCol title="最后修改人" field="updateName" sortable="false" hidden="true"></t:dgCol>
            <t:dgFunOpt title="查询网点" funname="expendVisitClient(id)"></t:dgFunOpt>

             <t:dgToolBar title="新增" operationCode="add" icon="icon-add" url="/page/visitGroupController/goVisitGroupForm?1=1&operation=add" funname="add"></t:dgToolBar>
             <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" url="/page/visitGroupController/goVisitGroupForm?1=1&operation=update" funname="update"></t:dgToolBar>
             <t:dgToolBar title="查看" operationCode="search" icon="icon-search" url="/page/visitGroupController/goVisitGroupForm?1=1&operation=search" params="id"  funname="view"></t:dgToolBar>
             <t:dgToolBar title="启用" operationCode="start" icon="icon-start" url=""  funname="qiyong()"></t:dgToolBar>
             <t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url=""  funname="tingyong()"></t:dgToolBar>
             <t:dgToolBar title="删除" operationCode="delete" icon="icon-remove" url="/sfaapi/visitGroupController/deleteVisitGroup?1=1" funname="deleteALLSelect"></t:dgToolBar>
        </t:datagrid>
    </div>
    <div data-options="region:'east',
		title:'网点列表',
		collapsed:true,
		split:true,
		border:false,
		onExpand : function(){
			li_east = 1;
		},
		onCollapse : function() {
		    li_east = 0;
		}"
         style="width: 800px; overflow: hidden;">
        <div class="easyui-panel" style="padding: 0;" fit="true" border="false" id="visitClientList"></div>
    </div>
</div>
<script type="text/javascript" src="pages/com/biz/eisp/excel/importData-NoHandler.js"></script>`
<script type="text/javascript">

    var li_east = 0;

    function expendVisitClient(id){
        if(li_east == 0){
            $('#visitGroupList').layout('expand','east');
        }
        $('#visitClientList').panel("refresh", "/page/visitGroupController/goVisitClientMain?1=1&id="+id);
    }


    //批量启用
    function qiyong(){
        var rowsData = $('#visitGroupDataGrid').datagrid('getSelections');
        if( rowsData.length > 0){
            var ids = "";
            for(var i = 0;i<rowsData.length;i++){
                if(i==0){
                    ids = rowsData[i].id;
                }else{
                    ids +=","+rowsData[i].id;
                }
            }
            $.ajax({
                url : '/pay/visitGroupController/startVisitGroup?1=1',
                type : 'post',
                dataType:"json",
                async: false,
                data : {
                    "ids" :ids
                },
                cache : false,
                success : function(data) {
                    tip(data.msg);
                    $("#visitGroupDataGrid").datagrid('reload');
                },
                error : function(){
                    tip('服务器繁忙，请稍后再试');
                }
            });

        }else{
            $.messager.alert('提示','至少选择一条');
            return;
        }
    }

    //批量停用
    function tingyong(){
        var rowsData = $('#visitGroupDataGrid').datagrid('getSelections');
        if( rowsData.length > 0){
            var ids = "";
            for(var i = 0;i<rowsData.length;i++){
                if(i==0){
                    ids = rowsData[i].id;
                }else{
                    ids +=","+rowsData[i].id;
                }
            }
            $.ajax({
                url : '/pay/payPolicyController/stopVisitGroup?1=1',
                type : 'post',
                dataType:"json",
                async: false,
                data : {
                    "ids" :ids
                },
                cache : false,
                success : function(data) {
                    tip(data.msg);
                    $("#visitGroupDataGrid").datagrid('reload');
                },
                error : function(){
                    tip('服务器繁忙，请稍后再试');
                }
            });

        }else{
            $.messager.alert('提示','至少选择一条');
            return;
        }
    }

</script>

