<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete" extendUrlKey="projectActForm"></t:base>
<head>
    <style>
        .form-group {
            padding: 10px;
            box-sizing: border-box;
        }

        .form-input label {
            display: inline-block;
            width: 130px;
            text-align: right;
            line-height: 24px;
        }

        .form-input input {
            height: 24px;
            border: 1px solid #ddd;
            -moz-border-radius: 2px;
            -webkit-border-radius: 2px;
            border-radius: 2px;
            outline: none;
            padding: 3px 2px;
            width: 150px;
            box-sizing: border-box;
        }

        .form-input textarea {
            width: 100%;
            border: 1px solid #ddd;
            -moz-border-radius: 2px;
            -webkit-border-radius: 2px;
            border-radius: 2px;
            outline: none;
            padding: 3px 2px;
            box-sizing: border-box;
        }

        .form-table table {
            width: 100%;
            border-collapse: collapse;
            background: #f7f7f7;
        }

        .form-table table td, .form-table table th {
            height: 30px;
            border: 1px solid #eeeeee;
            position: relative;
            text-align: center;
        }

        .form-table table th {
            background: #f6f6f6;
        }

        .form-table table td input:not([type=checkbox]) {
            width: 100%;
            height: 30px;
            padding-right: 30px;
            border: none;
        }

        .form-table table td span.searchIcon {
            position: absolute;
            right: 5px;
            top: 7px;
            font-size: 16px;
            color: #dfdfdf;
            cursor: pointer;
        }

        .form-table {
            width: 100%;
            overflow-x: auto;
        }

        table.classify {
            table-layout: fixed;
        }

        .budgeTable {
            table-layout: fixed;
            background: #f7f7f7;
        }

        .operate-col {
            width: 60px;
            text-align: center;
        }

        /*tabs*/
        .tabs-menu {
            width: 100%;
            height: 35px;
            box-sizing: border-box;
        }

        .tab-menu {
            position: relative;
            display: inline-block;
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
            height: 100%;
            padding: 12px 16px;
            text-decoration: none;
            cursor: pointer;
            -webkit-transition: color .3s cubic-bezier(.645, .045, .355, 1);
            transition: color .3s cubic-bezier(.645, .045, .355, 1);
            border-bottom: 1px solid transparent;
        }

        .tab-menu.active {
            color: #0F467C;
            border-color: #0F467C;
        }

        .hide-tab-content {
            display: none;
        }

        .tab-menu .remove-tab {
            color: #0F467C;
            cursor: pointer;
        }

        .delete-row {
            color: #0F467C;
            text-underline: none;
            cursor: pointer;
        }

        .tab-tables {
            position: relative;
        }

        .tab-tables .tabs-menu {
            padding-left: 120px;
        }

        .tab-tables .add-classify {
            position: absolute;
            top: 7px;
            left: 10px;
        }

        #content {
            height: 127px;
        }
    </style>
</head>
<body class="easyui-layout">
<div data-options="region:'center'">
    <div id="app">
        <div class="form-group">
            <%--关键指标html开始--%>
            <target-table ref="targetTable" :id="id" :page="page" :show-target="isActiviti" :view-status="viewStatus"
                          @refresh="handleRefresh"></target-table>
            <%--关键指标html结束--%>
            <%--
        <div class="flex flex-align-items-center mb10">
            <input type="hidden" id="actId">
            <input type="hidden" id="actCode">
            <div class="form-input flex-1">
                <label>活动名称：<span style="color:red;">*</span></label>
                <input type="text" id="actName">
            </div>
            <div class="form-input flex-1">
                <label>起止时间：<span style="color:red;">*</span></label>
                <input type="text" id="beginDate" readonly class='Wdate'
                       onfocus="WdatePicker({dateFmt:'yyyy-MM-dd',maxDate:'#F{$dp.$D(\'endDate\')}'})">~
                <input type="text" id="endDate" readonly class='Wdate'
                       onfocus="WdatePicker({dateFmt:'yyyy-MM-dd',minDate:'#F{$dp.$D(\'beginDate\')}'})">
            </div>
        </div>
        <div class="form-input flex flex-align-items-center mb10">
            <label class="flex-none">备注：</label>
            <textarea id="remarks" class="flex-auto" rows="3"></textarea>
        </div>
            --%>
            <div style="width: 100%;height: 135px">
                <input type="hidden" id="actId">
                <input type="hidden" id="actCode">
                <t:formvalid action="/" layout="div"
                             dialog="true" formid="detailId">
                    <t:dgFormList layoutStyle="horizontal" tagConf="${clickFunctionId}">
                        <t:dgFormColumn field="actName" hidden="false" formClass="biz-col-50 mb5 form" labelName="活动名称"
                                        optionType="input" required="true"
                                        defaultVal="${vo.actName}"/>
                        <t:dgFormColumn field="beginDate" extendField="endDate" extendFieldVal="${vo.endDate}"
                                        hidden="false" formClass="biz-col-50 mb5 form" labelName="起止时间"
                                        optionType="date_begin_end" required="true"
                                        defaultVal="${vo.beginDate}"/>
                        <t:dgFormColumn field="extChar1" hidden="false" formClass="biz-col-50 mb5 form"
                                        labelName="extChar1" optionType="optionType" required="false"
                                        defaultVal="${vo.extChar1 }"/>
                        <t:dgFormColumn field="extChar2" hidden="false" formClass="biz-col-50 mb5 form"
                                        labelName="extChar2" optionType="optionType" required="false"
                                        defaultVal="${vo.extChar2 }"/>
                        <t:dgFormColumn field="extChar3" hidden="false" formClass="biz-col-50 mb5 form"
                                        labelName="extChar3" optionType="optionType" required="false"
                                        defaultVal="${vo.extChar3 }"/>
                        <t:dgFormColumn field="extChar4" hidden="false" formClass="biz-col-50 mb5 form"
                                        labelName="extChar4" optionType="optionType" required="false"
                                        defaultVal="${vo.extChar4 }"/>
                        <t:dgFormColumn field="extChar5" hidden="false" formClass="biz-col-50 mb5 form"
                                        labelName="extChar5" optionType="optionType" required="false"
                                        defaultVal="${vo.extChar5 }"/>
                        <t:dgFormColumn field="extChar6" hidden="false" formClass="biz-col-50 mb5 form"
                                        labelName="extChar6" optionType="optionType" required="false"
                                        defaultVal="${vo.extChar6 }"/>
                        <t:dgFormColumn field="extChar7" hidden="false" formClass="biz-col-50 mb5 form"
                                        labelName="extChar7" optionType="optionType" required="false"
                                        defaultVal="${vo.extChar7 }"/>
                        <t:dgFormColumn field="extChar8" hidden="false" formClass="biz-col-50 mb5 form"
                                        labelName="extChar8" optionType="optionType" required="false"
                                        defaultVal="${vo.extChar8 }"/>
                        <t:dgFormColumn field="extChar9" hidden="false" formClass="biz-col-50 mb5 form"
                                        labelName="extChar9" optionType="optionType" required="false"
                                        defaultVal="${vo.extChar9 }"/>
                        <t:dgFormColumn field="remarks" hidden="false" formClass="biz-col-100 mb5 form" labelName="备注"
                                        optionType="textarea" required="false"
                                        rows="2" cols="5" defaultVal="${vo.remarks}"
                                        style="width: 826px; height: 65px;"/>
                    </t:dgFormList>
                </t:formvalid>
            </div>


            <div class="form-input flex flex-align-items-start">
                <div class="flex-none">
                    <label id="selectBudgeText_">选择预算：</label>
                    <div class="text-right mr10">
                        <span onclick="selectBudge()" class="fa fa-search" id="selectBudge_"
                              style="display: block;font-size: 16px;"></span>
                    </div>
                </div>
                <div class="form-table flex-auto flex flex-align-items-start">
                    <table class="budgeTable" id="selectTable">
                        <thead>
                        <tr>
                            <th>预算编码</th>
                            <th>预算科目</th>
                            <th>年</th>
                            <th>月</th>
                            <th hidden="true">产品层级编码</th>
                            <th hidden="true">产品层级名称</th>
                            <th>余额</th>
                            <th>使用上限</th>
                            <th class='operate-col'>操作</th>
                        </tr>
                        </thead>
                        <tbody>

                        </tbody>
                        <tfoot>

                        </tfoot>
                    </table>
                </div>
            </div>
            <div class="tab-tables mt20">
                <a href="javascript:void(0)" class="add-classify easyui-linkbutton l-btn l-btn-plain mr10"
                   onclick="selectClassify()">
                             <span class="l-btn-left">
                                 <span class="l-btn-text icon-add l-btn-icon-left">增加大类</span>
                             </span>
                </a>
                <div class="custom-tabs">
                    <div id="tabsMenu" class="tabs-menu flex flex-align-items-center">

                    </div>
                    <div id="tabsContent" class="tabs-content"></div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="/page/js/projectActForm.js"></script>
<script>
    let tabsData = [];
    let canSubmit = true;
    let splitData = null;
    $(function () {
        loadData();
        //tab切换事件
        $("#tabsMenu").on('click', '.tab-menu', function () {
            let code = $(this).attr("code");
            $("#tabsMenu .tab-menu").removeClass("active");
            $(this).addClass("active");
            $(".tab-content").addClass("hide-tab-content");
            $("#" + code).removeClass("hide-tab-content")
        });

        // 预算使用金额输入
        $("#selectTable tbody").on("keyup", "input.shareAmount", function () {
            let reg1 = /^(-?[0-9]\d*)?$/;
            let reg2 = /^(-?\d*\.\d{1,2})?$/;
            let value = $(this).val();
            let maxValue = $(this).attr("maxValue");
            if (value.length != 0 && (reg1.test(value) || reg2.test(value))) {
                if (parseFloat(value) > parseFloat(maxValue)) {
                    tip("使用上限不能大于余额");
                    $(this).val("");
                }
            } else {
                $(this).val("");
            }
            $("#selectTable tfoot .totalShareAmount").text(calcUseTotal());
        });

        //预算删除行
        $("#selectTable").on('click', '.delete-row', function () {
            $(this).parents("tr").remove();
            renderTotal();
        });

        //tab添加按钮
        $("#tabsContent").on('click', '.tab-add-btn', function () {
            let code = $(this).attr("code");
            renderEmptyRow(code, 1);
        });
        //tab导入按钮
        $("#tabsContent").on('click', '.tab-import-btn', function () {
            let code = $(this).attr("code");

        });
        //tab分摊按钮
        $("#tabsContent").on('click', '.tab-split-btn', function () {
            let beginDate = $("#beginDate").val();
            let endDate = $("#endDate").val();
            let code = $(this).attr("code");
            let tbody = $("#" + code).find("table.classify tbody");
            let checked = tbody.find("input[type=checkbox]:checked");
            if (!beginDate || !endDate) {
                tip("请先选择起止时间");
                return;
            }
            if (checked.length === 0) {
                tip("请先选择需要分摊的数据");
                return;
            }
            //计算相差月份
            let startYear = new Date(beginDate.replace(/-/g, "/")).getFullYear();
            let endYear = new Date(endDate.replace(/-/g, "/")).getFullYear();
            let startMonth = new Date(beginDate.replace(/-/g, "/")).getMonth();
            let endMonth = new Date(endDate.replace(/-/g, "/")).getMonth();
            let months = (endYear - startYear) * 12 + (endMonth - startMonth);
            if (months === 0) {
                tip("当前起止时间无法进行分摊");
                return;
            }
            let head = $("#" + code).find("table.classify thead tr").clone();
            let rows = [];
            checked.each(function (index, item) {
                let row = $(this).parents("tr").clone(true);
                rows.push(row)
            });
            splitData = {
                head: head,
                rows: rows,
                months: months,
                beginDate: beginDate,
                startMonth: startMonth
            };
            //分摊预览
            var myOptions = {
                content: 'url:/page/actProjectController/preview',
                lock: true,
                width: 800,
                height: 400,
                title: "预览",
                parent: "projectActForm_",
                opacity: 0.3,
                zIndex: 3006,
                cache: false,
                ok: function () {
                    //生成分摊
                    rows.forEach(function (item, index) {
                        item.attr("splited", 1);
                        item.find("td").eq(0).show();
                        item.find("td").eq(0).find("input[type=checkbox]").prop("checked", false);
                        let length = item.find("td").length;
                        item.find("td").eq(length - 1).show();
                        item.find(".searchIcon").show();
                        item.find("input").removeAttr("disabled");
                        item.find("td").eq(0).find("input[type=checkbox]").attr("disabled", "disabled");
                        for (let i = 0; i < months + 1; i++) {
                            let newDate = new Date(beginDate.replace(/-/g, "/")).setMonth(startMonth + i);
                            let newYear = new Date(newDate).getFullYear();
                            let newMonth = new Date(newDate).getMonth() + 1;
                            newMonth = newMonth[1] ? newMonth : "0" + newMonth;
                            let formate = [newYear, newMonth].join("-");
                            item.find("input[field=actYearMonth]").val(formate);
                            item.find("input[field=actYearMonth]").attr("disabled", "disabled");
                            let rand = item.attr("rand");
                            $("#" + code).find("table.classify tbody").find("tr[rand='" + rand + "']:not([splited])").remove();
                            $("#" + code).find("table.classify tbody").prepend(item.clone(true));
                        }
                    });
                    return true;
                },
                cancelVal: '关闭',
                cancel: true,
                okVal: "确定"
            };
            $.dialog(myOptions);
        });
        //tabs下表格全选
        $("#tabsContent").on('click', '.check-all', function () {
            if ($(this).prop("checked")) {
                $(this).parents("table").find("input[type=checkbox]:not([disabled])").prop("checked", true);
            } else {
                $(this).parents("table").find("input[type=checkbox]:not([disabled])").prop("checked", false);
            }
        });


        //tabs下表格删除行
        $("#tabsContent").on('click', '.delete-row', function () {
            $(this).parents("tr").remove();
        });
        //tab分摊添加行
        $("#tabsContent").on('click', '.tab-share-add-btn', function () {
            let code = $(this).attr("code");
            addShareTableRow(code);
        });
        //modal弹窗选择
        $("#tabsContent").on('click', 'table.classify .searchIcon', function () {
            let field = $(this).attr("field");
            let listener = $(this).parents("td").attr("listener");
            let this_ = this;
            if (field === "terminalCode" || field === "terminalName") {
                var customerCode = '';
                if ($(this_).parents("tr").find("input[field=customerCode]").length > 0) {
                    customerCode = $(this_).parents("tr").find("input[field=customerCode]").val();
                    if (isEmpty(customerCode)) {
                        tip("请选择客户编码");
                        return;
                    }
                }


                modalSelect("/page/tmApiTerminalController/goTerminalListMain?custList=" + customerCode, "选择终端", "terminalList", function (obj) {
                    $(this_).parents("tr").find("input[field=terminalCode]").val(obj.terminalCode);
                    $(this_).parents("tr").find("input[field=terminalName]").val(obj.terminalName);
                    if (listener) {
                        window[listener] && window[listener](this_, obj, "");
                    }
                });
            }
            if (field === "customerCode" || field === "customerName") {
                let budgeCodes = [];
                $("#selectTable tbody tr").each(function () {
                    let budgeCode = $(this).find("td[field=budgetCode]").text();
                    budgeCodes.push(budgeCode)
                });
                modalSelect("/page/tmApiCustomerController/goCustomerListMain?clickFunctionId=${clickFunctionId}&budgetCode=" + budgeCodes.join(","), "选择客户", "customerList", function (obj) {
                    $(this_).parents("tr").find("input[field=customerCode]").val(obj.customerCode);
                    $(this_).parents("tr").find("input[field=customerName]").val(obj.customerName);
                    if (listener) {
                        window[listener] && window[listener](this_, obj, "");
                    }
                });
            }
            if (field === "productCode" || field === "productName") {
                modalSelect("/page/tmApiProductInfoController/goProductInfoListMain?check=true", "选择产品", "productinfoList", function (obj) {
                    $(this_).parents("tr").find("input[field=productCode]").val(obj.productInfoCode);
                    $(this_).parents("tr").find("input[field=productName]").val(obj.productInfoName);
                    $(this_).parents("tr").find("input[field=unit]").val(obj.saleUnitTemp);

                    if (listener) {
                        window[listener] && window[listener](this_, obj, "");
                    }
                });
            }
            if (field === "productPolicyCode" || field === "productPolicyName") {
                modalSelect("/page/payPolicyController/goPayPolicyList", "选择政策", "payPolicyList", function (obj) {
                    $(this_).parents("tr").find("input[field=productPolicyCode]").val(obj.productPolicyCode);
                    $(this_).parents("tr").find("input[field=productPolicyName]").val(obj.productPolicyName);
                    if ($(this_).parents("tr").find("input[field=feeRate]")) {
                        $(this_).parents("tr").find("input[field=feeRate]").val(obj.feeRate);
                    }
                    if (listener) {
                        window[listener] && window[listener](this_, obj, "");
                    }
                });
            }
            //选择组织
            if (field === "orgCode" || field === "orgName") {
                modalSelect("/page/tmApiOrgController/goOrgListMainPage?clickFunctionId=${clickFunctionId}", "选择组织", "orgListMain", function (obj) {
                    $(this_).parents("tr").find("input[field=orgCode]").val(obj.codeText);
                    $(this_).parents("tr").find("input[field=orgName]").val(obj.nameText);
                    if (listener) {
                        window[listener] && window[listener](this_, obj, "");
                    }
                });
            }

            if (field === "actSubclassCode" || field === "actSubclassName") {

                let budgeCodes = [];
                $("#selectTable tbody tr").each(function () {
                    let budgeCode = $(this).find("td[field=budgetCode]").text();
                    budgeCodes.push(budgeCode)
                });
                if (budgeCodes.length === 0) {
                    tip("请先选择预算");
                    return;
                }
                let code = $(this_).parents("div.tab-content").attr("id");
                let url = "/page/ttApiFineController/goApiActFinesByCategMain?hidden=true&categoriesCode=" + code + "&budgetCodes=" + budgeCodes.join(",");
                modalSelect(url, "选择活动细类", "actSubclassList", function (obj) {
                    var startData = $("#beginDate").val();
                    if (isEmpty(startData)) {
                        tip("请选择活动开始时间");
                        return;
                    }
                    $(this_).parents("tr").find("input[field=actSubclassCode]").val(obj.fineCode);
                    $(this_).parents("tr").find("input[field=actSubclassName]").val(obj.fineName);
                    if (listener) {
                        window[listener] && window[listener](this_, obj, "");
                    }
                    if ($(this_).parents("tr").find("select[field=payType]").length > 0 && !isEmpty(obj.fineCode)) {
                        $.ajax({
                            url: "/budget/ttApiCostTypeFineController/checkfindCostTypeCons",
                            type: 'post',
                            data: {"actSubclassCode": obj.fineCode},
                            cache: false,
                            success: function (data) {
                                if (data.success) {
                                    var attributes = data.attributes;
                                    var paytype = attributes.pay_type;
                                    var paytypeObj = $(this_).parents("tr").find("select[field=payType]");
                                    paytypeObj.empty();
                                    if (paytype.length == 1) {
                                        paytypeObj.append('<option value="' + paytype[0].code + '">' + paytype[0].name + '</option>');
                                    } else {
                                        paytypeObj.append("<option value=''>---请选择---</option>");
                                        for (var i = 0; i < paytype.length; i++) {
                                            paytypeObj.append('<option value="' + paytype[i].code + '">' + paytype[i].name + '</option>');
                                        }
                                    }
                                    var yearDateType = $(this_).parents("tr").find("input[field=actYearMonth]");
                                    if (yearDateType.length > 0) {
                                        $(this_).parents("tr").find("input[field=actYearMonth]").val(startData.substr(0, 7));
                                    }
                                }
                            }
                        });
                    }

                    $.ajax({
                        url: "/budget/ttCostTypeController/checkProductByFineCode",
                        type: "post",
                        dataType: "json",
                        data: JSON.stringify([obj.fineCode]),
                        contentType: "application/json",
                        success: function (res) {
                            if (res.success && res.type == 1) {
                                let item = {
                                    categoriesCode: code,
                                    products: []
                                };
                                renderShare(item);
                            }
                        }
                    })

                });
            }

        });

        //大类输入框事件监听
        $("#tabsContent").on('blur', 'table.classify td input:not([type=checkbox]):not([choose=modal])', function () {
            let listener = $(this).parents("td").attr("listener");
            if (listener) {
                window[listener] && window[listener](this, "", "");
            }
        });

        $("#tabsContent").on('change', 'table.classify td select', function () {
            let listener = $(this).parents("td").attr("listener");
            if (listener) {
                window[listener] && window[listener](this, "", "");
            }
        })

        //tab移除大类
        $("#tabsMenu").on('click', '.remove-tab', function (event) {
            event.stopPropagation();
            let code = $(this).parent().attr("code");
            let this_ = this;
            tabsData.forEach(function (item, index) {
                if (item.categoriesCode === code) {
                    tabsData.splice(index, 1);
                    $(this_).parent().remove()
                    $("#" + code).remove();
                    if ($(this_).parent().hasClass("active")) {
                        $("#tabsMenu .tab-menu").eq(0).addClass("active");
                        $("#tabsContent .tab-content").eq(0).removeClass("hide-tab-content");
                    }
                }
            });
        });

        //modal弹窗选择
        $("#tabsContent").on('click', 'table.shareTable .searchIcon', function () {
            let field = $(this).attr("field");
            let this_ = this;
            if (field === "productCode" || field === "productName") {
                modalSelect("/page/tmApiProductInfoController/goProductInfoListMain?check=true", "选择物料", "productinfoList", function (obj) {
                    $(this_).parents("tr").find("input[field=productCode]").val(obj.productInfoCode);
                    $(this_).parents("tr").find("input[field=productName]").val(obj.productInfoName);
                    $(this_).parents("tr").find("input[field=unit]").val(obj.saleUnit);
                });
            }
        });
    });

    //关键指标js开始
    let vm = new Vue({
        el: "#app",
        data: function () {
            return {
                id: "${id}",
                page: "xmhd",
                viewStatus: "${viewStatus}",
                isActiviti: "${isActiviti}"
            }
        },
        methods: {
            handleRefresh: function (target) {
                let this_ = this;
                canSubmit = true;
                let id = $("#actId").val();
                let actCode = $("#actCode").val();
                let actName = $("#actName").val();
                let beginDate = $("#beginDate").val();
                let endDate = $("#endDate").val();
                let remarks = $("#remarks").val();
                let head = {
                    id: id,
                    actCode: actCode,
                    actName: actName,
                    beginDate: beginDate,
                    endDate: endDate,
                    remarks: remarks,
                };
                let budgets = generateBudgeData();
                let categories = generateClassifyData();
                if (canSubmit) {
                    openProgressTop();
                    let postParams = {
                        head: head,
                        budgets: budgets,
                        categories: categories,
                        target: target
                    };
                    $.ajax({
                        url: "/act/actProjectController/refresh",
                        type: "post",
                        dataType: "json",
                        data: JSON.stringify(postParams),
                        contentType: "application/json",
                        complete: function () {
                            closeProgressTop();
                        },
                        success: function (res) {
                            closeProgressTop();
                            if (res.success) {
                                this_.$refs.targetTable.setTargetData(res.obj);
                            } else {
                                tip(res.msg);
                            }
                        },
                        error: function () {
                            closeProgressTop();
                        }
                    })
                }
            },
        }
    });

    //关键指标js结束

    function getSplitData() {
        return splitData;
    }

    //编辑、查看加载数据
    function loadData() {
        let id = '${id}';
        let detail = '${load}' === "detail";
        if (id) {
            $.ajax({
                url: "/act/actProjectController/getActProjectSaveVoByCode?id=" + id,
                type: "post",
                dataType: "json",
                success: function (res) {
                    if (res.success) {
                        $("#actId").val(res.obj.head.id);
                        $("#actCode").val(res.obj.head.actCode);
                        $("#actName").val(res.obj.head.actName);
                        $("#beginDate").val(res.obj.head.beginDate);
                        $("#endDate").val(res.obj.head.endDate);
                        $("#remarks").val(res.obj.head.remarks);
                        renderSelectTable(res.obj.budgets, "edit");
                        tabsData = res.obj.categories;
                        renderTabs();
                        if (detail) {
                            setTimeout(function () {
                                $("#selectBudge_").hide();
                                $("#selectBudgeText_").empty();
                                $("input").attr("disabled", "disabled");
                                $("select").attr("disabled", "disabled");
                                $("textarea").attr("disabled", "disabled");
                                $(".add-classify").css({
                                    display: "none"
                                });
                                $("span.searchIcon").css({
                                    display: "none"
                                });
                                $("a.tab-add-btn").css({
                                    display: "none"
                                });
                                $("a.tab-split-btn").css({
                                    display: "none"
                                });
                                $("a.tab-import-btn").css({
                                    display: "none"
                                });

                                $("a.tab-share-add-btn").css({
                                    display: "none"
                                });
                                $(".search-budge").css({
                                    display: "none"
                                });
                                $(".delete-row").css({
                                    display: "none"
                                });
                                $(".delete-row").parent().css({
                                    display: "none"
                                });
                                $(".remove-tab").css({
                                    display: "none"
                                })
                                $(".operate-col").css({
                                    display: "none"
                                })
                            }, 20)
                        }
                    } else {
                        tip(res.msg);
                    }
                }
            })
        }
    }

    //选择预算
    function selectBudge() {
        var myOptions = {
            content: 'url:/page/ttApiBudgetController/goApiBudgetMain?checkBox=false&tableType=act_project',
            lock: true,
            width: 800,
            height: 500,
            title: "选择预算",
            opacity: 0.3,
            zIndex: 3000,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#ttApibudgetList').datagrid('getSelections');
                if (rowsData.length === 0) {
                    iframe.tip('请选择一条数据');
                    return false;
                }
                if (isExitsFunction("initSelect")&&!initSelect(rowsData,iframe)) {
                    return false;
                }
                renderSelectTable(rowsData, "add");
                return true;
            },
            cancelVal: '关闭',
            cancel: true,
            okVal: "确定"
        };
        $.dialog(myOptions);
    }

    //渲染选择预算表格
    function renderSelectTable(array, type) {
        if (array.length > 0) {
            array.forEach(function (item, index) {
                let html = '';
                let id = type === "add" ? "" : item.id;
                let actCode = item.actCode || "";
                let code = item.budgetCode;
                if ($("#selectTable tbody tr[code='" + code + "']").length === 0) {
                    html += "<tr newId='" + id + "' actCode='" + actCode + "' code='" + code + "'>";
                    html += "<td field='budgetCode'>" + item.budgetCode;
                    html += "</td>";
                    html += "<td field='budgetSubjectsName'>" + item.budgetSubjectsName;
                    html += "</td>";
                    html += "<td field='budgetYear'>" + item.budgetYear;
                    html += "</td>";
                    html += "<td field='budgetMonth'>" + item.budgetMonth;
                    html += "</td>";
                    html += "<td field='productLevelCode' hidden='true'>" + item.productLevelCode;
                    html += "</td>";
                    html += "<td field='productLevelName' hidden='true'>" + item.productLevelName;
                    html += "</td>";
                    html += "<td field='amount'>" + item.amount;
                    html += "</td>";
                    html += "<td field='shareAmount'><input class='table-input shareAmount' maxValue='" + item.amount + "' type='text' value='" + item.shareAmount + "'>";
                    html += "</td>";
                    html += "<td><a href='javascript:void(0)' class='delete-row'>删除</a>";
                    html += "</td>";
                    html += "</tr>";
                    $("#selectTable tbody").append(html);
                }
            });
            renderTotal();
        }

    }

    //渲染预算合计
    function renderTotal() {
        let totalHtml = "";
        totalHtml += "<tr class='total'>";
        totalHtml += "<td colspan='5'>可用余额合计：<span class='totalMoney'>" + calcTotal() + "</span>";
        totalHtml += "</td>";
        totalHtml += "<td colspan='2' style='display: none'>使用金额合计：<span class='totalShareAmount'>" + calcUseTotal() + "</span>";
        totalHtml += "</td>";
        totalHtml += "</tr>";
        $("#selectTable tfoot").html(totalHtml);
    }

    //计算预算合计
    function calcTotal() {
        let total = 0;
        let doms = $("#selectTable tbody").find("tr");
        $.each(doms, function () {
            if ($(this).find("td[field=amount]").length > 0) {
                let amount = $(this).find("td[field=amount]").text() || 0;
                total = ((parseFloat(total) * 1000 + parseFloat(amount) * 1000) / 1000).toFixed(2);
            }
        });
        return total;
    }

    //计算预算使用合计
    function calcUseTotal() {
        let total = 0;
        let doms = $("#selectTable tbody").find("tr");
        $.each(doms, function () {
            if ($(this).find("input.shareAmount").length > 0) {
                let amount = $(this).find("input.shareAmount").val() || 0;
                total = ((parseFloat(total) * 1000 + parseFloat(amount) * 1000) / 1000).toFixed(2);
            }
        });
        return total;
    }


    //选择大类
    function selectClassify() {
        let budgeCodes = [];
        $("#selectTable tbody tr").each(function () {
            let budgeCode = $(this).find("td[field=budgetCode]").text();
            budgeCodes.push(budgeCode)
        });
        if (budgeCodes.length === 0) {
            tip("请先选择预算");
            return;
        }
        var myOptions = {
            content: 'url:/page/actProjectController/chooseType?budgetCodes=' + budgeCodes.join(","),
            lock: true,
            width: 600,
            height: 400,
            title: "选择大类",
            opacity: 0.3,
            zIndex: 3001,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#projectActCostlist').datagrid('getSelections');
                if (rowsData.length === 0) {
                    tip('请选择一条数据');
                    return;
                }
                let codes = [];
                rowsData.forEach(function (item) {
                    codes.push(item.categoriesCode);
                });
                requestClassify(codes);
                return true;
            },
            cancelVal: '关闭',
            cancel: true,
            okVal: "确定"
        };
        $.dialog(myOptions);
    }

    //渲染大类tabs
    function renderTabs() {
        tabsData.forEach(function (item) {
            renderTabMenu(item);
            renderTabContent(item);
        })
    }

    //渲染tab-menu
    function renderTabMenu(item) {
        let tabsHtml = "";
        let code = item.categoriesCode;
        if ($("div.tab-menu[code='" + code + "']").length === 0) {
            if ($("#tabsMenu").find(".tab-menu").length === 0) {
                tabsHtml += "<div code='" + item.categoriesCode + "' class='tab-menu active'>" + item.categoriesName;
            } else {
                tabsHtml += "<div code='" + item.categoriesCode + "' class='tab-menu'>" + item.categoriesName;
            }
            tabsHtml += "<span class='remove-tab fa fa-remove ml10'></span>";
            tabsHtml += "</div>";
            $("#tabsMenu").append(tabsHtml);
        }
    }

    //渲染tab-content
    function renderTabContent(item) {
        let contentHtml = "";
        let code = item.categoriesCode;
        if ($("#" + code).length === 0) {
            if ($("#tabsContent").find(".tab-content").length === 0) {
                contentHtml += '<div id="' + item.categoriesCode + '" class="tab-content">';
            } else {
                contentHtml += '<div id="' + item.categoriesCode + '"  class="tab-content hide-tab-content">';
            }
            contentHtml += '<div class="flex mv10">';
            contentHtml += '<a href="javascript:void(0)" class="easyui-linkbutton l-btn l-btn-plain mr10 tab-add-btn" code="' + item.categoriesCode + '">';
            contentHtml += '<span class="l-btn-left">';
            contentHtml += '<span class="l-btn-text icon-add l-btn-icon-left">新增行</span>';
            contentHtml += '</span>';
            contentHtml += '</a>';
            contentHtml += '<a href="javascript:void(0)" class="easyui-linkbutton l-btn l-btn-plain mr10 tab-import-btn" code="' + item.categoriesCode + '">';
            contentHtml += '<span class="l-btn-left">';
            contentHtml += '<span class="l-btn-text icon-dataIn l-btn-icon-left">导入</span>';
            contentHtml += '</span>';
            contentHtml += '</a>';
            contentHtml += '<a href="javascript:void(0)" class="easyui-linkbutton l-btn l-btn-plain mr10 tab-split-btn" code="' + item.categoriesCode + '">';
            contentHtml += '<span class="l-btn-left">';
            contentHtml += '<span class="l-btn-text icon-divide l-btn-icon-left">分摊</span>';
            contentHtml += '</span>';
            contentHtml += '</a>';
            contentHtml += '</div>';
            contentHtml += '<div class="form-table">';
            contentHtml += renderTabContenTable(item);
            contentHtml += '</div>';
            contentHtml += '</div>';
            $("#tabsContent").append(contentHtml);
            let detail = '${load}' === "detail";
            if (!detail) {
                renderEmptyRow(item.categoriesCode, 5);
            }

            if (item.products && item.products.length > 0) {
                renderShare(item);
            }
        }
    }

    //渲染内容table
    function renderTabContenTable(item) {
        let table = "";
        table += "<table class='classify'>";
        table += "<thead>";
        table += "<tr>";
        table += "<th width='20px'><input type='checkbox' class='check-all'></th>";
        item.extendEntities.forEach(function (head, hIndex) {
            if (head.isShow == 0 || head.isShow == 1) {
                if (head.isShow == 0) {
                    table += "<th class='hidden' width='" + head.wideNum + "px'>" + head.name;
                } else {
                    table += "<th width='" + head.wideNum + "px'>" + head.name;
                }
                table += "</th>"
            }
        });
        table += "<th class='operate-col' width='100px'>操作";
        table += "</th>";
        table += "</tr>";
        table += "</thead>";
        table += "<tbody>";
        if (item.items && item.items.length > 0) {
            item.items.forEach(function (body, bIndex) {
                table += "<tr rand='" + body.groupCode + "' rowId='" + body.id + "' detailCode='" + body.actDetailCode + "'>";
                table += "<td class='text-center'>";
                if (body.groupCode) {
                    table += "<input type='checkbox' disabled class='check-row'>";
                } else {
                    table += "<input type='checkbox' class='check-row'>";
                }
                table += "</td>";
                item.extendEntities.forEach(function (column, cIndex) {
                    let listener = column.endListener || "";
                    if (column.isShow == 0 || column.isShow == 1) {
                        if (column.isShow == 0) {
                            table += "<td class='hidden' listener='" + listener + "' field='" + column.field + "' notEmpty='N'>";
                        } else {
                            table += "<td listener='" + listener + "' field='" + column.field + "' notEmpty='" + column.required + "'>";
                        }
                        let disable = " disabled='disabled' ";
                        let readonly = " readonly='readonly' ";
                        if (column.editable == '1') {
                            disable = '';
                            readonly = '';
                        }
                        if (column.opType === "select") {
                            table += "<select class='table-input' field='" + column.field + "' value='" + body[column.field] + "' " + disable + ">";
                            table += "<option value=''>---请选择---</option>";
                            column.selectVos.forEach(function (option) {
                                if (body[column.field] == option.value) {
                                    table += "<option selected value='" + option.value + "'>" + option.desc
                                } else {
                                    table += "<option value='" + option.value + "'>" + option.desc
                                }
                                table += "</option>";
                            });
                            table += "</select>";
                        }
                        if (column.opType === "choose") {
                            var val = body[column.field];
                            if (val == null) {
                                val = "";
                            }
                            table += "<input type='text' choose='modal' class='table-input' field='" + column.field + "' value='" + val + "' readonly>";
                            if (column.editable == '1') {
                                table += "<span field='" + column.field + "' class='fa fa-search searchIcon'></span>";
                            }
                        }
                        if (column.opType === "text") {
                            var val = body[column.field];
                            if (val == null) {
                                val = "";
                            }
                            table += "<input type='text' class='table-input' field='" + column.field + "' value='" + val + "' " + readonly + ">";
                        }
                        if (column.opType === "dateYearMonth") {
                            var yearMoth_ = body[column.field];
                            if (isEmpty(yearMoth_)) {
                                yearMoth_ = "";
                            }
                            table += "<input type='text' readonly class='table-input Wdate' onfocus='WdatePicker({dateFmt:\"yyyy-MM\"})' field='" + column.field + "' value='" + yearMoth_ + "' " + disable + ">";
                        }
                        table += "</td>"
                    }
                });
                table += "<td><a href='javascript:void(0)' class='delete-row'>删除</a>";
                table += "</td>";
                table += "</tr>"
            });
        }
        table += "</tbody>";
        return table;
    }

    //请求大类
    function requestClassify(codes) {
        $.ajax({
            url: "/budget/ttApiCostTypeCategoriesController/findCategoriesExtendByCode",
            type: "post",
            dataType: "json",
            contentType: "application/json",
            data: JSON.stringify(codes),
            success: function (res) {
                if (res.success) {
                    if (res.objList && res.objList.length > 0) {
                        res.objList.forEach(function (item) {
                            let code = item.categoriesCode;
                            if ($("div.tab-menu[code='" + code + "']").length === 0) {
                                tabsData.push(item);
                            }
                        })
                    }
                    renderTabs();
                } else {
                    tip(res.msg);
                }
            }
        });
    }

    //生成空白表格行
    function renderEmptyRow(code, times) {
        if (!times) times = 1;
        for (let i = 0; i < times; i++) {
            let columns = [];
            tabsData.forEach(function (item) {
                if (item.categoriesCode == code) {
                    columns = item.extendEntities;
                }
            });
            let rand = Math.random();
            let trHtml = "";
            trHtml += "<tr rand='" + rand + "' rowId='' detailCode=''>";
            trHtml += "<td class='text-center'><input type='checkbox' class='check-row'></td>";
            columns.forEach(function (column) {
                let listener = column.endListener || "";
                if (column.isShow == 0 || column.isShow == 1) {
                    if (column.isShow == 0) {
                        trHtml += "<td class='hidden' listener='" + listener + "' field='" + column.field + "' notEmpty='N'>";
                    } else {
                        trHtml += "<td listener='" + listener + "' field='" + column.field + "' notEmpty='" + column.required + "'>";
                    }
                    let disable = " disabled='disabled' ";
                    let readonly = "readonly='readonly'";
                    if (column.editable == '1') {
                        disable = '';
                        readonly = '';
                    }
                    if (column.opType === "select") {
                        trHtml += "<select class='table-input' field='" + column.field + "' value='' " + disable + ">";
                        trHtml += "<option value=''>---请选择---</option>";
                        column.selectVos.forEach(function (option) {
                            trHtml += "<option value='" + option.value + "'>" + option.desc;
                            trHtml += "</option>";
                        });
                        trHtml += "</select>";
                    }
                    if (column.opType === "choose") {
                        trHtml += "<input type='text' choose='modal' class='table-input' field='" + column.field + "' value='' readonly>";
                        if (column.editable == '1') {
                            trHtml += "<span field='" + column.field + "' class='fa fa-search searchIcon'></span>";
                        }
                    }
                    if (column.opType === "text") {
                        trHtml += "<input type='text' class='table-input' field='" + column.field + "' value='' " + readonly + ">";
                    }
                    if (column.opType === "dateYearMonth") {
                        trHtml += "<input type='text' readonly class='table-input Wdate' onfocus='WdatePicker({dateFmt:\"yyyy-MM\"})' field='" + column.field + "' value='' " + disable + ">";
                    }
                    trHtml += "</td>"
                }
            });
            trHtml += "<td><a href='javascript:void(0)' class='delete-row'>删除</a>";
            trHtml += "</td>";
            trHtml += "</tr>";
            $("#" + code).find("table.classify tbody").append(trHtml);
        }
    }

    //构造选择预算的数据
    function generateBudgeData() {
        let params = [];
        let trs = $("#selectTable tbody tr");
        $.each(trs, function () {
            let obj = {};
            obj["id"] = $(this).attr("newId");
            obj["actCode"] = $(this).attr("actCode");
            let tds = $(this).find("td[field]");
            $.each(tds, function (dIndex, td) {
                let key = $(this).attr("field");
                if ($(this).find("input").length > 0) {
                    obj[key] = $(this).find("input").val();
                } else {
                    obj[key] = $(this).text();
                }
            });
            params.push(obj);
        });
        return params;
    }

    //校验整个大类表格数据是否为空
    function checkTableIsEmpty(trs) {
        let isEmpty = true;
        $.each(trs, function () {
            let tds = $(this).find("td[field]");
            $.each(tds, function (dIndex, td) {
                let key = $(this).attr("field");
                let value = "";
                if ($(this).find("input").length > 0) {
                    value = $(this).find("input").val();
                }
                if ($(this).find("select").length > 0) {
                    value = $(this).find("select").val();
                }
                if ($.trim(value)) {
                    isEmpty = false;
                }
            });
        });
        return isEmpty;
    }

    //判断大类表格是否需要校验行
    function isCheckRow(tds) {
        let check = false;
        $.each(tds, function () {
            let value = "";
            if ($(this).find("input").length > 0) {
                value = $(this).find("input").val();
            }
            if ($(this).find("select").length > 0) {
                value = $(this).find("select").val();
            }
            if ($.trim(value)) {
                check = true;
                return false;
            }
        });
        return check;
    }

    //构造大类数据
    function generateClassifyData() {
        let params = [];
        let tabs = $("#tabsMenu").find(".tab-menu");
        $.each(tabs, function (index, item) {
            let tabObj = {};
            let categoriesCode = $(this).attr("code");
            let categoriesName = $(this).text();
            tabObj["categoriesCode"] = categoriesCode;
            tabObj["categoriesName"] = categoriesName;
            let items = [];
            let trs = $("#" + categoriesCode).find("table.classify tbody tr");
            let isEmpty = checkTableIsEmpty(trs);
            if (isEmpty) {
                tip("请先完善" + categoriesName + "数据");
                canSubmit = false;
                return false;
            }
            $.each(trs, function (rIndex) {
                let rowObj = {};
                rowObj["id"] = $(this).attr("rowId");
                rowObj["actDetailCode"] = $(this).attr("detailCode");
                rowObj["splited"] = $(this).attr("splited") == 1;
                rowObj["groupCode"] = $(this).attr("rand");
                let tds = $(this).find("td[field]");
                let isCheck = isCheckRow(tds);
                if (isCheck) {
                    let canPushRow = false;
                    $.each(tds, function (dIndex, td) {
                        let key = $(this).attr("field");
                        let notEmpty = $(this).attr("notEmpty");
                        let value = "";
                        if ($(this).find("input").length > 0) {
                            value = $(this).find("input").val();
                        }
                        if ($(this).find("select").length > 0) {
                            value = $(this).find("select").val();
                        }

                        if (notEmpty === "Y") {
                            if (value) {
                                rowObj[key] = value;
                                canPushRow = true;
                            } else {
                                let tdName = $("#" + categoriesCode).find("table.classify thead th").eq(dIndex + 1).text();
                                tip(categoriesName + "的" + tdName + "为必填字段");
                                canPushRow = false;
                                canSubmit = false;
                                return false;
                            }
                        } else {
                            rowObj[key] = value;
                        }
                    });
                    if (canPushRow) {
                        items.push(rowObj)
                    } else {
                        return false;
                    }
                }
            });
            tabObj["items"] = items;
            let products = [];
            products = generateShareData(categoriesCode);
            tabObj["products"] = products;
            params.push(tabObj);
        });
        return params;
    }

    //大类里面弹窗选择
    function modalSelect(url, title, tableId, cb) {
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: 800,
            height: 400,
            title: title,
            opacity: 0.3,
            zIndex: 3005,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + tableId).datagrid('getSelections');
                if (rowsData.length === 0) {
                    tip('请选择一条数据');
                    return;
                }
                cb(rowsData[0]);
                return true;
            },
            cancelVal: '关闭',
            cancel: true,
            okVal: "确定"
        };
        $.dialog(myOptions);
    }


    //分摊信息内容
    function renderShare(item) {
        let shareHtml = "";
        let code = item.categoriesCode;
        if ($("#" + code).find("table.shareTable").length === 0) {
            shareHtml += '<div class="flex flex-align-items-center mv10">';
            shareHtml += '<span class="mr20">分摊信息</span>';
            shareHtml += '<a href="javascript:void(0)" class="easyui-linkbutton l-btn l-btn-plain mr10 tab-share-add-btn" code="' + item.categoriesCode + '">';
            shareHtml += '<span class="l-btn-left">';
            shareHtml += '<span class="l-btn-text icon-add l-btn-icon-left">新增</span>';
            shareHtml += '</span>';
            shareHtml += '</a>';
            shareHtml += '</div>';
            shareHtml += '<div class="form-table">';
            shareHtml += renderShareTable(item);
            shareHtml += '</div>';
            $("#" + code).append(shareHtml);
        }
    }

    //渲染分摊内容table
    function renderShareTable(item) {
        let table = "";
        table += "<table class='shareTable'>";
        table += "<thead>";
        table += "<tr>";
        table += "<th>物料编码";
        table += "</th>";
        table += "<th>物料名称";
        table += "</th>";
        table += "<th>比例";
        table += "</th>";
        table += "<th>备注";
        table += "</th>";
        table += "<th class='operate-col'>操作";
        table += "</th>";
        table += "</tr>";
        table += "</thead>";
        table += "<tbody>";
        if (item.products && item.products.length > 0) {
            item.products.forEach(function (product, bIndex) {
                table += "<tr rowId='" + product.id + "' detailCode='" + product.actDetailCode + "'>";
                table += "<td field='productCode'>";
                table += "<input type='text' class='table-input' field='productCode' value='" + product.productCode + "'>";
                table += "<span field='productCode' class='fa fa-search searchIcon'></span>";
                table += "</td>";
                table += "<td field='productName'>";
                table += "<input type='text' class='table-input' field='productName' value='" + product.productName + "'>";
                table += "<span field='productName' class='fa fa-search searchIcon'></span>";
                table += "</td>";
                table += "<td field='scale'>";
                table += "<input type='text' class='table-input' field='scale' value='" + product.scale + "'>";
                table += "</td>";
                table += "<td field='remarks'>";
                table += "<input nocheck='true' type='text' class='table-input' field='remarks' value='" + product.remarks + "'>";
                table += "</td>";
                table += "<td><a href='javascript:void(0)' class='delete-row'>删除</a>";
                table += "</td>";
                table += "</tr>"
            });
        }
        table += "</tbody>";
        return table;
    }

    //分摊信息表格新增行
    function addShareTableRow(code) {
        let html = "";
        html += "<tr>";
        html += "<td>";
        html += "<input type='text' class='table-input' field='productCode' value=''>";
        html += "<span field='productCode' class='fa fa-search searchIcon'></span>";
        html += "</td>";
        html += "<td>";
        html += "<input type='text' class='table-input' field='productName' value=''>";
        html += "<span field='productName' class='fa fa-search searchIcon'></span>";
        html += "</td>";
        html += "<td>";
        html += "<input type='text' class='table-input' field='scale' value=''>";
        html += "</td>";
        html += "<td>";
        html += "<input nocheck='true' type='text' class='table-input' field='remarks' value=''>";
        html += "</td>";
        html += "<td>";
        html += "<a href='javascript:void(0)' class='delete-row'>删除</a>";
        html += "</td>";
        html += "</tr>";
        $("#" + code).find("table.shareTable tbody").append(html);
    }

    //校验分摊信息table
    function generateShareData(code) {
        var tableData = [];
        $("#" + code).find("table.shareTable tbody tr").each(function () {
            if (canSubmit) {
                var obj = {};
                $(this).find("td").each(function (index) {
                    if (canSubmit) {
                        $(this).find("input[field]").each(function () {
                            var inputName = $(this).attr("field");
                            obj[inputName] = $(this).val();
                            if (!$(this).val() && $(this).attr("type") !== "hidden" && $(this).attr("nocheck") !== "true") {
                                canSubmit = false;
                                $(this).focus();
                                var name = $("#" + code).find("table.shareTable thead tr th").eq(index).text();
                                tip(name + "不能为空");
                                return false;
                            }
                        })
                    } else {
                        return false;
                    }

                });
                tableData.push(obj);
            } else {
                return false;
            }

        });
        return tableData;
    }

    //提交数据
    function saveData() {
        canSubmit = true;
        let id = $("#actId").val();
        let actCode = $("#actCode").val();
        let actName = $("#actName").val();
        if (actName == "") {
            tip("活动名称必填");
            return false;
        }
        let beginDate = $("#beginDate").val();
        let endDate = $("#endDate").val();
        if (beginDate == "" || endDate == "") {
            tip("起止时间必填");
            return false;
        }
        let remarks = $("#remarks").val();
        let head = {
            id: id,
            actCode: actCode,
            actName: actName,
            beginDate: beginDate,
            endDate: endDate,
            remarks: remarks,
        };
        let target = vm.$refs.targetTable.getTargetData();
        let budgets = generateBudgeData();
        let categories = generateClassifyData();
        if (canSubmit) {
            openProgressTop();
            let postParams = {
                head: head,
                budgets: budgets,
                categories: categories,
                target: target
            };
            if ("${isActiviti}" == "1") {
                $.ajax({
                    url: "/act/actProjectController/refresh",
                    type: "post",
                    dataType: "json",
                    async: false,
                    data: JSON.stringify(postParams),
                    contentType: "application/json",
                    complete: function () {

                    },
                    success: function (res) {
                        if (res.success) {
                            vm.$refs.targetTable.setTargetData(res.obj);
                            postParams.target = vm.$refs.targetTable.getTargetData();
                        } else {
                            tip(res.msg);
                            return;
                        }
                    },
                    error: function () {
                        closeProgressTop();
                    }
                })
            }
            $.ajax({
                url: "/act/actProjectController/saveOrUpdate",
                type: "post",
                dataType: "json",
                data: JSON.stringify(postParams),
                contentType: "application/json",
                complete: function () {
                    closeProgressTop();
                },
                success: function (res) {
                    closeProgressTop();
                    if (res.success) {
                        var api = frameElement.api, W = api.opener;
                        W.tip(res.msg);
                        W.projectlistsearch();
                        api.close();
                    } else {
                        tip(res.msg);
                    }
                },
                error: function () {
                    closeProgressTop();
                }
            })
        }
    }


</script>
</body>
