<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>返利活动</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        #content{
            height: auto!important;
            padding: 0px !important;
        }
        .layout-split-north {
            border-bottom: 1px solid #0072ae00;
        }

        .layout-split-south {
            border-top: 1px solid #ffffff;
        }
        #actName{
            width: 100%!important;
        }
        .form-group{
            padding: 0px;
        }
    </style>
</head>

<body class="easyui-layout" fit="true" id="globallayout">
<div data-options="region:'north',split:true" style="height:200px;">
    <t:formvalid action="/act/ttActRebateController/saveOrUpdate" layout="div"
                 dialog="true" formid="detailId">
        <t:dgFormList layoutStyle="horizontal" tagConf="${clickFunctionId}" expandParam="${clickFunctionId}">
            <t:dgFormColumn field="id" hidden="true" formClass="biz-col-33 mb5 form" labelName="id" optionType="input" required="false"
                            defaultVal="${vo.id }"/>
            <t:dgFormColumn field="categoriesCode" hidden="true" defaultVal="${categoriesCode}" formClass="biz-col-33 mb5 form" labelName="categoriesCode" optionType="input" required="false"/>
            <t:dgFormColumn field="budgetCode" hidden="true" defaultVal="${budgetCode}" formClass="biz-col-33 mb5 form" labelName="budgetCode" optionType="input" required="false"/>
            <t:dgFormColumn field="actBeginDate" hidden="true" defaultVal="${actBeginDate}" formClass="biz-col-33 mb5 form" labelName="actBeginDate" optionType="input" required="false"/>
            <t:dgFormColumn field="actSubclassName" hidden="false" formClass="biz-col-33 mb5 form" labelName="活动细类" optionType="choseDialog" required="true"
                            onclick="selectActSubClass()" defaultVal="${vo.actSubclassName}" dataType="*" />
            <t:dgFormColumn field="actSubclassCode"  formClass="biz-col-33 mb5 form" labelName="活动细类编码" optionType="input" hidden="true" required="false"
                            defaultVal="${vo.actSubclassCode}" />
            <t:dgFormColumn field="isMultipleAudit"  formClass="biz-col-33 mb5 form" labelName="是否允许多次核销" optionType="input" hidden="true" required="false"
                            defaultVal="${vo.isMultipleAudit}" />
            <t:dgFormColumn field="customerName" hidden="false" formClass="biz-col-33 mb5 form" labelName="客户名称" optionType="choseDialog" required="true"
                            onclick="selectCustomer()" defaultVal="${vo.customerName}"/>
            <t:dgFormColumn field="customerCode" hidden="true" formClass="biz-col-33 mb5 form" labelName="客户编码" optionType="input" required="true"
                            defaultVal="${vo.customerCode}"/>
            <t:dgFormColumn field="payType" hidden="false" formClass="biz-col-33 mb5 form" labelName="支付方式" optionType="select" required="true"
                            defaultVal="${vo.payType }"  formTags="${formTags}" dataType="*"/>
            <t:dgFormColumn field="remarks" hidden="false" formClass="biz-col-100 form " labelName="备注" optionType="textarea"
                            required="false"
                            rows="3" cols="5" defaultVal="${vo.remarks}" style="width: 100%; height: 53px;"/>
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">

    <t:datagrid name="rebateDetailList" checkbox="true" fitColumns="false" idField="id" fit="true" singleSelect="false"
                queryMode="group"
                actionUrl=""
                pagination="false" autoLoadData="false"
    >
        <t:dgCol title="id" field="id" hidden="true"/>
        <t:dgCol title="政策编码" field="policyCode"  sortable="false"  width="100"/>
        <t:dgCol title="政策名称" field="policyName" sortable="false" width="300"/>
        <t:dgCol title="费率" field="feeRate" sortable="false" hidden="true" width="300"/>
        <t:dgCol title="预估销售额" field="forecastSalesAmount" sortable="false" width="100" editor="{type:'numberbox',options:{min:0,value:'',missingMessage:'预估销售额必填',required:'true'}}"/>
        <t:dgCol title="申请费用金额" field="amount" sortable="false" width="100"/>
        <t:dgToolBar title="选择适用政策" detail="false" funname="selectPolicy" icon="icon-add"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="删除" detail="false" funname="delProductDetail" icon="icon-remove"
                     url=""></t:dgToolBar>
    </t:datagrid>
</div>
</body>
</html>

<script type="text/javascript">

    $('#rebateDetailList').datagrid({
        onDblClickCell: function(index,field,value){
            if(field=="forecastSalesAmount"){
                initEditor(index);
            }else{
                endEidtProductDetail();
                forecastSalesNumblurAll();
            }

        }
    });

    function getPaData() {
        //编辑状态 初始化数据
        var api = frameElement.api, W = api.opener;
        var rows = W.getSelectRows();
        return rows;
    }

    $(function () {
        var edit = '${edit}';
        if(edit=="0"){

            var rows = getPaData();
            $("#actSubclassName").val(rows[0].actSubclassName);
            $("#actSubclassCode").val(rows[0].actSubclassCode);
            $("#isMultipleAudit").val(rows[0].isMultipleAudit);
            $("#customerName").val(rows[0].customerName);
            $("#customerCode").val(rows[0].customerCode);
            $("#remarks").val(rows[0].remarks);
            $("#payType").val(rows[0].payType);

            $('#rebateDetailList').datagrid('insertRow',{
                index: 0,
                row: {
                    id:rows[0].id,
                    policyCode: rows[0].policyCode,
                    policyName: rows[0].policyName,
                    feeRate:rows[0].feeRate,
                    forecastSalesAmount:rows[0].forecastSalesAmount,
                    amount:rows[0].amount
                }
            });
        }
    })

    //初始化编辑
    function initEditor(index) {
        $("#rebateDetailList").datagrid('beginEdit',index);
        var forecastSalesNumEd = $('#rebateDetailList').datagrid('getEditor', {index:index,field:'forecastSalesAmount'});
        forecastSalesNumEd.target.numberbox({
            onChange:function(newValue,oldValue){
                forecastSalesNumblur(index,newValue);
            }
        })
    }

    function forecastSalesNumblur(index,newValue) {
        if(isEmpty(newValue)){
            return;
        }
        endEidtProductDetail();
        forecastSalesNumblurAll();
    }

    function forecastSalesNumblurAll() {
        var rows = $('#rebateDetailList').datagrid('getRows');
        for(var i=0;i<rows.length;i++){
            var index = i;
            var rows = $('#rebateDetailList').datagrid('getRows');
            var row = rows[index];
            //预估销售额
            var forecastSalesAmount = row.forecastSalesAmount;
            //费率
            var feeRate = row.feeRate;
            $('#rebateDetailList').datagrid('endEdit' ,index);
            if (!isEmpty(forecastSalesAmount) && !isEmpty(feeRate)) {
                //申请费用金额=预估销售额*费率
                var amount = numMulti(forecastSalesAmount,numDiv(feeRate,100));
                $('#rebateDetailList').datagrid('updateRow',{
                    index: index,
                    row: {
                        amount:amount,
                        forecastSalesAmount:forecastSalesAmount,
                        feeRate:feeRate
                    }
                });
            }
        }
        editorAll();
    }

    /* 结束编辑 */
    function endEidtProductDetail() {
        var submitData = true;
        var productDetailRows = $('#rebateDetailList').datagrid('getRows');
        for(var i=0;i<productDetailRows.length;i++){
            var index = $('#rebateDetailList').datagrid('getRowIndex',productDetailRows[i]);
            if (!$("#rebateDetailList").datagrid("validateRow",index)) {
                tip("请填写必填项");
                submitData = false;
                return false;
            }
            $('#rebateDetailList').datagrid('endEdit' ,index);
        }
        return submitData;
    }

    function editorAll() {
        var productDetailRows = $('#rebateDetailList').datagrid('getRows');
        for(var i=0;i<productDetailRows.length;i++){
            var index = $('#rebateDetailList').datagrid('getRowIndex',productDetailRows[i]);
            initEditor(index);
        }
    }

    //删除产品
    function delProductDetail() {
        var rowsData = $('#rebateDetailList').datagrid('getSelections');
        if (rowsData.length==0 ) {
            tip("请至少选择一条数据");
        }else{
            for(var i=rowsData.length-1;i>=0;i--){
                var index = $("#rebateDetailList").datagrid("getRowIndex",rowsData[i]);
                $("#rebateDetailList").datagrid("deleteRow",index);
            }
        }
    }

    function createData() {

        var data = {};
        //促销类型
        var actSubclassName = $('#actSubclassName').val();
        if (actSubclassName == "") {
            tip("请选择活动细类");
            return false;
        }
        var actSubclassCode = $('#actSubclassCode').val();
        var isMultipleAudit = $("#isMultipleAudit").val();
        var customerCode = $('#customerCode').val();
        var customerName = $('#customerName').val();
        if (customerName == "") {
            tip("请选择客户");
            return false;
        }
        var payType = $('select[name=payType]').val();
        if (payType == "") {
            tip("请选择支付方式");
            return false;
        }
        var head = {};
        head.actSubclassName = actSubclassName;
        head.actSubclassCode = actSubclassCode;
        head.isMultipleAudit = isMultipleAudit;
        head.customerCode = customerCode;
        head.customerName = customerName;
        head.payType = payType;
        var productDetailRows = createDetail();
        data.head = head;
        data.productDetailRows = productDetailRows;
        return data;
    }

    /**
     * 创建明细
     * @returns {*|jQuery}
     */
    function createDetail() {
        var submitData = false;
        submitData = endEidtProductDetail();
        if (submitData) {
            var productDetailRows = $('#rebateDetailList').datagrid('getRows');
            return productDetailRows;
        }else{
            return [];
        }
    }

    var id = '${vo.id}';
    if (id != "") {
        var actSubclassCode = '${vo.actSubclassCode}';
        checkAndDeal(actSubclassCode);
    }

    function selectActSubClass(){
        var tableType = "act_rebate";
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        url = "/page/ttApiFineController/goApiActFineMain?tableType="+tableType+"&categoriesCode="+categoriesCode+"&budgetCode="+budgetCode;
        width = 1000;
        height = 450;
        id = "actSubclassList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData.length == 0) {
                    iframe.tip("请至少选择一条数据");
                    return false;
                } else {
                    var myobj=eval(rowsData);
                    $("#actSubclassCode").val(myobj[0].fineCode);
                    $("#actSubclassName").val(myobj[0].fineName);
                    $("#isMultipleAudit").val(myobj[0].isMultipleAudit);
                    $("#actSubclassName").focus();
                    //请求活动需求控制
                    checkAndDeal(myobj[0].fineCode);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    //请求校验是控制类数据 ：如是否到客户到产品
    //判断 逻辑如下  ： 如果到 终端 那么 客户+终端 必填  如果到 客户 那么 客户必填 终端 可不填
    function checkAndDeal(actSubclassCode){
        if (actSubclassCode ==null ||actSubclassCode ==undefined ||actSubclassCode==""){
            tip("活动细类为空！");
            return ;
        }
        $.ajax({
            url : "/budget/ttApiCostTypeFineController/checkfindCostTypeCons",
            type : 'post',
            data : {"actSubclassCode":actSubclassCode},
            cache : false,
            success : function(data) {
                if (data.success) {
                    var payTypeDefault = $("#payType").val();
                    var attributes =data.attributes;
                    var paytype = attributes.pay_type;
                    $("#payType").empty();
                    if (paytype.length == 1) {
                        $("#payType").append('<option value="'+paytype[0].code+'">'+paytype[0].name+'</option>');
                    }else{
                        $("#payType").append("<option value=''>请选择--请选择--</option>");
                        for(var i=0;i<paytype.length;i++){
                            $("#payType").append('<option value="'+paytype[i].code+'">'+paytype[i].name+'</option>');
                        }
                    }
                }else{
                    tip(data.msg);
                }
            }
        });
    }

    //选择客户
    function selectCustomer(){
        triggerId = "customerCode";
        triggerName = "customerName";
        var budgetCode = $("#budgetCode").val();
        url = "/page/tmApiCustomerController/goActCustomerListMain?budgetCode="+budgetCode+"&clickFunctionId=${clickFunctionId}";
        width = 1000;
        height = 450;
        id = "customerList";
        gridname = id;
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: width,
            height: height,
            title: '新增',
            opacity: 0.3,
            zIndex:2600,
            parent:'addCustomerDialog',
            id:'addCustomerDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        var myobj=eval(rowsData);
                        $("#customerCode").val(myobj[0].customerCode);
                        $("#customerName").val(myobj[0].customerName);
                        $("#customerName").focus();
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    //选择政策
    function selectPolicy() {
        var actBeginDate = $("#actBeginDate").val();
        var addurl = "/page/payPolicyController/goPayPolicyList?check=false&actBeginDate="+actBeginDate;
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 900,
            height: 500,
            title: '新增',
            opacity: 0.3,
            zIndex: 2600,
            parent: 'selectPolicyDialog',
            id: 'selectPolicyDialog',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#payPolicyList').datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        for(var i=0;i<rowsData.length;i++){
                            $('#rebateDetailList').datagrid('insertRow',{
                                index: 0,
                                row: {
                                    id:generateUUID(),
                                    policyCode: rowsData[i].productPolicyCode,
                                    policyName: rowsData[i].productPolicyName,
                                    feeRate:rowsData[i].feeRate
                                }
                            });
                        }
                        editorAll();
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    /**
     * 乘法运算，避免数据相乘小数点后产生多位数和计算精度损失。
     *
     * @param num1被乘数 | num2乘数
     */
    function numMulti(num1, num2) {
        var baseNum = 0;
        try {
            baseNum += num1.toString().split(".")[1].length;
        } catch (e) {
        }
        try {
            baseNum += num2.toString().split(".")[1].length;
        } catch (e) {
        }
        return Number(num1.toString().replace(".", "")) * Number(num2.toString().replace(".", "")) / Math.pow(10, baseNum);
    };

    /**
     * 除法运算，避免数据相除小数点后产生多位数和计算精度损失。
     *
     * @param num1被除数 | num2除数
     */
    function numDiv(num1, num2) {
        var baseNum1 = 0, baseNum2 = 0;
        var baseNum3, baseNum4;
        var baseNum5;
        try {
            baseNum1 = num1.toString().split(".")[1].length;
        } catch (e) {
            baseNum1 = 0;
        }
        try {
            baseNum2 = num2.toString().split(".")[1].length;
        } catch (e) {
            baseNum2 = 0;
        }
        with (Math) {
            baseNum3 = Number(num1.toString().replace(".", ""));
            baseNum4 = Number(num2.toString().replace(".", ""));
            baseNum5 = (baseNum3 / baseNum4) * pow(10, baseNum2 - baseNum1);
            return baseNum5;
        }
    };

    function deleteALLSelectSelf(title, url, gname, deleteCallback) {
        gridname = gname;
        var ids = [];
        var rows = $("#RebateDetailList").datagrid('getSelections');
        if (rows.length > 0) {
            getSafeJq().dialog.confirm("你确定永久删除该数据吗?", function (r) {
                if (r) {
                    for (var i = 0; i < rows.length; i++) {
                        ids.push(rows[i].id);
                    }
                    $.ajax({
                        url: url,
                        type: 'post',
                        dataType: 'json',
                        data: {
                            ids: ids.join(',')
                        },
                        cache: false,
                        success: function (data) {
                            var msg = data.msg;
                            if (data.success) {
                                ids = '';
                                for (var i = rows.length - 1; i >= 0; i--) {
                                    var index = $("#RebateDetailList").datagrid("getRowIndex", rows[i]);
                                    $("#RebateDetailList").datagrid("deleteRow", index);
                                }
                            } else {
                                tip(msg, 'error');

                            }
                        },
                        error: function () {
                            tip("客户端请求错误", 'error');
                            return false;
                        }
                    });
                }
            });
        } else {
            tip("请选择需要删除的数据");
        }
    }
    var tempId = "";
    function detailExcel() {
        tempId = generateUUID();

        <c:if test="${not empty importUploadUrl}">
        var data = ${importUploadUrl};
        data.strExtend1 = tempId;
        importExcel(data,impot)
        </c:if>
    }

    function impot() {
        $.ajax({
            url: "/act/ttActRebateController/findExcelDetail",
            type: "post",
            dataType: "json",
            data: "tempId="+tempId,
            success: function (res) {
                if(res.success){
                    tempId = generateUUID();
                    var list = res.objList;
                    if(list&&list.length>0){
                        for(var i=0;i<list.length;i++){
                            $('#RebateDetailList').datagrid('insertRow', {
                                index: 0,
                                row: list[i]
                            });
                        }
                    }
                }else{
                    tip(res.msg);
                }
            }
        });
    }

</script>

