<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>费用预算拓展</title>
    <t:base type="jquery,easyui,tools"></t:base>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid action="/budget/ttSpecialAreaController/saveOrUpdate" layout="div" dialog="true"
             beforeSubmit="sumDate" formid="budgetExtendForm">
    <t:dgFormList expandParam="${clickFunctionId}" tagConf="${clickFunctionId}">
        <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                        defaultVal="${vo.id }"/>
        <t:dgFormColumn field="extChar1" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar1"
                        optionType="input" required="false"
                        defaultVal="${vo.extChar1 }"/>
        <t:dgFormColumn field="extChar2" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar2"
                        optionType="input" required="false"
                        defaultVal="${vo.extChar2 }"/>
        <t:dgFormColumn field="extChar3" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar3"
                        optionType="input" required="false"
                        defaultVal="${vo.extChar3 }"/>
        <t:dgFormColumn field="extChar4" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar4"
                        optionType="input" required="false"
                        defaultVal="${vo.extChar4 }"/>
        <t:dgFormColumn field="extChar5" hidden="true" formClass="biz-col-50 mb5 form" labelName="extChar5"
                        optionType="input" required="false"
                        defaultVal="${vo.extChar5 }"/>
        <t:dgFormColumn field="code" hidden="true" formClass="form" labelName="编号" optionType="input"
                        required="false" defaultVal="${vo.code}" readOnly="true"/>
        <t:dgFormColumn field="name" hidden="true" formClass="form" labelName="名称" optionType="input"
                        required="true" defaultVal="${vo.name}"/>
        <t:dgFormColumn field="type" hidden="true" typeGroupCode="special_type" formClass="form"
                        defaultVal="${vo.type}"
                        labelName="类型" optionType="select" required="false"/>
        <t:dgFormColumn field="typeName" hidden="true" formClass="form" labelName="类型名称" optionType="input"
                        required="false" defaultVal="${vo.typeName}"/>
        <t:dgFormColumn field="enableStatus" hidden="true" typeGroupCode="enable_status" formClass="form"
                        defaultVal="${vo.enableStatus}"
                        labelName="状态" optionType="select" required="false"/>

        <t:dgFormColumn field="extendJson" hidden="true" formClass="form" labelName="扩展属性json" optionType="input"
                        required="false"/>
        <t:dgFormColumn field="orgCodeJson" hidden="true" formClass="form" labelName="组织json" optionType="input"
                        required="false"/>
        <t:dgFormColumn field="orgCodes" hidden="true" formClass="form" labelName="可选组织" optionType="tags"
                        required="false"
                        formTags="${vo.orgCodeFormTags}" onclick="goOrgCode();"/>
        <t:dgFormColumn field="orgTypeJson" hidden="true" formClass="form" labelName="可选组织类型json" optionType="input"
                        required="false"/>
        <t:dgFormColumn field="orgTypes" hidden="true" formClass="form" labelName="可选组织类型" optionType="tags"
                        required="false" formTags="${vo.orgTypeFormTags}" onclick="goOrgType();"/>

        <t:dgFormColumn field="notes" hidden="true" formClass="form"
                        defaultVal="${vo.notes}"
                        labelName="备注" optionType="textarea" rows="5" cols="500" required="false"/>
    </t:dgFormList>
</t:formvalid>
</body>
<script type="text/javascript">
    $(function () {
        $("#orgCodes").on('click', '.biz-tag-close', function () {
            $(this).parent().remove();
        });
        $("#orgTypes").on('click', '.biz-tag-close', function () {
            $(this).parent().remove();
        });
    });

    /**
     * 初始化扩展字段
     */
    function initData() {
        var rowsDetailDatas = $('#extendList').datagrid('getRows');
        if (rowsDetailDatas.length == 0) {
            $('#extendList').datagrid('insertRow', {
                index: 0,
                row: {
                    id: generateUUID(),
                    field: 'extChar5',
                    name: '扩展字段5',
                    required: 'N',
                    orderNum: '26',
                    isShow: '0',
                    editable: '1',
                    endListener: '',
                    opType: 'text',
                    wideNum: '130'
                }
            });
            $('#extendList').datagrid('insertRow', {
                index: 0,
                row: {
                    id: generateUUID(),
                    field: 'extChar4',
                    name: '扩展字段4',
                    required: 'N',
                    orderNum: '25',
                    isShow: '0',
                    editable: '1',
                    endListener: '',
                    opType: 'text',
                    wideNum: '130'
                }
            });
            $('#extendList').datagrid('insertRow', {
                index: 0,
                row: {
                    id: generateUUID(),
                    field: 'extChar3',
                    name: '扩展字段3',
                    required: 'N',
                    orderNum: '24',
                    isShow: '0',
                    editable: '1',
                    endListener: '',
                    opType: 'text',
                    wideNum: '130'
                }
            });
            $('#extendList').datagrid('insertRow', {
                index: 0,
                row: {
                    id: generateUUID(),
                    field: 'extChar2',
                    name: '扩展字段2',
                    required: 'N',
                    orderNum: '23',
                    isShow: '0',
                    editable: '1',
                    endListener: '',
                    opType: 'text',
                    wideNum: '130'
                }
            });
            $('#extendList').datagrid('insertRow', {
                index: 0,
                row: {
                    id: generateUUID(),
                    field: 'extChar1',
                    name: '扩展字段1',
                    required: 'N',
                    orderNum: '22',
                    isShow: '0',
                    editable: '1',
                    endListener: '',
                    opType: 'text',
                    wideNum: '130'
                }
            });
            $('#extendList').datagrid('insertRow', {
                index: 0,
                row: {
                    id: generateUUID(),
                    field: 'orgName',
                    name: '组织名称',
                    required: 'N',
                    orderNum: '17',
                    isShow: '0',
                    editable: '1',
                    endListener: '',
                    opType: 'choose',
                    wideNum: '130'
                }
            });
            $('#extendList').datagrid('insertRow', {
                index: 0,
                row: {
                    id: generateUUID(),
                    field: 'orgCode',
                    name: '组织编码',
                    required: 'N',
                    orderNum: '16',
                    isShow: '0',
                    editable: '1',
                    endListener: '',
                    opType: 'choose',
                    wideNum: '130'
                }
            });
        }
    }

    /** 选择组织 */
    function goOrgCode(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "budgetDepartCode";
        triggerName = "budgetDepartName";
        url = "/page/tmApiOrgController/goOrgListMain?singleSelect=false";
        width = 1000;
        height = 450;
        id = "orgList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).treegrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj = eval(rowsData);
                    var tagArray = [];
                    $(myobj).each(function (index, item) {
                        var tag = {};
                        tag["name"] = item.src;
                        tag["code"] = item.text;
                        tagArray.push(tag);
                    });

                    renderTag("orgCodes", tagArray);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /** 选择组织类型 */
    function goOrgType(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        url = "/page/tmApiOrgController/goOrgTypeListMain?singleSelect=false";
        width = 500;
        height = 450;
        id = "orgTypeList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj = eval(rowsData);
                    var tagArray = [];
                    $(myobj).each(function (index, item) {
                        var tag = {};
                        tag["name"] = item.dictValue;
                        tag["code"] = item.dictCode;
                        tagArray.push(tag);
                    });

                    renderTag("orgTypes", tagArray);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /** 汇总活动细类id,可选组织数据，字段扩展信息 */
    function sumDate() {
        var orgCodeTags = getTags("orgCodes");
        $("#orgCodeJson").val(JSON.stringify(orgCodeTags));

        var orgTypeTags = getTags("orgTypes");
        $("#orgTypeJson").val(JSON.stringify(orgTypeTags));
        return true;
    }
</script>
</html>