<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="advance_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="advanceList" tagConf="${clickFunctionId}" controllerTarget="ttActAdvanceController" methedTarget="findTtActAdvancePage"  idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/pay/ttActAdvanceController/findTtActAdvancePage?clickFunctionId=${clickFunctionId}" pagination="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="扩展字段1" field="extChar1"  hidden="true" ></t:dgCol>
            <t:dgCol title="扩展字段2" field="extChar2"  hidden="true" ></t:dgCol>
            <t:dgCol title="扩展字段3" field="extChar3"  hidden="true" ></t:dgCol>
            <t:dgCol title="扩展字段4" field="extChar4"  hidden="true" ></t:dgCol>
            <t:dgCol title="扩展字段5" field="extChar5"  hidden="true" ></t:dgCol>
            <t:dgCol title="审批状态" field="bpmStatus" dictionary="bpm_status"  query="true"></t:dgCol>
            <t:dgCol title="流程编号" field="processKey" ></t:dgCol>
            <t:dgCol title="预付编号" field="advanceCode" query="true"></t:dgCol>
            <t:dgCol title="活动总单编号" field="actCode" ></t:dgCol>
            <t:dgCol title="活动名称" field="actName" query="true" ></t:dgCol>
            <t:dgCol title="活动申请金额" field="applyPrice" ></t:dgCol>
            <t:dgCol title="预付金额" field="advancePrice"></t:dgCol>
            <t:dgCol title="提交人" field="createName" ></t:dgCol>
            <t:dgCol title="提交时间" field="createDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>

            <t:dgToolBar operationCode="add" title="新增" icon="icon-add" width="900" height="500" url="/page/ttActAdvanceController/goSaveOrUpdateTtActAdvance?clickFunctionId=${clickFunctionId}"
                         funname="add"></t:dgToolBar>
            <t:dgToolBar operationCode="edit" title="编辑" icon="icon-edit" width="900" height="500" url="/page/ttActAdvanceController/goSaveOrUpdateTtActAdvance?clickFunctionId=${clickFunctionId}"
                         funname="update"></t:dgToolBar>
            <t:dgToolBar operationCode="look" title="查看" icon="icon-edit" width="900" height="500" url="/page/ttActAdvanceController/goSaveOrUpdateTtActAdvance?clickFunctionId=${clickFunctionId}"
                         funname="detail"></t:dgToolBar>
            <t:dgToolBar operationCode="remove" title="删除" icon="icon-remove" url="/pay/ttActAdvanceController/deleteTtActAdvance"
                         funname="deleteALLSelect"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut"
                         url="/pay/commonExcelController/excel" excelName="活动预付" excelSheetName="活动预付" funname="excelCommonExport"></t:dgToolBar>
            <t:dgToolBar title="提交流程" operationCode="commit" icon="icon-edit" width="1400" height="600" url=""
                         funname="commit"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="/page/knlLogController/goShowLog"
                         width="1000" height="500"     funname="detail"></t:dgToolBar>
            <t:dgToolBar operationCode="bpmLog" title="流程日志" icon="icon-log" url="/page/knlLogController/goAuditTaskLogs"
                         width="1000" height="500"     funname="detail"></t:dgToolBar>
            <t:dgToolBar title="个性设置" operationCode="style" icon="icon-add" url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>

        </t:datagrid>
    </div>
</div>
<script>
    var pageCode = "hdyf";
    /**提交工作流页面**/
    function commit(width,height) {
        var rowsDatas = $('#advanceList').datagrid('getSelections');
        if(rowsDatas.length!=1){
            tip("请选择一条数据操作");
            return;
        }
        if(rowsDatas[0].bpmStatus=='2'||rowsDatas[0].bpmStatus=='3'){
            tip("该条数据不能再次提交审批");
            return;
        }
        commitSub(width,height,pageCode);
    }
    /**执行提交**/
    function docommit(data){
        openProgressTop("正在提交.......");
        var rowsDatas = $('#advanceList').datagrid('getSelections');
        //封装参数
        data.businessObjId = rowsDatas[0].id;
        $.ajax({
            type: "POST",
            url: "/pay/ttActAdvanceController/subActiviti",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            success: function(data){
                if(data.success){
                    $.dialog({id: "activitiSubId"}).close();
                    advanceListsearch();
                    tip(data.msg);
                }else{
                    $.dialog({id: "activitiSubId"}).content.tip(data.msg);
                }
            },
            complete:function () {
                closeProgressTop();
            }
        });
    }
</script>