<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <t:base type="jquery,easyui,tools,DatePicker"></t:base>
    <title>核销资料</title>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
            background-color: rgb(243, 243, 243);
            text-align: left;
        }

        table tr {
            border: 1px solid #ccc;
        }

        table tr th {
            border: 0;
            font-size: 14px;
            font-weight: bold;
            padding: 10px 10px;
        }

        table tr td {
            border: 0;
            font-size: 12px;
            padding: 10px 10px;
        }

        table tr td span {
            padding-left: 20px;
        }

        .delete {
            padding: 0 4px;
            cursor: pointer;
        }

        .title {
            line-height: 30px;
            font-size: 14px;
            font-weight: bold;
            background-color: white;
        }

        .upload {
            display: flex;
        }

        .upload .flex-none {
            display: flex;
        }

        .upload .flex-auto ul {
            display: flex;
            flex-direction: column;
        }

        .upload .flex-auto ul li {
            margin-top: 4px;
        }
    </style>
<body>
<t:formvalid formid="formobj" layout="div" dialog="true" refresh="true"
             action="/pay/ttAuditActDetailController/saveOrUpdateDetailUpload">

    <input name="actSubclassName" id="actSubclassName" hidden="true" value="${vo.fineName}">
    <input name="actSubclassCode" id="actSubclassCode" hidden="hidden" value="${vo.fineCode}">
    <input name="tempUuid" id="tempUuid" hidden="hidden" value="${tempUuid}">
    <input name="actDetailCode" id="actDetailCode" hidden="hidden" value="${actDetailCode}">


    <table
            frame="void"
            border="1"
            cellspacing="0"
            border="1"
    >
        <thead>
        <tr>
            <th>活动细类</th>
            <th>核销资料</th>
            <th>描述</th>
            <th>示例</th>
        </tr>
        </thead>

        <c:forEach items="${vo.auditInfoEntitys}" var="ss">
            <tr>
                <td>${vo.fineName}</td>
                <td>${ss.name}</td>
                <td>${ss.auditInfoDesc}</td>
                <td><a href="#">查看</a></td>
            </tr>
        </c:forEach>
        <tr>
            <td colspan="4" class="title">核销资料上传</td>
        </tr>
        <tbody class="dataItem">
        <c:forEach items="${vo.auditInfoUploads}" var="ss">
            <tr>
                <td>${vo.fineName}</td>
                <td>${ss.name}</td>
                <td class="upload">
                    <div style="display: flex;flex-direction: row">
                        <input id="${ss.code}" name="${ss.code}" type="hidden"/>
                        <c:if test="${!\"lookdetail\".equals(lookdetail)}">
                            <div class="flex-none">
                                <a href="javascript:;" class="easyui-linkbutton" plain="true" id="btn_sub"
                                   iconCls="icon-search"
                                   onclick="upload('${ss.code}', 'attachList${ss.code}')">上传文件</a>
                            </div>
                        </c:if>
                        <div class="flex-auto">---${ss.budgetAttachmentEntitys.size()}---
                            <ul id="attachList${ss.code}" name="attachList" class="attach-list flex flex-wrap">
                                    <c:forEach items="${ss.budgetAttachmentEntitys}" var="cc">
                                        <li class="attach-list-item" fileName='${cc.fileName}'>
                                        <a class="attach-name" code='${ss.code}' realPath='${cc.realPath}' imgId='${cc.id}'
                                           href='javascript:void(0);' href_='${cc.urlPath}'>${cc.fileName}</a>
                                        <c:if test="${!\"lookdetail\".equals(lookdetail)}"><span class="attach-remove fa fa-close" ></span></c:if>
                                            <%--<span class="attach-remove fa fa-close" ></span>--%>
                                        </li>
                                    </c:forEach>
                            </ul>
                        </div>
                    </div>
                </td>
            </tr>
        </c:forEach>
        </tbody>
    </table>
</t:formvalid>
</body>
<script type="text/javascript">
    var tmp=new Object();
    //上传方法
    function upload(formData, attachList) {
        var url = "/upload/uploadController/uploadFileold?1=1";
        importAttach_({uploadUrl: url, muilt: false}, function (res,tanc) {
            if (res != undefined) {
                for (var i = 0; i < res.length; i++) {
                    var obj = res[i];
                    if (obj.success) {
                        if (checkReapt(attachList,obj.obj[0].fileName)) {
                            tip("不能重复上传！");
                        } else {
                            var appstr=getAppendStr(obj.obj[0],formData);
                            $("#"+attachList).append(appstr);
                        }
                    }
                }
                $(tanc.iframe).remove();
            }

        },"uploaddetailid_");
    }

    //上传附件
    function importAttach_(options, cb,parentId) {
        console.log(windowapi);
        var importOption = {
            content: "url:/importController.do?importAttach",
            lock: true,
            title: "附件上传",
            max: false,
            id: 'uploadDialog',
            parent: windowapi,
            width: 400,
            height: 400,
            button: [
                {
                    name: "开始上传",
                    callback: function () {
                        iframe = this.iframe.contentWindow;
                        iframe.startUpload();
                        return false;
                    }
                },
                {
                    name: "取消",
                    callback: function () {
                        return true;
                    }
                }
            ],
            init: function () {
                iframe = this.iframe.contentWindow;
                iframe.initWebUploader(options, function (res) {
                    cb(res,this);
                })
            },
            close: function () {

            }
        }

        if (typeof(windowapi) === 'undefined') {
            return $.dialog(importOption).zindex();
        } else {
            return W.$.dialog($.extend(importOption, {parent: windowapi})).zindex();
        }
    }
    //检查是否重复图片
    function checkReapt(attachList,fileName){

        return $("#"+attachList+" li.attach-list-item[fileName='"+fileName+"']").length>0;

    }
    function getAppendStr(obj,formData) {
        return "<li class=\"attach-list-item\" fileName=" + obj.fileName + "  ><a class=\"attach-name\" href='javascript:void(0);' code="+formData+" imgId=" + obj.id + " realPath=" + obj.realPath + " imgId=\"\" href_=" + obj.urlPath + ">" + obj.fileName + "</a>" +
            "<span class=\"attach-remove fa fa-close\"></span></li>";
    }

    //返回 添加的图片数组
    function getImgeData(attachList) {
        // imgId->id   realPath  urlPath
        var params = [];
        $("#" + attachList).find("li").each(function (item, index) {
            var obj = {};
            var imgId = $(this).find("a.attach-name").attr("imgId");
            var realPath = $(this).find("a.attach-name").attr("realPath");
            var urlPath = $(this).find("a.attach-name").attr("href_");
            var fileName = $(this).find("a.attach-name").text();
            obj["id"] = imgId;
            obj["realPath"] = realPath;
            obj["urlPath"] = urlPath;
            obj["fileName"] = fileName;
            params.push(obj)
        });
        return params;
    }
    function getSaveData() {
        var dataArr = new Array();
        $(".dataItem").find("tr").each(function (itemTr, indexTr){
            var obj=new Object();
            obj.actSubclassName=$("#actSubclassName").val();
            obj.actSubclassCode=$("#actSubclassCode").val();
            obj.tempUuid=$("#tempUuid").val();
            obj.actDetailCode=$("#actDetailCode").val();
            var params = [];
            $(this).find("li").each(function (item, index) {
                var objTemp = {};
                var imgId = $(this).find("a.attach-name").attr("imgId");
                var realPath = $(this).find("a.attach-name").attr("realPath");
                var urlPath = $(this).find("a.attach-name").attr("href_");
                var fileName = $(this).find("a.attach-name").text();
                var code = $(this).find("a.attach-name").attr("code");
                objTemp["id"] = imgId;
                objTemp["realPath"] = realPath;
                objTemp["urlPath"] = urlPath;
                objTemp["fileName"] = fileName;
                obj.exampleCode = code;
                params.push(objTemp)
            });
            obj.attachs=params;
            dataArr.push(obj)
        });

        console.log(dataArr)
        return dataArr;
    }
    function saveData_() {
        var obj=getSaveData();
        $.ajax({
            type: "POST",
            url: "/pay/ttAuditActDetailController/saveOrUpdateDetailUpload",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(obj),
            dataType : "json",
            success: function(data){
                var api = frameElement.api, W = api.opener;
                if (data.success) {
                    W.tip(data.msg);
                    W.ttAuditActDetaillistsearch();
                    api.close();
                }else{
                    tip(data.msg);
                }
            }
        });
    }

    $(".attach-list").on('click', '.attach-remove', function () {
        var that = this;
        var imgeId = $(this).parent().find("a.attach-name").attr("imgId");//这里获取上面 的 属性值
        if (imgeId != undefined && imgeId != null && imgeId != '') {
            $.ajax({
                url: '/pay/ttAuditActDetailController/deleteDetailAttachment',
                data: {id: imgeId},
                dataType: "json",
                type: "GET",
                async: false,
                error: function () {
                    tip("出现异常。");
                },
                success: function (data) {
                    if (data.success == true) {  //成功直接删除
                        $(that).parent().remove();
                    } else {
                        tip(data.msg);
                    }
                }
            })
        }else{
            $(that).parent().remove();
        }

    });
</script>
</html>
