<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>区域销售数据</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <style>
        [v-cloak]{
            display: none;
        }
        .container {
            box-sizing: border-box;
            overflow-y: auto;
        }

        .chart-title {
            text-align: center;
        }

        .sale-chart {
            height: 400px;
            width: 50%;
        }

        .chart-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .chart-table table td,
        .chart-table table th {
            height: 30px;
            border: 1px solid #eeeeee;
            box-sizing: border-box;
            position: relative;
            text-align: center;
        }

        .chart-table table th {
            background: #f6f6f6;
        }

        .finish-percent {
            position: relative;
            width: 0;
            height: 80%;
            transition: all .5s ease-in;
        }

        .finish-percent span {
            color: #fff;
            position: absolute;
            left: 0;
            top: 2px;
        }

        .finish-progress {
            width: 100%;
            height: 16px;
            background: #ddd;
        }

        .progress-bar {
            height: 6px;
            width: 0;
            background: #1890ff;
            border-radius: 6px;
            transition: width .5s ease-in;
        }

        .text-normal {
            color: green;
        }

        .text-danger {
            color: red;
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="container p10">
        <h1 class="chart-title">区域销售数据分析</h1>
        <div class="month-sale">
            <div class="chart-table mb20">
                <table>
                    <thead>
                    <tr>
                        <th>省份</th>
                        <th>实际-销售额</th>
                        <th>实际-销量-吨</th>
                        <th>实际-成本</th>
                        <th>实际-费用</th>
                        <th>去年-销售额</th>
                        <th>环比增长</th>
                        <th>计划达成度</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr v-for="(item,index) in tableData">
                        <td>{{item.province}}</td>
                        <td>{{item.realSaleMoney}}<i class="fa fa-long-arrow-up ml5 text-normal"></i></td>
                        <td>{{item.realSaleNum}}</td>
                        <td>{{item.realCost}}</td>
                        <td>{{item.realFee}}</td>
                        <td>{{item.lastSaleMoney}}</td>
                        <td>{{item.increase}}%<i class="fa fa-circle ml5 text-danger"></i></td>
                        <td>
                            <div class="finish-progress flex flex-align-items-center">
                                <div class="progress-bar" :style="{width:item.finish+'%'}">
                                </div>
                            </div>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="flex flex-align-items-center">
                <div class="sale-chart mr20">
                    <div ref="saleMap" style="width: 100%;height: 100%;"></div>
                </div>
                <div class="sale-chart">
                    <div ref="saleBar" style="width: 100%;height: 100%;"></div>
                </div>
            </div>

        </div>
    </div>
</div>
<script src="/resources/sfa/js/vue.min.js"></script>
<script src="/resources/sfa/js/echarts.min.js"></script>
<script src='/resources/sfa/js/china.js'></script>
<script>
    let vm = new Vue({
        el: "#app",
        data: function () {
            return {
                saleMap: null,
                saleBar: null,
                tableData: [{
                    province: "北京",
                    realSaleMoney: 19892632,
                    realSaleNum: 3978526.4,
                    realCost: 9946316,
                    realFee: 5967789.6,
                    lastSaleMoney: 18380791.97,
                    increase: 7.60,
                    finish: 95
                }, {
                    province: "上海",
                    realSaleMoney: 11867632,
                    realSaleNum: 2373526.4,
                    realCost: 5933816,
                    realFee: 3560289.6,
                    lastSaleMoney: 11499735.41,
                    increase: 3.10,
                    finish: 93
                }, {
                    province: "广州",
                    realSaleMoney: 16892234,
                    realSaleNum: 3378446.8,
                    realCost: 8446117,
                    realFee: 5067670.2,
                    lastSaleMoney: 16419251.45,
                    increase: 2.80,
                    finish: 87
                }, {
                    province: "四川",
                    realSaleMoney: 9856432,
                    realSaleNum: 1971286.4,
                    realCost: 4928216,
                    realFee: 2956929.6,
                    lastSaleMoney: 9324184.672,
                    increase: 5.40,
                    finish: 95
                }, {
                    province: "湖南",
                    realSaleMoney: 8867841,
                    realSaleNum: 1773568.2,
                    realCost: 4433920.5,
                    realFee: 2660352.3,
                    lastSaleMoney: 8965387.251,
                    increase: -1.10,
                    finish: 91
                }, {
                    province: "湖北",
                    realSaleMoney: 8696723,
                    realSaleNum: 1739344.6,
                    realCost: 4348361.5,
                    realFee: 2609016.9,
                    lastSaleMoney: 8331460.634,
                    increase: 4.20,
                    finish: 75
                }]
            }
        },
        mounted: function () {
            this.initSaleMap();
            this.initSaleBar();
        },
        methods: {
            initSaleMap: function () {
                this.saleMap = echarts.init(this.$refs.saleMap);
                echarts.registerMap('CHINA', CHINA_MAP_GEO_JSON)
                let option = {
                    tooltip: {
                        trigger: 'item',
                        formatter: function (params) {
                            return params.name + '<br>' + '销售额：' + params.value || 0
                        }
                    },
                    visualMap: {
                        left: 'right',
                        min: 0,
                        max: 40000000,
                        inRange: {
                            color: ['#313695', '#4575b4', '#74add1', '#abd9e9', '#e0f3f8',
                                '#ffffbf', '#fee090', '#fdae61',
                                '#f46d43', '#d73027', '#a50026'
                            ]
                        },
                        text: ['高', '低'],
                        calculable: true
                    },
                    series: [{
                        type: 'map',
                        roam: false,
                        map: 'CHINA',
                        zoom: 1.2,
                        itemStyle: {
                            emphasis: {
                                label: {
                                    show: true
                                }
                            }
                        },
                        textFixed: {
                            Alaska: [20, -20]
                        },
                        data: [{
                            name: '四川省',
                            value: 9856432
                        },
                            {
                                name: '上海市',
                                value: 731449
                            },
                            {
                                name: '北京市',
                                value: 11867632
                            },
                            {
                                name: '广东省',
                                value: 16892234
                            }, {
                                name: "湖南省",
                                value: 8867841
                            }, {
                                name: "湖北省",
                                value: 8696723
                            }
                        ]
                    }]
                };
                this.saleMap.setOption(option);
            },
            initSaleBar: function () {
                this.saleBar = echarts.init(this.$refs.saleBar);
                let option = {
                    color: ['#57A9D4', '#FCD85C'],
                    tooltip: {
                        trigger: 'axis',
                        axisPointer: {
                            type: 'shadow'
                        }
                    },
                    legend: {
                        data: ['销售额', '成本']
                    },
                    grid: {
                        left: '3%',
                        right: '4%',
                        bottom: '3%',
                        containLabel: true
                    },
                    xAxis: {
                        type: 'value',
                        boundaryGap: [0, 0.01]
                    },
                    yAxis: {
                        type: 'category',
                        data: ['北京', '上海', '广州', '四川', '湖南', '湖北']
                    },
                    series: [{
                        name: '销售额',
                        type: 'bar',
                        data: [19892632, 11867632, 16892234, 9856432, 8867841, 8696723]
                    },
                        {
                            name: '成本',
                            type: 'bar',
                            data: [9946316, 5933816, 8446117, 4928216, 4433920.5, 4348361.5]
                        }
                    ]
                };

                this.saleBar.setOption(option);
            },
        },
    })
</script>
</body>

</html>