<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>定额明细添加</title>
    <t:base type="jquery,easyui,tools,choseSelect"></t:base>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid action="/act/ttActDepartUseController/saveOrUpdateDetail"  layout="div" beforeSubmit="canleDisable"  dialog="true" formid="detailId">
    <t:dgFormList>
        <t:dgFormColumn field="id" hidden="true" defaultVal="${vo.id}" formClass="form" labelName="id" optionType="input" required="false"/>
        <t:dgFormColumn field="budgetCode" hidden="true" defaultVal="${budgetCode}" formClass="form" labelName="budgetCode" optionType="input" required="false"/>
        <t:dgFormColumn field="tempUuid" hidden="true" defaultVal="${tempUuid}" formClass="form" labelName="id" optionType="input" required="false"/>
        <t:dgFormColumn field="categoriesCode" hidden="true" defaultVal="${categoriesCode}" formClass="form" labelName="categoriesCode" optionType="input" required="false"/>
        <t:dgFormColumn field="actSubclassName" hidden="false" formClass="form" labelName="活动细类" keyopInput="actSubclassNamekeyopInput" optionType="selectComponent" required="true"
                        onclick="selectActSubClass()" defaultVal="${vo.actSubclassName}" dataType="*"/>
        <t:dgFormColumn field="actSubclassCode"  formClass="form" labelName="活动细类编码" optionType="input" hidden="true" required="true"
                        defaultVal="${vo.actSubclassCode}" />
        <t:dgFormColumn field="isMultipleAudit"  formClass="form" labelName="是否允许多次核销" optionType="input" hidden="true" required="false"
                        defaultVal="${vo.isMultipleAudit}" />
        <t:dgFormColumn field="orgName" hidden="false" formClass="form" labelName="组织名称" keyopInput="orgNamekeyopInput" optionType="selectComponent" required="true"
                        onclick="selectOrg()" defaultVal="${vo.orgName}" dataType="*"/>
        <t:dgFormColumn field="orgCode"  formClass="form" labelName="组织编码" optionType="input" hidden="true" required="true"
                        defaultVal="${vo.orgCode}" />
        <t:dgFormColumn field="maktx" hidden="false" formClass="form" labelName="物料名称" keyopInput="maktxkeyopInput" optionType="selectComponent" required="true"
                        onclick="selectProductInfo()" defaultVal="${vo.maktx}" dataType="*"/>
        <t:dgFormColumn field="matnr"  formClass="form" labelName="物料编码" optionType="input" hidden="true" required="true"
                        defaultVal="${vo.matnr}" />
        <t:dgFormColumn field="unitConversion"  formClass="form" labelName="单位换算系数" optionType="input" hidden="true" required="false"
                        defaultVal="" />


        <t:dgFormColumn field="price" hidden="${price}" formClass="form" labelName="单价" optionType="input" required="false"
                        defaultVal="${vo.price}" />
        <t:dgFormColumn field="productNum" hidden="false" formClass="form" labelName="数量" optionType="input" required="true"
                        defaultVal="${vo.productNum}" dataType="/^(([1-9][0-9]*)|(([0]\.\d{1,2}|[1-9][0-9]*\.\d{1,2})))$/"/>
        <t:dgFormColumn field="unit" hidden="true" readOnly="true" formClass="form" labelName="单位" optionType="select" required="true"
                        typeGroupCode="basic_unit"    defaultVal="${vo.unit}" dataType="*" />
        <t:dgFormColumn field="unitValue" hidden="false" readOnly="true" formClass="form" labelName="单位" optionType="input" required="true"
                        defaultVal="${vo.unitValue}" dataType="*" />

        <t:dgFormColumn field="miniPack" hidden="${miniPack}"  formClass="form" labelName="最小包装量" optionType="input" required="false"
                        defaultVal="${vo.miniPack}"/>

        <t:dgFormColumn field="amount" hidden="${amount}" formClass="form" labelName="申请金额" optionType="input" required="false"
                        defaultVal="${vo.amount}"  />
        <t:dgFormColumn field="remarks" hidden="false" cols="4" rows="3" formClass="form" labelName="备注" optionType="textarea" required="false"
                        defaultVal="${vo.remarks }" />
    </t:dgFormList>
    <div>

    </div>
</t:formvalid>
<script>
    //禁用单位下拉框，由选择物料控制
    $("#unit").attr("disabled", "disabled");
    //提交之前取消select禁用
    function canleDisable() {
        $("#unit").removeAttr("disabled");
    }
    //选择细类
    function selectActSubClass(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        var tableType = "departuse";
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        triggerId = "actSubclassCode";
        triggerName = "actSubclassName";
        url = "/page/ttApiFineController/goApiActFineMain?tableType="+tableType+"&categoriesCode="+categoriesCode+"&budgetCode="+budgetCode;
        width = 1000;
        height = 450;
        id = "actSubclassList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].fineCode);
                    $("#" + triggerName).val(myobj[0].fineName);
                    $("#isMultipleAudit").val(myobj[0].isMultipleAudit);
                    $("#actSubclassName").focus();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    function selectOrg(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "orgCode";
        triggerName = "orgName";
        url = "/page/tmApiOrgController/goOrgListMainPage?clickFunctionId=${clickFunctionId}";
        width = 450;
        height = 450;
        id = "orgListMain";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width ,
            height: height ,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].codeText);
                    $("#" + triggerName).val(myobj[0].nameText);
                    $("#orgName").focus();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    function selectTerminal(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        var customerCode=$("#customerCode").val();
        if (customerCode ==undefined || customerCode==''){
            tip("请选择客户");
            return ;
        }
        triggerId = "terminalCode";
        triggerName = "terminalName";
        url = "/page/tmApiTerminalController/goTerminalListMain?customerCode="+customerCode;
        width = 1000;
        height = 450;
        id = "terminalList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].terminalCode);
                    $("#" + triggerName).val(myobj[0].terminalName);
                    $("#terminalName").focus();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    
    function setProductInfo(basicUnit) {
        //异步获取销售单位的数据字典值
        $.ajax({
            url:"/kernel/kernel-api/knlApiDictController/getDictByParamObj",
            data:{
                dictTypeCode:"basic_unit",
                dictCode:basicUnit
            },
            dataType:'json',
            type:'post',
            async:false,
            success:function(data){
                $("#unitValue").val(data.obj.dictValue);
            }
        })
        var unitConversion = $("#unitConversion").val();
        if (unitConversion == "" || typeof(unitConversion) == "undefined") {
            tip("该物料尚未配置单位换算系数，无法计算申请金额");
        }
        var productNum = $("#productNum").val();
        if (productNum != "" && unitConversion != "") {
            //金额=数量*物料单位转换系数 ✖️ 成本价
            $("#amount").val(numMulti(numMulti(productNum,unitConversion),$("#price").val()));
        }else{
            $("#amount").val("");
        }
    }
    
    //选择产品
    function selectProductInfo(){
        //查询成本价大于0的产品，costPriceGreaterZero为成本价大于0查询字段
        var url = "/page/tmApiProductInfoController/goProductInfoAndCostPriceListMain?check=true&costPriceGreaterZero=true";
        var width = 1000;
        var height = 450;
        id = "productinfoList";
        var gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {

                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData == '' || rowsData == null) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj=eval(rowsData);
                    $("#maktx").val(myobj[0].productInfoName);
                    $("#matnr").val(myobj[0].productInfoCode);
                    $("#price").val(myobj[0].costPrice);
                    $("#unit").val(myobj[0].basicUnit);
                    //单位换算系数
                    $("#unitConversion").val(myobj[0].unitConversion);
                    var basicUnit = myobj[0].basicUnit;
                    setProductInfo(basicUnit);
                    $("#maktx").focus();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    $("#productNum").blur(function () {
        var productNum = $("#productNum").val();
        var price = $("#price").val();
        var matnr = $("#matnr").val();
        $.ajax({
            url:"/kernel/mdmProductInfoController/getProductInfoByIdOrCode",
            data:{
                code : matnr
            },
            dataType:'json',
            type:'post',
            async:false,
            success:function(data){
                $("#unitConversion").val(data.obj.unitConversion);
            }
        })
        var unitConversion = $("#unitConversion").val();
        if (price != "" && unitConversion !="" && productNum != "") {
            $("#amount").val(numMulti(numMulti(productNum,unitConversion),price));
        }else{
            $("#amount").val("");
        }
    })
    /**
     * 乘法运算，避免数据相乘小数点后产生多位数和计算精度损失。
     *
     * @param num1被乘数 | num2乘数
     */
    function numMulti(num1, num2) {
        var baseNum = 0;
        try {
            baseNum += num1.toString().split(".")[1].length;
        } catch (e) {
        }
        try {
            baseNum += num2.toString().split(".")[1].length;
        } catch (e) {
        }
        return Number(num1.toString().replace(".", "")) * Number(num2.toString().replace(".", "")) / Math.pow(10, baseNum);
    };

    /**
     * 除法运算，避免数据相除小数点后产生多位数和计算精度损失。
     *
     * @param num1被除数 | num2除数
     */
    function numDiv(num1, num2) {
        var baseNum1 = 0, baseNum2 = 0;
        var baseNum3, baseNum4;
        var baseNum5;
        try {
            baseNum1 = num1.toString().split(".")[1].length;
        } catch (e) {
            baseNum1 = 0;
        }
        try {
            baseNum2 = num2.toString().split(".")[1].length;
        } catch (e) {
            baseNum2 = 0;
        }
        with (Math) {
            baseNum3 = Number(num1.toString().replace(".", ""));
            baseNum4 = Number(num2.toString().replace(".", ""));
            baseNum5 = (baseNum3 / baseNum4) * pow(10, baseNum2 - baseNum1);
            return baseNum5;
        }
    };

    /**
     * 保留两位小数
     * @param value
     * @returns {number}
     */
    function returnFloat(value){
        var value = Math.round(parseFloat(value) * 100) / 100;
        var s = value.toString().split(".");
        if(s.length== 1){
            value = value.toString() + ".00";
            return value;
        }
        if (s.length > 1) {
            if (s[1].length < 2) {
                value = value.toString() + "0";
            }
            return value;
        }
    }

    // 输入
    function actSubclassNamekeyopInput(event){
        var that = event.currentTarget;
        var value = $(that).val();
        var tableType = "departuse";
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        var paramObj = {
            list: [], // 接口返回的数据
            nameList: ['fineName'],  //option上所要显示的数据字段
            valList: [{'key':'fineCode','id':'actSubclassCode'}], // 其他表单所需要的数据,key为表单展示的值,id为所需展示的表单的id
            hideList: ['fineCode'], // 需要隐藏显示的数据字段
        }
        $.ajax({
            type: "POST",
            url: '/budget/ttApiFineController/getActFineList?categoriesStatus=009&tableType='+tableType+'&categoriesCode='+categoriesCode+'&budgetCode='+budgetCode,
            async: true,
            data: {'fineName':value},
            success: function(msg){
                paramObj.list = msg;
                ajaxInput($(that),paramObj);
            }
        });
    }

    function orgNamekeyopInput(event){
        var that = event.currentTarget;
        var value = $(that).val();
        var paramObj = {
            list: [], // 接口返回的数据
            nameList: ['nameText'],  //option上所要显示的数据字段
            valList: [{'key':'codeText','id':'orgCode'}], // 其他表单所需要的数据,key为表单展示的值,id为所需展示的表单的id
            hideList: ['codeText'], // 需要隐藏显示的数据字段
        }
        $.ajax({
            type: "POST",
            url: '/kernel/tmApiOrganController/findOrgListMainPage?clickFunctionId=${clickFunctionId}',
            async: true,
            data: {'nameText':value,'page':'1','rows':'20'},
            success: function(msg){
                paramObj.list = msg.rows;
                ajaxInput($(that),paramObj);
            }
        });
    }


    function maktxkeyopInput(event){
        var that = event.currentTarget;
        var value = $(that).val();
        var paramObj = {
            list: [], // 接口返回的数据
            nameList: ['productInfoName'],  //option上所要显示的数据字段
            valList: [{'key':'productInfoCode','id':'matnr'},{'key':'basicUnit','id':'unit'},{'key':'costPrice','id':'price'},{'key':'unitConversion','id':'unitConversion'}], // 其他表单所需要的数据,key为表单展示的值,id为所需展示的表单的id
            hideList: ['productInfoCode','basicUnit','unitConversion','costPrice'], // 需要隐藏显示的数据字段
        }
        $.ajax({
            type: "POST",
            url: '/kernel/mdmProductInfoController/findProductInfoByPage?costPriceGreaterZero=true',
            async: true,
            data: {'productInfoName':value,'page':'1','rows':'20'},
            success: function(msg){
                paramObj.list = msg.rows;
                ajaxInput($(that),paramObj);
            }
        });
    }

    // 选择
    function chooseOption(event){
        var that = event.currentTarget;
        var inputVal = $(that).closest('.selectList').siblings('.inputComponent').find('.input');
        inputVal.val($.trim($(that).text()));
        $(that).closest('.selectList').hide();
        var valList = JSON.parse($(that).attr('data-valList'));
        if(valList && valList.length){
            for(var k = 0; k < valList.length; k ++){
                var value = $(that).attr('data-' + valList[k].key);
                $('#' + valList[k].id).val(value);
            }
        }
        if(inputVal.attr("id")=="maktx"){
            var basicUnit = $("#unit").val();
            setProductInfo(basicUnit);
        }
    }

</script>
</body>
</html>