<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>价格活动</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        #content{
            height: auto!important;
            padding: 0px !important;
        }
        .layout-split-north {
            border-bottom: 1px solid #0072ae00;
        }

        .layout-split-south {
            border-top: 1px solid #ffffff;
        }
        #actName{
            width: 100%!important;
        }
        .form-group{
            padding: 0px;
        }
    </style>
</head>

<body class="easyui-layout" fit="true" id="globallayout">
<div data-options="region:'north',split:true" style="height:200px;">
    <div class="form-group" id="app">
        <%--关键指标html开始--%>
        <target-table ref="targetTable" :id="id" :page="page" :show-target="isActiviti" :view-status="viewStatus"
                      @refresh="handleRefresh"></target-table>
        <%--关键指标html结束 --%>
    </div>
    <t:formvalid action="null" layout="div" beforeSubmit="saveData()" dialog="true" formid="detailId" >
        <t:dgFormList layoutStyle="horizontal" tagConf="${clickFunctionId}" expandParam="${clickFunctionId}">
            <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                            defaultVal="${vo.id }"/>
            <t:dgFormColumn field="needShare" hidden="true" formClass="form" labelName="needShare" optionType="input"
                            required="false"
                            defaultVal="${vo.needShare }"/>
            <t:dgFormColumn field="actCode" hidden="true" formClass="form" labelName="actCode" optionType="input"
                            required="false"
                            defaultVal="${vo.actCode }"/>
            <t:dgFormColumn field="extChar1" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar1"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar1 }"/>
            <t:dgFormColumn field="extChar2" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar2"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar2 }"/>
            <t:dgFormColumn field="extChar3" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar3"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar3 }"/>
            <t:dgFormColumn field="extChar4" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar4"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar4 }"/>
            <t:dgFormColumn field="extChar5" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar5"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar5 }"/>
            <t:dgFormColumn field="extChar6" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar6"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar6 }"/>
            <t:dgFormColumn field="extChar7" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar7"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar7 }"/>
            <t:dgFormColumn field="extChar8" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar8"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar8 }"/>
            <t:dgFormColumn field="actName" hidden="false" formClass="biz-col-100 mb5 form"  labelName="活动名称"
                            optionType="input" required="true"
                            defaultVal="${vo.actName}"/>
            <t:dgFormColumn field="budgetCode" hidden="false" formClass="biz-col-33 mb5 form" labelName="预算选择"
                            optionType="choseDialog" required="true"
                            onclick="selectbudget()" defaultVal="${vo.budgetCode}"/>
            <t:dgFormColumn field="budgetSubjectsCode" hidden="true" formClass="biz-col-50 mb5 form" labelName="预算科目编码" optionType="input" required="false"
                            defaultVal="${vo.budgetSubjectsCode}"/>
            <t:dgFormColumn field="budgetSubjectsName" hidden="true" formClass="biz-col-50 mb5 form" labelName="预算科目名称" optionType="input" required="false"
                            defaultVal="${vo.budgetSubjectsName}"/>
            <t:dgFormColumn field="categoriesName" hidden="false" formClass="biz-col-33 mb5 form" labelName="活动大类"
                            optionType="choseDialog" required="true"
                            onclick="selectCategories()" defaultVal="${vo.categoriesName}"/>
            <t:dgFormColumn field="categoriesCode" hidden="true" formClass="biz-col-33 mb5 form" labelName="活动大类名称"
                            optionType="input" required="false"
                            defaultVal="${vo.categoriesCode }"/>
            <t:dgFormColumn field="beginDate" dateFormat="yyyy-MM-dd HH:mm:ss" extendField="endDate" extendFieldVal="${vo.endDate}" hidden="false"
                            formClass="biz-col-33 mb5 form" labelName="起止时间" optionType="date_begin_end" required="true"
                            defaultVal="${vo.beginDate}"/>
            <t:dgFormColumn field="remarks" hidden="false" formClass="biz-col-100 form " labelName="备注" optionType="textarea"
                            required="false"
                            rows="3" cols="5" defaultVal="${vo.remarks}" style="width: 100%; height: 53px;"/>
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">
    <t:datagrid name="priceDetailList" checkbox="true" fitColumns="false" idField="id" fit="true"
                queryMode="group"
                actionUrl="/act/ttActPriceController/findTtActPriceDetailPage?actCode=${vo.actCode}"
                pagination="false" tagConf="${clickFunctionId}_ttActPriceForm"
    >
        <t:dgCol title="id" field="id" hidden="true"/>
        <t:dgCol title="促销类型" field="actDetailType" sortable="false" dictionary="act_detail_type" width="100"/>
        <t:dgCol title="价格维度" field="actPriceDetailDimension" sortable="false" dictionary="act_price_detail_dimension" width="100"/>
        <t:dgCol title="活动细类" field="actSubclassName" sortable="false" width="100"/>
        <t:dgCol title="活动细类编码" field="actSubclassCode" sortable="false" hidden="true" width="100"/>
        <t:dgCol title="活动细类是否允许多次核销" field="isMultipleAudit" sortable="false" hidden="true" width="100"/>
        <t:dgCol title="商品" field="productName" sortable="false" width="200"/>
        <t:dgCol title="商品" field="productCode" sortable="false" hidden="true" width="100"/>
        <t:dgCol title="客户" field="customerName" sortable="false" width="200"/>
        <t:dgCol title="客户" field="customerCode" hidden="true" sortable="false" width="200"/>
        <t:dgCol title="门店" field="terminalName" sortable="false" width="150"/>
        <t:dgCol title="门店" field="terminalCode" hidden="true" sortable="false" width="150"/>
        <t:dgCol title="价格组" field="priceGroup" sortable="false" dictionary="price_group" width="80"/>
        <t:dgCol title="标准价" field="standPrice" sortable="false" width="50"/>
        <t:dgCol title="申请价" field="applyPrice" sortable="false" width="50"/>
        <t:dgCol title="预计销量" field="forecastSalesNum" sortable="false" width="80"/>
        <t:dgCol title="预估销售额" field="forecastSalesAmount" sortable="false" width="80"/>
        <t:dgCol title="申请费用金额" field="amount" sortable="false" width="80"/>
        <t:dgCol title="差价" field="diffPrice" sortable="false" width="50"/>
        <t:dgCol title="本品数量(计算之前)" hidden="true" field="productNum" sortable="false" width="80"/>
        <t:dgCol title="本品数量" field="tempProductNum" sortable="false" width="80"/>
        <t:dgCol title="本品金额(计算之前)" hidden="true" field="productAmount" sortable="false" width="80"/>
        <t:dgCol title="本品金额" field="tempProductAmount" sortable="false" width="80"/>
        <t:dgCol title="" field="actPriceBuyType" hidden="true" sortable="false" width="80"/>
        <t:dgCol title="赠品" field="giftName" sortable="false" width="150"/>
        <t:dgCol title="赠品JSON" field="giftJson" sortable="false" hidden="true" width="150"/>
        <t:dgCol title="成本价" field="giftCostPrice" hidden="true" sortable="true" width="150"/>
        <t:dgCol title="折扣比例" field="discountScale" sortable="true" width="150"/>
        <t:dgCol title="赠品数量(计算之前)" hidden="true" field="giftNum" sortable="false" width="80"/>
        <t:dgCol title="赠品数量" field="tempGiftNum" sortable="false" width="80"/>
        <t:dgCol title="赠品金额(计算之前)" field="giftAmount" hidden="true" sortable="false" width="80"/>
        <t:dgCol title="赠品金额" field="tempGiftAmount" sortable="false" width="80"/>
        <t:dgCol title="赠品金额比例" field="giftScale" sortable="false" width="80"/>
        <t:dgCol title="" field="actPriceGiftType" hidden="true" sortable="false" width="80"/>
        <t:dgCol title="订单金额" field="orderAmount" sortable="false" width="80"/>
        <t:dgCol title="满减类型" field="fullreduceType" dictionary="fullreduce_type" sortable="false" width="80"/>
        <t:dgCol title="满减金额" field="fullreduceAmount" sortable="false" width="80"/>
        <t:dgCol title="满减比例" field="fullreduceScale" sortable="false" width="80"/>
        <t:dgCol title="比例" field="scale" sortable="false" hidden="true" width="100"/>
        <t:dgCol title="是否叠加" field="isStack" sortable="false" width="100" dictionary="is_no"/>
        <t:dgCol title="限额限量" field="isLimit" sortable="false" width="100" dictionary="is_no"/>
        <t:dgCol title="是否累计" field="isAdd" sortable="false" width="100" dictionary="is_no"/>
        <t:dgCol title="多客户/单客户" field="priceAttribute" hidden="true" sortable="false" width="100" />
        <t:dgCol title="extChar1" field="extChar1" sortable="false" hidden="true" width="80"/>
        <t:dgCol title="extChar2" field="extChar2" sortable="false" hidden="true" width="80"/>
        <t:dgCol title="extChar3" field="extChar3" sortable="false" hidden="true" width="80"/>
        <t:dgCol title="extChar4" field="extChar4" sortable="false" hidden="true" width="80"/>
        <t:dgCol title="extChar5" field="extChar5" sortable="false" hidden="true" width="80"/>
        <t:dgCol title="extChar6" field="extChar6" sortable="false" hidden="true" width="80"/>
        <t:dgToolBar title="新增" detail="false" funname="addDetail" icon="icon-add"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="编辑" detail="false" funname="updateDetail" icon="icon-edit"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="查看"  funname="showDetail" icon="icon-edit"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="删除" detail="false" funname="deleteALLSelectSelf" icon="icon-remove"
                     url="/act/ttActPriceController/delDetail"></t:dgToolBar>
        <c:if test="${isDisplay == '1' }">
            <t:dgToolBar title="导入" detail="false" icon="icon-dataIn" onclick="detailExcel()" ></t:dgToolBar>
        </c:if>

    </t:datagrid>
</div>
</body>
</html>

<script type="text/javascript">
    var clickFunctionId= '${clickFunctionId}';
    //关键指标js开始
    let vm = new Vue({
        el: "#app",
        data: function () {
            return {
                id: "${vo.id}",
                page: "jghd",
                viewStatus: "${viewStatus}",
                isActiviti: "${isActiviti}"
            }
        },
        methods: {
            handleRefresh: function (target) {
                let this_ = this;
                canSubmit = true;
                let data = createData();
                if (canSubmit) {
                    let postParams = data;
                    $.ajax({
                        url: "/act/ttActPriceController/refresh",
                        type: "post",
                        dataType: "json",
                        data: JSON.stringify(postParams),
                        contentType: "application/json",
                        complete: function () {
                        },
                        success: function (res) {
                            closeProgressTop();
                            if (res.success) {
                                this_.$refs.targetTable.setTargetData(res.obj);
                            } else {
                                tip(res.msg);
                            }
                        },
                        error: function () {
                            closeProgressTop();
                        }
                    })
                }
            },
        }
    })
    //关键指标js结束

    function addProductLayout() {
        $('#globallayout').layout('add', {
            region: 'south',
            height: 250,
            split: true,
            collapsible: false
        });
        $('#globallayout').layout("panel", "south").panel({href: "/page/ttActPriceController/goActProductForm"});
    }

    function collapseProductLayout() {
        $("#needShare").val("N");
        $('#globallayout').layout('remove', 'south');
    }

    /*编辑活动明细*/
    function updateDetail() {
        var startTime = $("#beginDate").val();
        if(null == startTime || '' == startTime){
            tip("请先选择活动时间");
            return;
        }
        var rows = $('#priceDetailList').datagrid('getSelections');
        if (rows.length != 1) {
            tip("请选择一条数据操作");
            return;
        }
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        if (categoriesCode == "") {
            tip("请先选择预算");
            return;
        }
        var addurl = "/page/ttActPriceController/goAddActDetailAll?1=1&startTime=" + startTime+"&edit=0&categoriesCode=" + categoriesCode+"&budgetCode="+budgetCode+"&clickFunctionId=${clickFunctionId}";
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 1300,
            height: 500,
            title: '编辑',
            opacity: 0.3,
            zIndex: 2500,
            parent: 'addDetailDialog',
            id: 'addDetailDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var data = iframe.saveData();
                    insertDetailData(data);
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    function showDetail() {
        var rows = $('#priceDetailList').datagrid('getSelections');
        if (rows.length != 1) {
            tip("请选择一条数据操作");
            return;
        }
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        if (categoriesCode == "") {
            tip("请先选择预算");
            return;
        }
        var addurl = "/page/ttActPriceController/goAddActDetailAll?1=1&edit=0&load=detail&categoriesCode=" + categoriesCode+"&budgetCode="+budgetCode+"&clickFunctionId=${clickFunctionId}";
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 1300,
            height: 500,
            title: '编辑',
            opacity: 0.3,
            zIndex: 2500,
            parent: 'addDetailDialog',
            id: 'addDetailDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }


    /**新增活动明细*/
    function addDetail() {
        var startTime = $("#beginDate").val();
        if(null == startTime || '' == startTime){
            tip("请先选择活动时间");
            return;
        }
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        if (categoriesCode == "") {
            tip("请先选择活动大类");
            return;
        }
        var addurl = "/page/ttActPriceController/goAddActDetailAll?1=1&startTime=" + startTime+"&categoriesCode=" + categoriesCode+"&budgetCode="+budgetCode+"&clickFunctionId="+clickFunctionId;
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 1300,
            height: 500,
            title: '新增',
            opacity: 0.3,
            zIndex: 2500,
            parent: 'addDetailDialog',
            id: 'addDetailDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var data = iframe.saveData();
                    if (data.productDetailRows.length == 0){
                        return false;
                    }
                    insertDetailData(data);
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    /*插入明细数据*/
    function insertDetailData(data) {

        var productDetailRows = data.productDetailRows;
        if (productDetailRows.length == 0) {
            return;
        }
        var priceDetailListOldRows = $('#priceDetailList').datagrid('getRows');
        var priceDetailListOldObj = [];
        for (var i = 0; i < priceDetailListOldRows.length; i++) {
            priceDetailListOldObj.push(priceDetailListOldRows[i].id);
        }
        var head = data.head;
        //构建赠品名称
        var giftName = createGiftName(head);
        var giftJson = createGiftJson(head);
        //收集活动细类编码

        for (var i = 0; i < productDetailRows.length; i++) {

            if (priceDetailListOldObj.includes(productDetailRows[i].id)) {
                var newGiftNum = "";
                var newProductNum = "";
                var newProductAmount = "";
                var newGiftAmount = "";
                var actPriceBuyType = head.actPriceBuyType;
                var actPriceGiftType = head.actPriceGiftType;
                if (actPriceBuyType == "product_num") {
                    if (actPriceGiftType == "gift_num") {
                        //本品数量
                        var productNum = head.productNum;
                        //赠品数量
                        var giftNum = head.giftNum;
                        //预计销量
                        var forecastSalesNum = productDetailRows[i].forecastSalesNum;
                        if (productNum != "" && giftNum != "" && forecastSalesNum != "" && typeof(forecastSalesNum) != "undefined") {
                            //属于买赠数量类型，展示的本品数量其实是预计销量
                            newProductNum = forecastSalesNum;
                            //本品数量和赠品数量的比例
                            var proportion = Math.floor(numDiv(forecastSalesNum, productNum));
                            //属于买赠数量类型，展示的赠品数量按比例计算
                            newGiftNum = numMulti(giftNum, proportion);
                        }else{
                            newProductNum = productNum;
                            newGiftNum = giftNum;
                        }
                    }else if (actPriceGiftType == "gift_amount") {
                        //本品数量
                        var productNum = head.productNum;
                        //赠品金额
                        var giftAmount = head.giftAmount;
                        //预计销量
                        var forecastSalesNum = productDetailRows[i].forecastSalesNum;
                        if (productNum != "" && giftAmount != "" && forecastSalesNum != "" && typeof(forecastSalesNum) != "undefined") {
                            //属于买赠数量类型，展示的本品数量其实是预计销量
                            newProductNum = forecastSalesNum;
                            //本品数量和赠品数量的比例
                            var proportion = Math.floor(numDiv(forecastSalesNum, productNum));
                            //属于买赠数量类型，展示的赠品数量按比例计算
                            newGiftAmount = numMulti(giftAmount, proportion);
                        }else{
                            newProductNum = productNum;
                            newGiftAmount = giftAmount;
                        }
                    }
                } else if (actPriceBuyType == "product_amount") {
                    if (actPriceGiftType == "gift_num") {
                        //本品金额
                        var productAmount = head.productAmount;
                        //赠品数量
                        var giftNum = head.giftNum;
                        //预计销量额
                        var forecastSalesAmount = productDetailRows[i].forecastSalesAmount;
                        if (productAmount != "" && giftNum != "" && forecastSalesAmount != "" && typeof(forecastSalesAmount) != "undefined") {
                            //属于买赠金额类型，展示的本品金额其实是预计销量额
                            newProductAmount = forecastSalesAmount;
                            //本品数量和赠品数量的比例
                            var proportion = Math.floor(numDiv(forecastSalesAmount, productAmount));
                            //属于买赠金额类型，展示的赠品数量按比例计算
                            newGiftNum = numMulti(giftNum, proportion);
                        }else{
                            newProductAmount = productAmount;
                            newGiftNum = giftNum;
                        }
                    }else if (actPriceGiftType == "gift_amount") {
                        //本品数量
                        var productAmount = head.productAmount;
                        //赠品金额
                        var giftAmount = head.giftAmount;
                        //预计销量
                        var forecastSalesAmount = productDetailRows[i].forecastSalesAmount;
                        if (productAmount != "" && giftAmount != "" && forecastSalesAmount != "" && typeof(forecastSalesAmount) != "undefined") {
                            //属于买赠类型，展示的本品数量其实是预计销量
                            newProductAmount = forecastSalesAmount;
                            //本品数量和赠品数量的比例
                            var proportion = Math.floor(numDiv(forecastSalesAmount, productAmount));
                            //属于买赠类型，展示的赠品数量按比例计算
                            newGiftAmount = numMulti(giftAmount, proportion);
                        }else{
                            newProductAmount = productAmount;
                            newGiftAmount = giftAmount;
                        }
                    }
                }
                //单客户/多客户判断
                var priceAttribute = head.priceAttribute;
                if (priceAttribute == "1" || priceAttribute == "" || priceAttribute== "undefined") {
                    $('#priceDetailList').datagrid('updateRow', {

                        index: getIndex(productDetailRows[i].id),
                        row: {
                            giftName: giftName,
                            giftJson: giftJson,
                            actDetailType: head.actDetailType,
                            actPriceDetailDimension: head.actPriceDetailDimension,
                            priceAttribute:head.priceAttribute,
                            customerName: head.customerName,
                            customerCode: head.customerCode,
                            terminalName: head.terminalName,
                            terminalCode: head.terminalCode,
                            priceGroup: head.priceGroup,
                            productNum: head.productNum,
                            giftNum: head.giftNum,
                            tempProductNum: newProductNum,
                            tempGiftNum: newGiftNum,
                            tempProductAmount: newProductAmount,
                            tempGiftAmount: newGiftAmount,
                            actSubclassName: head.actSubclassName,
                            actSubclassCode: head.actSubclassCode,
                            isMultipleAudit: head.isMultipleAudit,
                            discountScale: productDetailRows[i].discountScale,
                            diffPrice: productDetailRows[i].diffPrice,
                            applyPrice: productDetailRows[i].applyPrice,
                            productName: productDetailRows[i].productInfoName,
                            productCode: productDetailRows[i].productInfoCode,
                            standPrice: productDetailRows[i].standPrice,
                            forecastSalesNum: productDetailRows[i].forecastSalesNum,
                            forecastSalesAmount: productDetailRows[i].forecastSalesAmount,
                            amount: productDetailRows[i].amount,
                            scale: productDetailRows[i].scale,
                            isStack: head.isStack,
                            isAdd: head.isAdd,
                            extChar1: head.extChar1,
                            extChar2: head.extChar2,
                            extChar3: head.extChar3,
                            extChar4: head.extChar4,
                            extChar5: head.extChar5,
                            extChar6: head.extChar6,
                            isLimit: head.isLimit,
                            productAmount: head.productAmount,
                            giftAmount: head.giftAmount,
                            giftScale: head.giftScale,
                            actPriceBuyType:head.actPriceBuyType,
                            actPriceGiftType:head.actPriceGiftType,
                            orderAmount:head.orderAmount,
                            fullreduceType:head.fullreduceType,
                            fullreduceAmount:head.fullreduceAmount,
                            fullreduceScale:head.fullreduceScale,
                            eachFullreduceAmount:head.eachFullreduceAmount
                        }
                    });
                }else{
                    $('#priceDetailList').datagrid('updateRow', {

                        index: getIndex(productDetailRows[i].id),
                        row: {
                            giftName: giftName,
                            giftJson: giftJson,
                            actDetailType: head.actDetailType,
                            actPriceDetailDimension: head.actPriceDetailDimension,
                            priceAttribute:head.priceAttribute,
                            customerName: productDetailRows[i].customerName,
                            customerCode: productDetailRows[i].customerCode,
                            terminalName: head.terminalName,
                            terminalCode: head.terminalCode,
                            priceGroup: head.priceGroup,
                            productNum: head.productNum,
                            giftNum: head.giftNum,
                            tempProductNum: newProductNum,
                            tempGiftNum: newGiftNum,
                            tempProductAmount: newProductAmount,
                            tempGiftAmount: newGiftAmount,
                            actSubclassName: head.actSubclassName,
                            actSubclassCode: head.actSubclassCode,
                            isMultipleAudit:head.isMultipleAudit,
                            discountScale: productDetailRows[i].discountScale,
                            diffPrice: productDetailRows[i].diffPrice,
                            applyPrice: productDetailRows[i].applyPrice,
                            productName: head.productInfoName,
                            productCode: head.productInfoCode,
                            standPrice: productDetailRows[i].standPrice,
                            forecastSalesNum: productDetailRows[i].forecastSalesNum,
                            forecastSalesAmount: productDetailRows[i].forecastSalesAmount,
                            amount: productDetailRows[i].amount,
                            scale: productDetailRows[i].scale,
                            isStack: head.isStack,
                            isAdd: head.isAdd,
                            isLimit: head.isLimit,
                            productAmount: head.productAmount,
                            giftAmount: head.giftAmount,
                            giftScale: head.giftScale,
                            actPriceBuyType:head.actPriceBuyType,
                            actPriceGiftType:head.actPriceGiftType,
                            orderAmount:head.orderAmount,
                            fullreduceType:head.fullreduceType,
                            fullreduceAmount:head.fullreduceAmount,
                            fullreduceScale:head.fullreduceScale,
                            eachFullreduceAmount:head.eachFullreduceAmount
                        }
                    });
                }
            } else {
                var newGiftNum = "";
                var newProductNum = "";
                var newProductAmount = "";
                var newGiftAmount = "";
                var actPriceBuyType = head.actPriceBuyType;
                var actPriceGiftType = head.actPriceGiftType;
                if (actPriceBuyType == "product_num") {
                    if (actPriceGiftType == "gift_num") {
                        //本品数量
                        var productNum = head.productNum;
                        //赠品数量
                        var giftNum = head.giftNum;
                        //预计销量
                        var forecastSalesNum = productDetailRows[i].forecastSalesNum;
                        if (productNum != "" && giftNum != "" && forecastSalesNum != "" && typeof(forecastSalesNum) != "undefined") {
                            //属于买赠数量类型，展示的本品数量其实是预计销量
                            newProductNum = forecastSalesNum;
                            //本品数量和赠品数量的比例
                            var proportion = Math.floor(numDiv(forecastSalesNum, productNum));
                            //属于买赠数量类型，展示的赠品数量按比例计算
                            newGiftNum = numMulti(giftNum, proportion);
                        }else{
                            newProductNum = productNum;
                            newGiftNum = giftNum;
                        }
                    }else if (actPriceGiftType == "gift_amount") {
                        //本品数量
                        var productNum = head.productNum;
                        //赠品金额
                        var giftAmount = head.giftAmount;
                        //预计销量
                        var forecastSalesNum = productDetailRows[i].forecastSalesNum;
                        if (productNum != "" && giftAmount != "" && forecastSalesNum != "" && typeof(forecastSalesNum) != "undefined") {
                            //属于买赠数量类型，展示的本品数量其实是预计销量
                            newProductNum = forecastSalesNum;
                            //本品数量和赠品数量的比例
                            var proportion = Math.floor(numDiv(forecastSalesNum, productNum));
                            //属于买赠数量类型，展示的赠品数量按比例计算
                            newGiftAmount = numMulti(giftAmount, proportion);
                        }else{
                            newProductNum = productNum;
                            newGiftAmount = giftAmount;
                        }
                    }else if (actPriceGiftType == "gift_scale") {
                        //预计销量
                        var forecastSalesNum = productDetailRows[i].forecastSalesNum;
                        newProductNum = forecastSalesNum;
                    }
                } else if (actPriceBuyType == "product_amount") {
                    if (actPriceGiftType == "gift_num") {
                        //本品金额
                        var productAmount = head.productAmount;
                        //赠品数量
                        var giftNum = head.giftNum;
                        //预计销量额
                        var forecastSalesAmount = productDetailRows[i].forecastSalesAmount;
                        if (productAmount != "" && giftNum != "" && forecastSalesAmount != "" && typeof(forecastSalesAmount) != "undefined") {
                            //属于买赠金额类型，展示的本品金额其实是预计销量额
                            newProductAmount = forecastSalesAmount;
                            //本品数量和赠品数量的比例（向下取整）
                            var proportion = Math.floor(numDiv(forecastSalesAmount, productAmount));
                            //属于买赠金额类型，展示的赠品数量按比例计算
                            newGiftNum = numMulti(giftNum, proportion);
                        }else{
                            newProductAmount = productAmount;
                            newGiftNum = giftNum;
                        }
                    }else if (actPriceGiftType == "gift_amount") {
                        //本品数量
                        var productAmount = head.productAmount;
                        //赠品金额
                        var giftAmount = head.giftAmount;
                        //预计销量额
                        var forecastSalesAmount = productDetailRows[i].forecastSalesAmount;
                        if (productAmount != "" && giftAmount != "" && forecastSalesAmount != "" && typeof(forecastSalesAmount) != "undefined") {
                            //属于买赠类型，展示的本品数量其实是预计销量
                            newProductAmount = forecastSalesAmount;
                            //本品数量和赠品数量的比例
                            var proportion = numDiv(forecastSalesAmount, productAmount);
                            //属于买赠类型，展示的赠品数量按比例计算
                            newGiftAmount = numMulti(giftAmount, proportion);
                        }else{
                            newProductAmount = productAmount;
                            newGiftAmount = giftAmount;
                        }
                    }else if (actPriceGiftType == "gift_scale") {
                        //预计销量额
                        var forecastSalesAmount = productDetailRows[i].forecastSalesAmount;
                        newProductAmount = forecastSalesAmount;
                    }
                }
                //单客户/多客户判断
                var priceAttribute = head.priceAttribute;

                if (priceAttribute == "1" || priceAttribute == "" || priceAttribute== "undefined") {
                    $('#priceDetailList').datagrid('insertRow', {
                        index: 0,
                        row: {
                            giftName: giftName,
                            giftJson: giftJson,
                            id: productDetailRows[i].id,
                            actDetailType: head.actDetailType,
                            actPriceDetailDimension: head.actPriceDetailDimension,
                            priceAttribute:head.priceAttribute,
                            customerName: head.customerName,
                            customerCode: head.customerCode,
                            terminalName: head.terminalName,
                            terminalCode: head.terminalCode,
                            priceGroup: head.priceGroup,
                            productNum: head.productNum,
                            giftNum: head.giftNum,
                            tempProductNum: newProductNum,
                            tempGiftNum: newGiftNum,
                            tempProductAmount: newProductAmount,
                            tempGiftAmount: newGiftAmount,
                            actSubclassName: head.actSubclassName,
                            actSubclassCode: head.actSubclassCode,
                            isMultipleAudit:head.isMultipleAudit,
                            giftCostPrice: head.giftCostPrice,
                            discountScale: productDetailRows[i].discountScale,
                            diffPrice: productDetailRows[i].diffPrice,
                            applyPrice: productDetailRows[i].applyPrice,
                            productName: productDetailRows[i].productInfoName,
                            productCode: productDetailRows[i].productInfoCode,
                            standPrice: productDetailRows[i].standPrice,
                            forecastSalesNum: productDetailRows[i].forecastSalesNum,
                            forecastSalesAmount: productDetailRows[i].forecastSalesAmount,
                            amount: productDetailRows[i].amount,
                            scale: productDetailRows[i].scale,
                            isStack: head.isStack,
                            isAdd: head.isAdd,
                            isLimit: head.isLimit,
                            productAmount: head.productAmount,
                            giftAmount: head.giftAmount,
                            giftScale: head.giftScale,
                            actPriceBuyType:head.actPriceBuyType,
                            actPriceGiftType:head.actPriceGiftType,
                            orderAmount:head.orderAmount,
                            fullreduceType:head.fullreduceType,
                            fullreduceAmount:head.fullreduceAmount,
                            fullreduceScale:head.fullreduceScale,
                            eachFullreduceAmount:head.eachFullreduceAmount
                        }
                    });
                }else{
                    $('#priceDetailList').datagrid('insertRow', {
                        index: 0,
                        row: {
                            giftName: giftName,
                            giftJson: giftJson,
                            id: productDetailRows[i].id,
                            actDetailType: head.actDetailType,
                            actPriceDetailDimension: head.actPriceDetailDimension,
                            priceAttribute:head.priceAttribute,
                            customerName: productDetailRows[i].customerName,
                            customerCode: productDetailRows[i].customerCode,
                            terminalName: head.terminalName,
                            terminalCode: head.terminalCode,
                            priceGroup: head.priceGroup,
                            productNum: head.productNum,
                            giftNum: head.giftNum,
                            tempProductNum: newProductNum,
                            tempGiftNum: newGiftNum,
                            tempProductAmount: newProductAmount,
                            tempGiftAmount: newGiftAmount,
                            actSubclassName: head.actSubclassName,
                            actSubclassCode: head.actSubclassCode,
                            isMultipleAudit:head.isMultipleAudit,
                            giftCostPrice: head.giftCostPrice,
                            discountScale: productDetailRows[i].discountScale,
                            diffPrice: productDetailRows[i].diffPrice,
                            applyPrice: productDetailRows[i].applyPrice,
                            productName: head.productInfoName,
                            productCode: head.productInfoCode,
                            standPrice: productDetailRows[i].standPrice,
                            forecastSalesNum: productDetailRows[i].forecastSalesNum,
                            forecastSalesAmount: productDetailRows[i].forecastSalesAmount,
                            amount: productDetailRows[i].amount,
                            scale: productDetailRows[i].scale,
                            isStack: head.isStack,
                            isAdd: head.isAdd,
                            isLimit: head.isLimit,
                            productAmount: head.productAmount,
                            giftAmount: head.giftAmount,
                            giftScale: head.giftScale,
                            actPriceBuyType:head.actPriceBuyType,
                            actPriceGiftType:head.actPriceGiftType,
                            orderAmount:head.orderAmount,
                            fullreduceType:head.fullreduceType,
                            fullreduceAmount:head.fullreduceAmount,
                            fullreduceScale:head.fullreduceScale,
                            eachFullreduceAmount:head.eachFullreduceAmount
                        }
                    });
                }
            }
        }

        // 价格活动取消产品分摊
        // checkDataForProduct();

    }

    function checkDataForProduct() {
        var actSubclassCodeArr = [];
        var priceDetailListRows = $('#priceDetailList').datagrid('getRows');
        if (priceDetailListRows.length == 0) {
            if ($("#tabsContent").length > 0) {
                collapseProductLayout();
            }
        } else {
            for (var i = 0; i < priceDetailListRows.length; i++) {
                if (!isEmpty(priceDetailListRows[i].actSubclassCode)) {
                    actSubclassCodeArr.push(priceDetailListRows[i].actSubclassCode);
                }
            }
            if (actSubclassCodeArr.length == 0) {

                if ($("#tabsContent").length > 0) {
                    collapseProductLayout();
                }
            } else {
                //请求服务器检查
                $.ajax({
                    url: "/budget/ttCostTypeController/checkProductByFineCode",
                    type: "post",
                    dataType: "json",
                    data: JSON.stringify(actSubclassCodeArr),
                    contentType: "application/json",
                    success: function (res) {
                        if (res.type == "1") {
                            $("#needShare").val("Y");
                            if (!($("#tabsContent").length > 0)) {
                                addProductLayout();
                            }
                        } else {
                            if (($("#tabsContent").length > 0)) {
                                collapseProductLayout();
                            }
                        }

                    }
                });
            }

        }
    }


    function getSelectsRows() {
        var rows = $('#priceDetailList').datagrid('getSelections');
        return rows;
    }

    /*构建赠品名字*/
    function createGiftName(head) {
        var giftName = '';
        if (head.giftJson) {
            var giftJson = head.giftJson;
            for (var i = 0; i < giftJson.length; i++) {
                if (i == 0) {
                    giftName += giftJson[i].name;
                } else {
                    giftName += "," + giftJson[i].name;
                }
            }
        }
        return giftName;
    }

    function createGiftJson(head) {
        var giftJson = '[]';
        if (head.giftJson) {
            giftJson = JSON.stringify(head.giftJson)
        }
        return giftJson;
    }


    function getIndex(id) {
        var tempRows = $('#priceDetailList').datagrid('getRows');
        var index = 0;
        for (var i = 0; i < tempRows.length; i++) {
            if (tempRows[i].id == id) {
                index = $("#priceDetailList").datagrid("getRowIndex", tempRows[i]);
                break;
            }
        }
        return index;
    }


    
    
    /* 提交数据构建 */
    function saveData() {
        var data = createData();
        if (data.details.length == 0) {
            tip("请新增活动明细");
            return false;
        }
        var beginDate = $("#beginDate").val();
        var endDate = $("#endDate").val();
        if ($("#beginDate[dataType]").length>0) {
            if (beginDate == "") {
                tip("活动开始时间必填");
                return false;
            }
        }
        if ($("#endDate[dataType]").length>0) {
            if (endDate == "") {
                tip("活动结束时间必填");
                return false;
            }
        }
        openProgressTop();
        if("${isActiviti}"=="1"){
            var postParams = data;
            $.ajax({
                url: "/act/ttActPriceController/refresh",
                type: "post",
                dataType: "json",
                async : false,
                data: JSON.stringify(postParams),
                contentType: "application/json",
                complete: function () {
                },
                success: function (res) {
                    if (res.success) {
                        vm.$refs.targetTable.setTargetData(res.obj);
                    } else {
                        tip(res.msg);
                        return;
                    }
                },
                error: function () {
                    closeProgressTop();
                }
            })
            data.target = vm.$refs.targetTable.getTargetData();
        }

        $.ajax({
            type: "POST",
            url: "/act/ttActPriceController/saveOrUpdate",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            complete: function () {
                closeProgressTop();
            },
            success: function (data) {
                closeProgressTop();
                var api = frameElement.api, W = api.opener;
                if (data.success) {
                    W.tip(data.msg);
                    W.pricelistsearch();
                    api.close();
                } else {
                    tip(data.msg);
                }
            }
        });
    }

    function createData() {
        var data = {};
        data.id = $("#id").val();
        var head = {};
        head.id = $("#id").val();
        head.actName = $("#actName").val();
        head.needShare = $("#needShare").val();
        head.budgetCode = $("#budgetCode").val();
        head.budgetSubjectsCode= $("#budgetSubjectsCode").val();
        head.budgetSubjectsName= $("#budgetSubjectsName").val();
        head.categoriesCode = $("#categoriesCode").val();
        head.categoriesName = $("#categoriesName").val();
        head.beginDate = $("#beginDate").val();
        head.endDate = $("#endDate").val();
        head.remarks = $("#remarks").val();
        head.extChar1 = $("#extChar1").val();
        head.extChar2 = $("#extChar2").val();
        head.extChar3 = $("#extChar3").val();
        head.extChar4 = $("#extChar4").val();
        head.extChar5 = $("#extChar5").val();
        head.extChar6 = $("#extChar6").val();
        head.extChar7 = $("#extChar7").val();
        head.extChar8 = $("#extChar8").val();
        data.head = head;
        var budgetsArr = [];
        var budgets = {}
        budgets.budgetCode = $("#budgetCode").val();
        budgets.actCode = $("#actCode").val();
        budgetsArr.push(budgets);
        data.budgets = budgetsArr;
        var priceProductListRows = [];
        if (document.getElementById("tabsContent")) {
            priceProductListRows = generateShareData();
        }
        data.products = priceProductListRows;
        var priceDetailListRows = $('#priceDetailList').datagrid('getRows');
        data.details = priceDetailListRows;
        for (var i = -0; i < data.details.length; i++) {
            var giftJson = data.details[i].giftJson;
            if (!isEmpty(giftJson)) {
                var gifts = JSON.parse(giftJson);
                data.details[i].gifts = gifts
            }
        }
        data.target = vm.$refs.targetTable.getTargetData();
        return data;
    }

    function selectbudget(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "budgetCode";
        triggerName = "budgetName";
        url = "/page/ttApiBudgetController/goApiBudgetMain?tableType=act_price";
        width = 1300;
        height = 500;
        id = "ttApibudgetList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#budgetCode").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetCode);
                    $("#budgetSubjectsCode").val(myobj[0].budgetSubjectsCode);
                    $("#budgetSubjectsName").val(myobj[0].budgetSubjectsName);
                    var budgetCode = myobj[0].budgetCode;
                    $.ajax({
                        url:"/budget/ttApiCostTypeCategoriesController/getCategoriesListByBudgetCode?budgetCode="+budgetCode+"&clickFunctionId=${clickFunctionId}",
                        dataType:'json',
                        type:'post',
                        async:false,
                        success:function(data){
                            if (data.length == 1) {
                                $("#categoriesCode").val(data[0].categoriesCode);
                                $("#categoriesName").val(data[0].categoriesName);
                            }else{
                                $("#categoriesCode").val("");
                                $("#categoriesName").val("");
                            }
                        }
                    })
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectCategories() {
        var budgetCode = $("#budgetCode").val();
        if (budgetCode == "") {
            tip("请先选择预算");
            return;
        }
        triggerId = "categoriesCode";
        triggerName = "categoriesName";
        url = "/page/ttApiCostTypeCategoriesController/goApiActSelectCategoriesMain?budgetCode=" + budgetCode;
        width = 600;
        height = 500;
        id = "categoriesList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#categoriesCode").focus();
                if (rowsData.length == 0) {
                    iframe.tip("请至少选择一条数据");
                    return false;
                } else {
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].categoriesCode);
                    $("#" + triggerName).val(myobj[0].categoriesName);
                    $("#categoriesName").focus();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /**
     * 乘法运算，避免数据相乘小数点后产生多位数和计算精度损失。
     *
     * @param num1被乘数 | num2乘数
     */
    function numMulti(num1, num2) {
        var baseNum = 0;
        try {
            baseNum += num1.toString().split(".")[1].length;
        } catch (e) {
        }
        try {
            baseNum += num2.toString().split(".")[1].length;
        } catch (e) {
        }
        return Number(num1.toString().replace(".", "")) * Number(num2.toString().replace(".", "")) / Math.pow(10, baseNum);
    };

    /**
     * 除法运算，避免数据相除小数点后产生多位数和计算精度损失。
     *
     * @param num1被除数 | num2除数
     */
    function numDiv(num1, num2) {
        var baseNum1 = 0, baseNum2 = 0;
        var baseNum3, baseNum4;
        var baseNum5;
        try {
            baseNum1 = num1.toString().split(".")[1].length;
        } catch (e) {
            baseNum1 = 0;
        }
        try {
            baseNum2 = num2.toString().split(".")[1].length;
        } catch (e) {
            baseNum2 = 0;
        }
        with (Math) {
            baseNum3 = Number(num1.toString().replace(".", ""));
            baseNum4 = Number(num2.toString().replace(".", ""));
            baseNum5 = (baseNum3 / baseNum4) * pow(10, baseNum2 - baseNum1);
            return baseNum5;
        }
    };

    function deleteALLSelectSelf(title, url, gname, deleteCallback) {
        gridname = gname;
        var ids = [];
        var rows = $("#priceDetailList").datagrid('getSelections');
        if (rows.length > 0) {
            getSafeJq().dialog.confirm("你确定永久删除该数据吗?", function (r) {
                if (r) {
                    for (var i = 0; i < rows.length; i++) {
                        ids.push(rows[i].id);
                    }
                    $.ajax({
                        url: url,
                        type: 'post',
                        dataType: 'json',
                        data: {
                            ids: ids.join(',')
                        },
                        cache: false,
                        success: function (data) {
                            var msg = data.msg;
                            if (data.success) {
                                ids = '';
                                for (var i = rows.length - 1; i >= 0; i--) {
                                    var index = $("#priceDetailList").datagrid("getRowIndex", rows[i]);
                                    $("#priceDetailList").datagrid("deleteRow", index);
                                }
                            } else {
                                tip(msg, 'error');

                            }
                        },
                        error: function () {
                            tip("客户端请求错误", 'error');
                            return false;
                        }
                    });
                }
            });
        } else {
            tip("请选择需要删除的数据");
        }
    }
    var tempId = "";
    function detailExcel() {
        tempId = generateUUID();

        <c:if test="${not empty importUploadUrl}">
        var data = ${importUploadUrl};
        data.strExtend1 = tempId;
        importExcel(data,impot)
        </c:if>
    }

    function impot() {
        $.ajax({
            url: "/act/ttActPriceController/findExcelDetail",
            type: "post",
            dataType: "json",
            data: "tempId="+tempId,
            success: function (res) {
                if(res.success){
                    tempId = generateUUID();
                    var list = res.objList;
                    if(list&&list.length>0){
                        for(var i=0;i<list.length;i++){
                            $('#priceDetailList').datagrid('insertRow', {
                                index: 0,
                                row: list[i]
                            });
                        }
                    }
                }else{
                    tip(res.msg);
                }
            }
        });
    }

</script>

