<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>价格活动明细添加</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        .form-group {
            padding: 10px 10px 0 10px;
            box-sizing: border-box;
        }

        .form-input label {
            display: inline-block;
            width: 130px;
            text-align: right;
            line-height: 24px;
        }

        .form-input input {
            height: 24px;
            border: 1px solid #ddd;
            -moz-border-radius: 2px;
            -webkit-border-radius: 2px;
            border-radius: 2px;
            outline: none;
            padding: 3px 2px;
            width: 150px;
            box-sizing: border-box;
        }
    </style>
</head>
<body class="easyui-layout">
<div data-options="region:'center'" class="flex flex-column">
    <input type="hidden" id="categoriesCode" value="${categoriesCode}">
    <input type="hidden" id="budgetCode" value="${budgetCode}">
    <input type="hidden" id="startTime" value="${startTime}">
    <div class="form-group flex-none">
        <div class="flex flex-align-items-center mb10">
            <div class="form-input flex-1">
                <label>促销类型: <span style="color:red;">*</span></label>
                <t:dictSelect field="actDetailType" id="actDetailType" dataType="*" type="select"
                              typeGroupCode="act_detail_type">
                </t:dictSelect>
            </div>
            <div class="form-input flex-1">
                <label>价格维度: <span style="color:red;">*</span></label>
                <t:dictSelect field="actPriceDetailDimension" id="actPriceDetailDimension" dataType="*" type="select"
                              typeGroupCode="act_price_detail_dimension">
                </t:dictSelect>
            </div>
            <div class="form-input flex-1" id="selectselectPriceAttributeNone">

            </div>
            <div class=" flex-1" style="display: none" id="selectPriceAttribute">
                <label>
                    属性:
                </label>
                <input name="priceAttribute" type="radio" value="1"/>单客户&nbsp;&nbsp;
                <input name="priceAttribute" type="radio" value="0"/>多客户
            </div>
        </div>
    </div>
    <div class="iframe-content flex-auto">
        <iframe id="priceIframe" frameborder=0 width="100%" height="100%"
                src="/page/ttActPriceController/goAddActDetailForOne?startTime=${startTime}&page=buyProductForm&load=${load}&categoriesCode=${categoriesCode}&budgetCode=${budgetCode}&clickFunctionId=${clickFunctionId}"></iframe>
    </div>
</div>
<script>
    $(function () {
        $("#actDetailType").attr("style", "width : 145px");
        $("#actDetailType").change(function () {
            changeSelect();
        });
        $("#actPriceDetailDimension").change(function () {
            changeSelect();
        });
        $("#actPriceDetailDimension").change(function () {
            changeSelect();
        });
        $('input[type=radio][name=priceAttribute]').change(function () {
            changeSelect();
        });
        var edit = '${edit}';
        if (edit == '0') {
            var rows = getPaData();
            var actDetailType = rows[0].actDetailType;
            $("#actDetailType").val(actDetailType);
            var actPriceDetailDimension = rows[0].actPriceDetailDimension;
            $("#actPriceDetailDimension").val(actPriceDetailDimension);
            $('input[name=priceAttribute][value="' + rows[0].priceAttribute + '"]').attr("checked", true);
            changeSelect();
        }
    });

    function getPaData() {
        //编辑状态 初始化数据
        var api = frameElement.api, W = api.opener;
        var rows = W.getSelectsRows();
        return rows;
    }

    function changeSelect() {
        var categoriesCode = $("#categoriesCode").val();
        var startTime = $("#startTime").val();
        var budgetCode = $("#budgetCode").val();
        var priceAttribute = $('input:radio[name="priceAttribute"]:checked').val();
        let actDetailType = $("#actDetailType").val();
        let actPriceDetailDimension = $("#actPriceDetailDimension").val();
        let value = ""
        if (actPriceDetailDimension == "product_customer") {
            $("#selectPriceAttribute").show();
            $("#selectselectPriceAttributeNone").hide();
            if (priceAttribute == "1" || typeof (priceAttribute) == "undefined") {
                value = actDetailType + "_" + actPriceDetailDimension;//单客户
            } else {
                value = actDetailType + "_" + actPriceDetailDimension + "_morecust";//多客户
            }
        } else {
            $("#selectPriceAttribute").hide();
            $("#selectselectPriceAttributeNone").show();
            value = actDetailType + "_" + actPriceDetailDimension;
        }
        var clickFunctionId = '${clickFunctionId}';
        switch (value) {
            case "buy_product"://买赠：产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=buyProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId);
                break;
            case "buy_product_group"://买赠：产品+价格组
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=buyGroupProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId);
                break;
            case "buy_product_customer"://买赠：产品+客户
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=buyCustomerProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&priceAttribute=" + priceAttribute + "&clickFunctionId=" + clickFunctionId);
                break;
            case "buy_product_customer_morecust"://买赠：产品+多客户
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=buyCustomerProductMoreCustForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&priceAttribute=" + priceAttribute + "&clickFunctionId=" + clickFunctionId);
                break;
            case "buy_product_term"://买赠：产品+门店
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=buyDeptProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId);
                break;
            case "special_product"://特价：产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=specialProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId);
                break;
            case "special_product_group"://特价：价格组+产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=specialGroupProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId);
                break;
            case "special_product_customer"://特价：客户+产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=specialCustomerProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&priceAttribute=" + priceAttribute + "&clickFunctionId=" + clickFunctionId);
                break;
            case "special_product_customer_morecust"://特价：多客户+产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=specialCustomerProductMoreCustForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&priceAttribute=" + priceAttribute + "&clickFunctionId=" + clickFunctionId);
                break;
            case "special_product_term"://特价：门店+产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=specialDeptProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId);
                break;
            case "discount_product"://折价：产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=discountProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId);
                break;
            case "discount_product_customer"://折价：客户+产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=discountCustomerProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&priceAttribute=" + priceAttribute + "&clickFunctionId=" + clickFunctionId);
                break;
            case "discount_product_customer_morecust"://折价：多客户+产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=discountCustomerProductMoreCustForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&priceAttribute=" + priceAttribute + "&clickFunctionId=" + clickFunctionId);
                break;
            case "discount_product_group"://折价：价格组+产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=discountGroupProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId);
                break;
            case "discount_product_term"://折价：门店+产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=discountDeptProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId);
                break;
            case "fullreduce_product"://满减：产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=fullreduceProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId);
                break;
            case "fullreduce_product_customer"://满减：客户+产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=fullreduceCustomerProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&priceAttribute=" + priceAttribute + "&clickFunctionId=" + clickFunctionId);
                break;
            case "fullreduce_product_customer_morecust"://满减：多客户+产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=fullreduceCustomerProductMoreCustForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&priceAttribute=" + priceAttribute + "&clickFunctionId=" + clickFunctionId);
                break;
            case "fullreduce_product_group"://满减：价格组+产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=fullreduceGroupProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId);
                break;
            case "fullreduce_product_term"://满减：门店+产品
                $("#priceIframe").attr("src", "/page/ttActPriceController/goAddActDetailForOne?startTime="+startTime+"&page=fullreduceDeptProductForm&load=${load}&edit=${edit}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId);
                break;
        }
    }

    function saveData() {
        let priceIframe = $("#priceIframe")[0];
        var data = priceIframe.contentWindow.createData();
        return data;
    }

    function getActDetailType() {
        return $("#actDetailType").val();
    }

</script>
</body>
</html>