<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>费用上账明细详情</title>
    <t:base type="jquery,easyui,tools"  extendUrlKey="accountInvoiceUpdateForm"></t:base>
    <style>
        #content{
            padding: 0 0 10px 0;
        }
    </style>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid action="" layout="div"  dialog="true" formid="invoiceForm">
    <t:dgFormList >
        <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                        />
        <t:dgFormColumn field="budgetSubjectsCode" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                        />
        <t:dgFormColumn field="custCode" hidden="true" formClass="form" labelName="客户编码" optionType="input" required="false"
                        defaultVal="${vo.custCode }"/>
        <t:dgFormColumn field="custName" hidden="false" formClass="form" readOnly="true" labelName="客户名称" optionType="input" required="false"
                        defaultVal="${vo.custName }"/>
        <t:dgFormColumn field="accountBudgetSubjectsCode" hidden="false" formClass="form" labelName="上账科目编码" optionType="choseDialog" required="true"
                         onclick="goSbudgetSubjects();" onClean="cleanSbudgetSubjects()" readOnly="true" />
        <t:dgFormColumn field="accountBudgetSubjectsName" hidden="false" formClass="form" labelName="上账科目名称" optionType="input" required="false"
                         readOnly="true" />
        <t:dgFormColumn field="accountCode" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                        />
        <t:dgFormColumn field="invoiceCode" hidden="false" formClass="form" labelName="发票编号" optionType="input" required="true"
                        />
        <t:dgFormColumn field="taxCode" hidden="false" formClass="form" labelName="税码" typeGroupCode="tax_code"  optionType="select" required="false"
                        />
        <t:dgFormColumn field="invoiceAmount" hidden="false" formClass="form" labelName="发票金额" optionType="input" required="true"
        />
        <t:dgFormColumn field="taxAmount" hidden="false" formClass="form" labelName="税金" readOnly="true" optionType="input" required="true"
                        />

        <t:dgFormColumn field="notes" hidden="false"  formClass="form"
                        labelName="摘要" optionType="textarea" rows="3" cols="50" required="false"/>
    </t:dgFormList>
</t:formvalid>
</body>
</html>
<script>
    $(function () {
        $("#invoiceAmount").blur(function () {
            countTaxAmount();
        });
        $("#taxCode").change(function () {
            countTaxAmount();
        });

        var rows = frameElement.api.opener.getDataEditDetail();
        $("#id").val(rows[0].id);
        $("#budgetSubjectsCode").val(rows[0].budgetSubjectsCode);
        $("#accountBudgetSubjectsCode").val(rows[0].accountBudgetSubjectsCode);
        $("#accountBudgetSubjectsName").val(rows[0].accountBudgetSubjectsName);
        $("#accountCode").val(rows[0].accountCode);
        $("#invoiceCode").val(rows[0].invoiceCode);
        $("#taxCode").val(rows[0].taxCode);
        $("#taxAmount").val(rows[0].taxAmount);
        $("#invoiceAmount").val(rows[0].invoiceAmount);
        $("#notes").val(rows[0].notes);
        $("#custCode").val(rows[0].custCode);
        $("#custName").val(rows[0].custName);
    });


    //计算税金
    function countTaxAmount() {
        var taxAmount = 0;
        var invoiceAmount = $("#invoiceAmount").val();
        var taxCode = $("#taxCode").val();
        if(isEmpty(invoiceAmount)||isEmpty(taxCode)){
            taxAmount = 0;
        }else {
            try {
                invoiceAmount = Number(invoiceAmount);
                taxCode = Number(taxCode);
                taxAmount = (invoiceAmount*taxCode).toFixed(2);
            }catch (e) {
                taxAmount = 0;
            }
        }
        $("#taxAmount").val(taxAmount);
    }

    /* 收集数据 */
    function getData() {
        var data = {};
        data.invoiceCode = $("#invoiceCode").val();
        data.budgetSubjectsCode = $("#budgetSubjectsCode").val();
        data.accountBudgetSubjectsCode = $("#accountBudgetSubjectsCode").val();
        data.accountBudgetSubjectsName = $("#accountBudgetSubjectsName").val();
        data.taxCode = $("#taxCode").val();
        data.taxAmount = $("#taxAmount").val();
        data.invoiceAmount = $("#invoiceAmount").val();
        data.notes = $("#notes").val();
        data.accountCode = $("#accountCode").val();
        return data;
    }

    function cleanSbudgetSubjects() {
        $("#accountBudgetSubjectsCode").val("");
        $("#accountBudgetSubjectsName").val("");
    }

    /** 选择上账科目 */
    function goSbudgetSubjects(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        var budgetSubjectsCode = $("#budgetSubjectsCode").val();
        triggerId = "accountBudgetSubjectsCode";
        triggerName = "accountBudgetSubjectsName";
        url = "/page/ttApiBudgetController/goAccountBudgetSubjects?budgetSubjectsCode="+budgetSubjectsCode;
        width = 1000;
        height = 450;
        id = "budgetSubjectsList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetSubjectsCode);
                    $("#" + triggerName).val(myobj[0].budgetSubjectsName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

</script>
