<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery"></t:base>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
</head>

<body>
<div id="app" v-cloak>
    <input id="headId" type="hidden" value="${headId}">
        <div ref="timesLine" style="width: 100%;height:400px;box-sizing: border-box;"></div>
        <div ref="successPipe" style="width: 100%;height:400px;box-sizing: border-box;"></div>
        <div ref="responseLine" style="width: 100%;height:400px;box-sizing: border-box;"></div>
</div>

<script src="/resources/tools/vue.min.js"></script>
<script src="/resources/echarts/echarts.min.js"></script>

<script>
    var vm = new Vue({
        el: "#app",
        name: "",
        data: function () {
            return {
                pageData:{},
                timesLine: null,
                successPipe: null,
                responseLine: null
            }
        },
        created: function () {

        },
        mounted: function () {
          this.loadData();
        },
        methods: {
            loadData:function(){
                var this_ = this;
                $.ajax({
                    url:"/kernel/knlRequestRecordController/getRequestRecord",
                    type:"post",
                    dataType:"json",
                    data:{headId:'${headId}'},
                    success:function (res) {
                        if(res.success){
                            this_.pageData = res.obj;
                            this_.initTimesLine();
                            this_.initSuccessPipe();
                            this_.initResponseLine();
                        }
                    }
                })
            },
            initTimesLine: function () {
                this.timesLine = echarts.init(this.$refs.timesLine);
                var option = {
                    title: {
                        text: "接口访问次数实时数据",
                        x: 'center'
                    },
                    tooltip: {
                        trigger: 'axis'
                    },
                    xAxis: {
                        type: 'category',
                        data: this.pageData.timeArray
                    },
                    yAxis: {
                        type: 'value'
                    },
                    series: [{
                        data: this.pageData.countArray,
                        type: 'line',
                        smooth: true,
                        lineStyle: {
                            color: "#1890ff",
                        }
                    }]
                };
                this.timesLine.setOption(option);
            },
            initSuccessPipe: function () {
                this.successPipe = echarts.init(this.$refs.successPipe);
                var option = {
                    title: {
                        text: "接口访问响应情况",
                        x: 'center'
                    },
                    color: ['#33b62e', 'red'],
                    legend: {
                        orient: 'vertical',
                        x: '70%',
                        y: 'center',
                        data: ['成功数', '失败数']
                    },
                    series: [{
                        name: '',
                        type: 'pie',
                        center: ['50%', '50%'],
                        data: [{
                            value: this.pageData.successCount,
                            name: '成功数',
                        },
                            {
                                value: this.pageData.failedCount,
                                name: '失败数'
                            }
                        ]
                    }]
                };

                this.successPipe.setOption(option);
            },
            initResponseLine: function () {
                this.responseLine = echarts.init(this.$refs.responseLine);
                var option = {
                    title: {
                        text: "接口响应时间监控",
                        x: 'center'
                    },
                    tooltip: {
                        trigger: 'axis'
                    },
                    xAxis: {
                        type: 'category',
                        data: this.pageData.requestCountArray
                    },
                    yAxis: {
                        type: 'value'
                    },
                    series: [{
                        data: this.pageData.requestTimeArray,
                        type: 'line',
                        smooth: true,
                        lineStyle: {
                            color: "#1890ff",
                        }
                    }]
                };
                this.responseLine.setOption(option);
            },
        }
    })
</script>
</body>

</html>