<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0,maximum-scale=1.0, user-scalable=0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>传阅提交</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            font-size: 14px;
        }

        .communite-content {
            width: 100%;
            box-sizing: border-box;
            resize: none;
            border-radius: 5px;
        }

        .submmit-btn {
            position: absolute;
            bottom: 0;
            border: none;
            background: #1890ff;
            color: #fff;
            width: 100%;
            height: 35px;
            line-height: 35px;
        }

        .submmit-btn:active {
            opacity: .8;
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="p10">
        <textarea v-model="content" class="communite-content" rows="10" placeholder="请输入内容"></textarea>
    </div>
    <button class="submmit-btn" @click="submit">提交</button>
</div>

<script src="/resources/sfa/js/vue.min.js"></script>
<script src="/resources/sfa/js/common.js"></script>
<script src="/resources/sfa/js/jquery.min.js"></script>

<script>
    function pop(step) {
        js.pop(step);
    }

    function backPop(step) {
        var u = navigator.userAgent;
        var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
        var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
        if (isAndroid) {
            pop(step);
        }
        if (isiOS) {
            window.webkit.messageHandlers.pop.postMessage(step);
        }
    }

    var vm = new Vue({
        el: "#app",
        name: "",
        data: function () {
            return {
                token: "",
                processInstanceId: "",
                ids: "",
                content: ""
            }
        },
        created: function () {
            this.token = getParameterByName("token");
            this.processInstanceId = getParameterByName("processInstanceId");
            this.ids = getParameterByName("ids");
        },
        methods: {
            submit: function () {
                let this_ = this;
                $.ajax({
                    url: "/activiti/taTaskMobileController/saveCirculationMobile",
                    type: "post",
                    dataType: "json",
                    data: {
                        processInstanceId: this.processInstanceId,
                        ids: this.ids,
                        content: this.content
                    },
                    headers: {
                        'loginUserToken': this_.token
                    },
                    success: function (res) {
                        if (res.success) {
                            backPop(3);
                        } else {
                            showError(res.msg);
                        }
                    }
                })
            },
        }
    })
</script>
</body>

</html>