<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="coding_rules_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="codeList" tagConf="${clickFunctionId}" idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/kernel/knlCodingRulesController/findKnlCodingRulesPage" pagination="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="业务key" field="codingRuleCode" dictionary="business_key" query="true"></t:dgCol>
            <t:dgCol title="前缀" field="prefix" query="true"></t:dgCol>
            <t:dgCol title="时间" field="dateStr" query="true"></t:dgCol>
            <t:dgCol title="长度" field="codeLength"></t:dgCol>
            <t:dgCol title="规则描述" field="ruleDescription" query="true"></t:dgCol>
            <t:dgCol title="起始值" field="initialValue"></t:dgCol>
            <t:dgCol title="当前值" field="currentValue"></t:dgCol>
            <t:dgCol title="生成时间" field="generationTime" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <t:dgCol title="创建人" field="createName"></t:dgCol>
            <t:dgCol title="创建时间" field="createDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <t:dgCol title="最近更新人" field="updateName" treefield="updateName"></t:dgCol>
            <t:dgCol title="最近更新时间" field="updateDate" treefield="updateDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>

            <t:dgToolBar operationCode="add" title="添加" icon="icon-add" url="/page/knlCodingRulesController/goSaveOrUpdateCodingRules"
                         funname="add" width="400" height="400"></t:dgToolBar>
            <t:dgToolBar operationCode="edit" title="修改" icon="icon-edit" url="/page/knlCodingRulesController/goSaveOrUpdateCodingRules"
                         funname="update" width="400" height="400"></t:dgToolBar>
            <t:dgToolBar operationCode="log" title="日志" icon="icon-log" url="/page/knlLogController/goShowLog"
                         width="1000" height="500"     funname="detail"></t:dgToolBar>
            <t:dgToolBar operationCode="reset" title="重置当前值" icon="icon-edit" url=""
                         funname="resetCurrentValue" width="380" height="200"></t:dgToolBar>

        </t:datagrid>
    </div>
</div>

<script>
    function resetCurrentValue() {
        var rowsDatas = $('#codeList').datagrid('getSelections');
        if(rowsDatas.length!=1){
            tip("请选择一条数据操作");
            return;
        }
        $.ajax({
            url:"/kernel/knlCodingRulesController/resetCurrentValue",
            dataType:"json",
            async:true,
            data:{"id":rowsDatas[0].id},
            type:"POST",
            success:function(req){
                tip(req.msg);
                if(req.success){
                    $("#codeList").datagrid("reload");
                }
            }
        });
    }
    
</script>
