<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools"></t:base>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title></title>
    <link rel="stylesheet" href="/resources/tools/css/common.css">
    <style>
        body {
            padding: 0;
            margin: 0;
        }

        .dynamic-interface {
            padding: 20px;
        }

        .interface-tab {
            height: 30px;
            line-height: 30px;
            font-size: 14px;
            padding: 0 15px;
            border: 1px solid #d8d8d8;
            background: #ffffff;
            color: #0F467C;
            transition: all .3s;
            cursor: pointer;
        }

        .interface-tab:first-child {
            border-radius: 5px 0 0 5px;
        }

        .interface-tab:last-child {
            border-left: 0;
            border-radius: 0 5px 5px 0;
        }

        .interface-tab.tab-active {
            background: #0F467C;
            color: #ffffff;
        }

        .form-field {
            margin-top: 10px;
        }

        .form-field label {
            width: 100px;
            text-align: right;
            font-size: 13px;
        }

        .form-field input {
            width: 200px;
            height: 24px;
            line-height: 24px;
            border-radius: 4px;
            border: 1px solid #D2D2D2;
            box-sizing: border-box;
            padding: 0 15px;
            margin-left: 10px;
            font-size: 13px;
        }

        .form-field a {
            height: 24px;
            line-height: 24px;
            border-radius: 4px;
            border: 1px solid #D2D2D2;
            box-sizing: border-box;
            padding: 3px 15px;
            margin-left: 10px;
            font-size: 13px;
            text-decoration: none;
            color: #0F467C;
        }

        .form-field select {
            width: 200px;
            height: 24px;
            line-height: 24px;
            border-radius: 4px;
            border: 1px solid #D2D2D2;
            box-sizing: border-box;
            padding: 0 10px;
            margin-left: 10px;
            font-size: 13px;
        }

        .paramas-body {
            margin-top: 10px;
            margin-left: 110px;
            width: 600px;
            height: 300px;
        }

        .paramas-body textarea {
            width: 100%;
            height: 100%;
            box-sizing: border-box;
            border: 1px solid #d8d8d8;
        }

        .paramas-table {
            width: 600px;
            margin-top: 10px;
            margin-left: 110px;
        }

        table {
            width: 100%;
            table-layout: fixed;
            border-collapse: collapse;
        }

        table td,
        table th {
            box-sizing: border-box;
            border: 1px solid #d8d8d8;
            height: 30px;
            line-height: 30px;
            font-size: 13px;
            white-space: nowrap;
        }

        table tbody td input {
            width: 100%;
            height: 30px;
            line-height: 30px;
            border: none;
            box-sizing: border-box;
            padding: 0 15px;
            font-size: 13px;
        }

        table tbody td select {
            width: 100%;
            height: 30px;
            line-height: 30px;
            border: none;
            box-sizing: border-box;
            padding: 0 15px;
            font-size: 13px;
        }
        .submit-request{
            margin-left: 350px;
        }
        .submit-btn{
            margin-top: 20px;
            color: #fff;
            background: #0D3349;
            width: 100px;
            height: 32px;
            font-size: 14px;
            border: none;
            outline: none;
            border-radius: 5px;
        }
    </style>
</head>

<body>
<input id="headId" value="${id}" type="hidden"/>
<div id="app" v-cloak>
    <div class="dynamic-interface">
        <div class="interface-tabs flex">
            <div class="interface-tab" :class="activeTab==='request'?'tab-active':''"
                 @click="handleTabs('request')">请求参数
            </div>
            <div class="interface-tab" :class="activeTab==='response'?'tab-active':''"
                 @click="handleTabs('response')">响应参数
            </div>
        </div>
        <div v-show="activeTab==='request'">
            <div class="form-field flex flex-align-items-center">
                <label>请求方式</label>
                <div>
                    <select v-model="requestObject.requestType">
                        <option value="GET">GET</option>
                        <option value="POST">POST</option>
                        <option value="PUT">PUT</option>
                        <option value="DELETE">DELETE</option>
                    </select>
                </div>
            </div>
            <div class="form-field flex flex-align-items-center">
                <label>请求体</label>
                <div>
                    <select v-model="requestObject.body">
                        <option value="x-www-form-urlencoded">x-www-form-urlencoded</option>
                        <option value="raw">raw</option>
                    </select>
                </div>
            </div>
            <div class="form-field flex flex-align-items-center">
                <label>请求地址</label>
                <div>
                    <input type="text" v-model="requestObject.requestUrl" style="width: 600px;">
                </div>
            </div>
            <div class="request-params">
                <div class="form-field flex flex-align-items-center" v-if="requestObject.body==='raw'">
                    <label>拓展请求参数</label>
                    <div>
                        <input type="text" v-model="requestObject.extendParams" style="width: 600px;">
                    </div>
                </div>
                <div class="form-field flex flex-align-items-center">
                    <label>请求参数</label>
                    <div v-if="requestObject.body!=='raw'">
                        <a href="javascript:void(0)" @click="addParams">新增</a>
                    </div>
                </div>
                <div class="paramas-table" v-if="requestObject.body!=='raw'">
                    <table>
                        <thead>
                        <tr>
                            <th>属性</th>
                            <th>值</th>
                            <th>拓展</th>
                            <th>描述</th>
                            <th width="80px">操作</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(p,index) in requestObject.paramsArray" :key="index">
                            <td><input v-model="p.key" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.value" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.extra" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.des" type="text" placeholder="请输入"></td>
                            <td style="text-align: center;">
                                <span @click="removeParams(index)">移除</span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <div class="paramas-body" v-else>
                    <textarea v-model="requestObject.paramString"></textarea>
                </div>
            </div>
            <div class="request-headers">
                <div class="form-field flex flex-align-items-center">
                    <label>请求头</label>
                    <div>
                        <a href="javascript:void(0)" @click="addHeaders">新增</a>
                    </div>
                </div>
                <div class="paramas-table">
                    <table>
                        <thead>
                        <tr>
                            <th>属性</th>
                            <th>值</th>
                            <th>拓展</th>
                            <th>描述</th>
                            <th width="80px">操作</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(p,index) in requestObject.headersArray" :key="index">
                            <td><input v-model="p.key" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.value" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.extra" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.des" type="text" placeholder="请输入"></td>
                            <td style="text-align: center;">
                                <span @click="removeHeaders(index)">移除</span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="response-body">
                <div class="form-field flex flex-align-items-center">
                    <label>响应值</label>
                </div>
                <div class="paramas-body">
                    <textarea id="responseMsg"></textarea>
                </div>
            </div>
            <div class="submit-request">
                <button class="submit-btn" @click="submitRequestSave">保存</button>
                <button class="submit-btn" @click="submitRequestTest">测试</button>
            </div>
        </div>
        <div v-show="activeTab==='response'">
            <div class="level-one">
                <div class="form-field flex flex-align-items-center">
                    <label>一级参数</label>
                    <div>
                        <a href="javascript:void(0)" @click="addLevel('levelOne')">新增</a>
                    </div>
                </div>
                <div class="paramas-table">
                    <table>
                        <thead>
                        <tr>
                            <th style="display: none;">id</th>
                            <th>属性</th>
                            <th>值类型</th>
                            <th>值拓展</th>
                            <th>描述</th>
                            <th width="80px">操作</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(p,index) in responseObject.levelOne" :key="index">
                            <td style="display: none;"><input v-model="p.id" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.attribute" type="text" placeholder="请输入"></td>
                            <td>
                                <select v-model="p.valueType">
                                    <option value="String">String</option>
                                    <option value="Object">Object</option>
                                    <option value="Array">Array</option>
                                    <option value="Boolean">Boolean</option>
                                </select>
                            </td>
                            <td><input v-model="p.valueExtend" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.description" type="text" placeholder="请输入"></td>
                            <td style="text-align: center;">
                                <span @click="removeLevel(index,'levelOne')">移除</span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="level-two">
                <div class="form-field flex flex-align-items-center">
                    <label>二级参数</label>
                    <div>
                        <a href="javascript:void(0)" @click="addLevel('levelTwo')">新增</a>
                    </div>
                </div>
                <div class="paramas-table">
                    <table>
                        <thead>
                        <tr>
                            <th style="display: none;">id</th>
                            <th>属性</th>
                            <th>值类型</th>
                            <th>上级属性</th>
                            <th>值拓展</th>
                            <th>描述</th>
                            <th width="80px">操作</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(p,index) in responseObject.levelTwo" :key="index">
                            <td style="display: none;"><input v-model="p.id" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.attribute" type="text" placeholder="请输入">
                            </td>
                            <td>
                                <select v-model="p.valueType">
                                    <option value="String">String</option>
                                    <option value="Object">Object</option>
                                    <option value="Array">Array</option>
                                    <option value="Boolean">Boolean</option>
                                </select>
                            </td>
                            <td><input v-model="p.superAttribute" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.valueExtend" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.description" type="text" placeholder="请输入">
                            </td>
                            <td style="text-align: center;">
                                <span @click="removeLevel(index,'levelTwo')">移除</span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="level-three">
                <div class="form-field flex flex-align-items-center">
                    <label>三级参数</label>
                    <div>
                        <a href="javascript:void(0)" @click="addLevel('levelThree')">新增</a>
                    </div>
                </div>
                <div class="paramas-table">
                    <table>
                        <thead>
                        <tr>
                            <th style="display: none;">id</th>
                            <th>属性</th>
                            <th>值类型</th>
                            <th>上级属性</th>
                            <th>值拓展</th>
                            <th>描述</th>
                            <th width="80px">操作</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(p,index) in responseObject.levelThree" :key="index">
                            <td style="display: none;"><input v-model="p.id" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.attribute" type="text" placeholder="请输入"></td>
                            <td>
                                <select v-model="p.valueType">
                                    <option value="String">String</option>
                                    <option value="Object">Object</option>
                                    <option value="Array">Array</option>
                                    <option value="Boolean">Boolean</option>
                                </select>
                            </td>
                            <td><input v-model="p.superAttribute" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.valueExtend" type="text" placeholder="请输入"></td>
                            <td><input v-model="p.description" type="text" placeholder="请输入"></td>
                            <td style="text-align: center;">
                                <span @click="removeLevel(index,'levelThree')">移除</span>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="submit-request">
                <button class="submit-btn" @click="submitResponse">保存</button>
            </div>
        </div>
    </div>
</div>

<script src="/resources/tools/vue.min.js"></script>

<script>
    var vm = new Vue({
        el: "#app",
        name: "",
        data: function () {
            return {
                id:$("#headId").val(),
                activeTab: "request",
                requestObject: {
                    requestType: "POST",
                    body: "x-www-form-urlencoded",
                    paramsArray: [],
                    paramString: "",
                    headersArray: []
                },
                responseObject: {
                    levelOne: [],
                    levelTwo: [],
                    levelThree: []
                }
            }
        },
        created: function () {
            this.id?this.loadData():"";
        },
        computed: {},
        methods: {
            loadData: function () {
                var this_ = this;
                $.ajax({
                    url: "/kernel/knlPostRequestController/getKnlPostTable",
                    type: "post",
                    dataType: "json",
                    data: {id: this.id},
                    success: function (res) {
                        if (res.success) {
                            this_.requestObject = $.extend({},res.obj.knlPostRequestEntity,{paramsArray:JSON.parse(res.obj.knlPostRequestEntity.params),headersArray:JSON.parse(res.obj.knlPostRequestEntity.headers)});
                            this_.responseObject = res.obj.responseJson;
                        }
                    }
                })
            },
            handleTabs: function (tab) {
                var headId = $("#headId").val();
                if (headId == "") {
                    tip("请先提交请求参数");
                    return false;
                }
                this.activeTab = tab;
            },
            addParams: function () {
                let newParams = {
                    key: "",
                    value: "",
                    extra: "",
                    des: ""
                };
                this.requestObject.paramsArray.push(newParams);
            },
            removeParams: function (index) {
                this.requestObject.paramsArray.splice(index, 1);
            },
            addHeaders: function () {
                let newHeaders = {
                    key: "",
                    value: "",
                    extra: "",
                    des: ""
                };
                this.requestObject.headersArray.push(newHeaders);
            },
            removeHeaders: function (index) {
                this.requestObject.headersArray.splice(index, 1);
            },
            addLevel: function (level) {
                let response = {
                    attribute: "",
                    valueType: "String",
                    superAttribute: "",
                    valueExtend: "",
                    description: "",
                    headId:$("#headId").val()
                };
                this.responseObject[level].push(response);
            },
            removeLevel: function (index, level) {
                this.responseObject[level].splice(index, 1);
            },
            submitRequestSave: function () {
                if (this.requestObject.body === "raw") {
                    this.requestObject["params"] = this.requestObject.paramString;
                } else {
                    this.requestObject['params'] = JSON.stringify(this.requestObject.paramsArray);
                }
                this.requestObject['headers'] = JSON.stringify(this.requestObject.headersArray);
                console.log(this.requestObject);
                $.ajax({
                    url: "/kernel/knlPostRequestController/saveRequest",
                    type: "post",
                    dataType: "json",
                    contentType: "application/json",
                    data: JSON.stringify(this.requestObject),
                    success: function (res) {
                        tip(res.msg);
                        if (res.success) {
                            $("#headId").val(res.flagId);
                            // $("#responseMsg").val(res.obj);
                        }
                    }
                })
            },
            submitRequestTest: function () {
                if (this.requestObject.body === "raw") {
                    this.requestObject["params"] = this.requestObject.paramString;
                } else {
                    this.requestObject['params'] = JSON.stringify(this.requestObject.paramsArray);
                }
                this.requestObject['headers'] = JSON.stringify(this.requestObject.headersArray);
                console.log(this.requestObject);
                $.ajax({
                    url: "/kernel/knlPostRequestController/sendPostRequest",
                    type: "post",
                    dataType: "json",
                    contentType: "application/json",
                    data: JSON.stringify(this.requestObject),
                    success: function (res) {
                        tip(res.msg);
                        if (res.success) {
                            // $("#headId").val(res.flagId);
                            $("#responseMsg").val(res.obj);
                        }
                    }
                })
            },
            submitResponse: function () {
                console.log(this.responseObject);
                $.ajax({
                    url: "/kernel/knlResponseController/saveResponse",
                    type: "post",
                    dataType: "json",
                    contentType: "application/json",
                    data: JSON.stringify(this.responseObject),
                    success: function (res) {
                        tip(res.msg);
                    }
                })
            }
        }
    })
</script>
</body>

</html>