<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>预算变更</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        input[readonly]{
            background: #efefef;
        }
    </style>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid action="/budget/ttFeeBudgetController/updateAmount" layout="div"  dialog="true" formid="fiscalForm">
    <t:dgFormList>
        <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                        defaultVal="${vo.id }"/>
        <t:dgFormColumn field="budgetCode" hidden="false" dataType="*"  formClass="form"
                        defaultVal="${vo.budgetCode}" readOnly="true"
                        labelName="预算编码" optionType="input" required="false" />
        <t:dgFormColumn field="subjectsGroupName" hidden="false"   formClass="form"
                        defaultVal="${vo.subjectsGroupName}" readOnly="true"
                        labelName="分组" optionType="input" required="false" />
        <t:dgFormColumn field="budgetYear" hidden="false" formClass="form" labelName="年份" optionType="input" required="false"
                        defaultVal="${vo.budgetYear}" readOnly="true"/>
        <t:dgFormColumn field="budgetMonth" hidden="false" dataType="*" typeGroupCode="month" formClass="form"
                        defaultVal="${vo.budgetMonth}" readOnly="true"
                        labelName="月份" optionType="select" required="false" />
        <t:dgFormColumn field="budgetDepartName" hidden="false"  formClass="form"
                        defaultVal="${vo.budgetDepartName}" readOnly="true"
                        labelName="组织" optionType="input" required="false" />
        <t:dgFormColumn field="budgetSubjectsCode" hidden="true"   formClass="form"
                        defaultVal="${vo.budgetSubjectsCode}" readOnly="true"
                        labelName="科目编码" optionType="input" required="false" />
        <t:dgFormColumn field="budgetSubjectsName" hidden="false" formClass="form" labelName="科目" optionType="input" required="false"
                        defaultVal="${vo.budgetSubjectsName}" readOnly="true" />
        <t:dgFormColumn field="vkorgName" hidden="false"  formClass="form"
                        defaultVal="${vo.vkorgName}" readOnly="true"
                        labelName="渠道" optionType="input" required="false" />
        <t:dgFormColumn field="productName" hidden="false" readOnly="true" formClass="form" labelName="物料" optionType="input" required="false"
                        defaultVal="${vo.productName}"/>
        <t:dgFormColumn field="custCode" hidden="true" formClass="form" labelName="客户编码" optionType="input" required="false"
                        defaultVal="${vo.custCode}" readOnly="true"/>
        <t:dgFormColumn field="custName" hidden="false" formClass="form" readOnly="true" labelName="客户" optionType="input" required="false"
                        defaultVal="${vo.custName}" />
        <t:dgFormColumn field="initAmount" hidden="false"   formClass="form"
                        defaultVal="${vo.initAmount}" readOnly="true"
                        labelName="期初金额" optionType="input"  required="false" />
        <t:dgFormColumn field="amount" hidden="false"   formClass="form"
                        defaultVal="${vo.amount}" readOnly="true"
                        labelName="可用余额" optionType="input"  required="false" />
        <t:dgFormColumn field="changeType" hidden="false"   formClass="form"
                        defaultVal="additional" readOnly="true" typeGroupCode="budget_change_type"
                        labelName="变更类型" optionType="radio"  required="true" />
        <t:dgFormColumn field="amountUpdate" hidden="false"   formClass="form" readOnly="false"
                        labelName="变更金额" optionType="input"  required="true" />
        <t:dgFormColumn field="afterAmount" hidden="false"   formClass="form" readOnly="true"
                        labelName="变更后金额" optionType="input"  required="false" />
        <t:dgFormColumn field="notes" hidden="false" formClass="form" labelName="预算变更说明" required="false"
                        defaultVal="${vo.notes}" optionType="textarea" rows="2" cols="50"/>
    </t:dgFormList>
</t:formvalid>
</body>
<script type="text/javascript">

    $("#budgetMonth").attr("disabled","disabled");
    $("#amountUpdate").change(function () {
        countPrice();
    })
    function countPrice() {
        var amount = $("#amount").val();
        var amountUpdate = $("#amountUpdate").val();
        var changeType = $("input[name=changeType]:checked").val();
        if (changeType == "cutout"){
            var afterAmount = numSub(amount,amountUpdate);
            $("#afterAmount").val(afterAmount);
        } else if (changeType == "additional"){
            var afterAmount = numAdd(amount,amountUpdate);
            $("#afterAmount").val(afterAmount);
        }
    }

    function numSub(arg1, arg2) {
        var r1, r2, m, n;
        try { r1 = arg1.toString().split(".")[1].length } catch (e) { r1 = 0}
        try { r2 = arg2.toString().split(".")[1].length } catch (e) { r2 = 0}
        m = Math.pow(10, Math.max(r1, r2));
        n = (r1 >= r2) ? r1 : r2;
        return ((arg1 * m - arg2 * m) / m).toFixed(n);
    }

    function numAdd(num1, num2) {
        var baseNum, baseNum1, baseNum2;
        try {
            baseNum1 = num1.toString().split(".")[1].length;
        } catch (e) {
            baseNum1 = 0;
        }
        try {
            baseNum2 = num2.toString().split(".")[1].length;
        } catch (e) {
            baseNum2 = 0;
        }
        baseNum = Math.pow(10, Math.max(baseNum1, baseNum2));
        return (num1 * baseNum + num2 * baseNum) / baseNum;
    };

</script>

</html>