<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div class="easyui-layout" fit="true" style="width: 1000px">
    <div region="center" style="padding: 1px;width:1000px">
        <t:datagrid name="tmLogList" fitColumns="true" fit="true" title="日志列表"
                    actionUrl="logController.do?findTmLogList&businessId=${businessId}"
                    idField="id" queryMode="group" extendParams="nowrap:false">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="businessId" field="businessId" hidden="true"></t:dgCol>
            <t:dgCol title="业务描述" field="businessDesc" query="true" width="80"></t:dgCol>
            <t:dgCol title="操作类型" field="operationType" dictionary="operation_type" query="true" width="50"></t:dgCol>
            <t:dgCol title="更新内容" field="content" query="true" formatterjs="formatLog" width="300"></t:dgCol>
            <t:dgCol title="更新人姓名" field="createName" query="true" width="100"></t:dgCol>
            <%--<t:dgCol title="更新人职位" field="positionName" query="true" width="100"></t:dgCol>--%>
            <t:dgCol title="更新时间" field="createDate" formatter="yyyy-MM-dd HH:mm:ss" width="80"></t:dgCol>
            <t:dgToolBar title="导出" icon="icon-dataOut" url="export/logController.do?exportXls&businessId=${businessId}"
                         funname="excelExport"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>

<script>

    function formatLog(value, row) {
        try {
            var obj = JSON.parse(value);
            if (typeof obj == 'object' && obj) {
                return formatLogContent(value, row);
            } else {
                return value;
            }
        } catch (e) {
            return value;
        }
    }

    function formatLogContent(value, row) {
        var html = "";
        var d = $.parseJSON(value);
        if (d[0].filedName == null || d[0].filedName == "") {
            return value;
        }
        if (row.operationType == "INSERT") {
            for (var i in d) {
                html += "<b>&nbsp;[" + d[i].filedName + "]&nbsp;</b>新增值<b>&nbsp;[" + d[i].newData + "]&nbsp;</b><br>";
            }
            return html;
        }
        if (row.operationType == "UPDATE") {
            for (var i in d) {
                html += "<b>&nbsp;[" + d[i].filedName + "]" + "&nbsp;</b>从<b>&nbsp;[" + d[i].oldData + "]&nbsp;";
                if (d[i].oldData.length > 40) {
                    html += "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
                }
                html += "</b>修改为<b>&nbsp;[" + d[i].newData + "]&nbsp;</b><br>";
            }
            return html;
        }
        if (row.operationType == "DELETE") {
            for (var i in d) {
                html += "<b>&nbsp;[" + d[i].filedName + "]&nbsp;</b>值为<b>&nbsp;[" + d[i].oldData + "]&nbsp;</b>被删除<br>";
            }
            return html;
        }
        return value;
    }
</script>