<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker" extendUrlKey="payPolicyMain"></t:base>
<div class="easyui-layout" fit="true">
    <div region="center" style="padding:1px;">
        <t:datagrid name="payPolicyList" checkbox="true" singleSelect="false"  fitColumns="true" title=""
                    actionUrl="/rebate/payPolicyController/findDmsPolicyList?1=1" idField="id" fit="true" queryMode="group">
            <t:dgCol title="id" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="政策编码" field="productPolicyCode" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="政策名称" field="productPolicyName" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="开始时间" field="beginDate" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="结束时间" field="endDate" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="结案周期" field="policyCycle" sortable="false" query="true" dictionary="product_policy_cycle"></t:dgCol>
            <t:dgCol title="政策状态" field="enableStatus" sortable="false" query="true" dictionary="enable_status"></t:dgCol>
            <t:dgCol title="可申请开始时间" field="applyBeginDate" sortable="false"></t:dgCol>
            <t:dgCol title="可申请结束时间" field="applyEndDate" sortable="false"></t:dgCol>
            <t:dgCol title="创建人" field="createName" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="创建时间" field="createDate" sortable="false" formatter="yyyy-MM-dd HH:mm:ss"></t:dgCol>
            <t:dgCol title="最近更新人" field="updateName" sortable="false" hidden="true"></t:dgCol>
            <t:dgCol title="最近更新时间" field="updateDate" sortable="false" formatter="yyyy-MM-dd HH:mm:ss" hidden="true"></t:dgCol>

            <t:dgToolBar title="新增" operationCode="add" icon="icon-add" url="/page/payPolicyController/goPayPolicyForm?1=1" funname="add" height="450" width="900"></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" url="/page/payPolicyController/goPayPolicyForm?1=1" funname="update" height="450" width="900"></t:dgToolBar>
            <t:dgToolBar title="复制新增" operationCode="copyAdd" icon="icon-add" url="/page/payPolicyController/goPayPolicyForm?1=1&operation=copyAdd" funname="update" height="450" width="900"></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" icon="icon-search" url="/page/payPolicyController/goPayPolicyForm?1=1&operation=search" params="id"  funname="view" height="450" width="900"></t:dgToolBar>
            <t:dgToolBar title="启用" operationCode="start" icon="icon-start" url=""  funname="qiyong()"></t:dgToolBar>
            <t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url=""  funname="tingyong()"></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="/rebate/payPolicyController/deletePayProductPolicy?1=1" funname="deleteALLSelect"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>
<script type="text/javascript" src="pages/com/biz/eisp/excel/importData-NoHandler.js"></script>`
<script type="text/javascript">
    $(document).ready(function(){
        //日期格式查询条件 开始日期
        $("input[name='beginDate']").attr("class","Wdate").click(function(){ WdatePicker({dateFmt:'yyyy-MM-dd'}); });
        //日期格式查询条件 结束日期
        $("input[name='endDate']").attr("class","Wdate").click(function(){ WdatePicker({dateFmt:'yyyy-MM-dd'}); });
    });

    // function updateProductPolicy(title, url, id, width, height) {
    //     getSafeJq().dialog.confirm("编辑政策后，政策将变更为停用状态，是否继续？", function(r) {
    //         var row = $('#payPolicyList').datagrid('getSelected');
    //         if (!row || row.length == 0) {
    //             tip('请选择编辑项目');
    //             return;
    //         }
    //         update(title, "/page/payPolicyController/goPayPolicyForm?1=1", id, 900, 450);
    //     },function(r) {
    //         return;
    //     });
    // }

    //批量启用
    function qiyong(){
        var rowsData = $('#payPolicyList').datagrid('getSelections');
        if( rowsData.length > 0){
            var ids = "";
            for(var i = 0;i<rowsData.length;i++){
                if(i==0){
                    ids = rowsData[i].id;
                }else{
                    ids +=","+rowsData[i].id;
                }
            }
            $.ajax({
                url : '/rebate/payPolicyController/startPayProductPolicy?1=1',
                type : 'post',
                dataType:"json",
                async: false,
                data : {
                    "ids" :ids
                },
                cache : false,
                success : function(data) {
                    tip(data.msg);
                    $("#payPolicyList").datagrid('reload');
                },
                error : function(){
                    tip('服务器繁忙，请稍后再试');
                }
            });

        }else{
            $.messager.alert('提示','至少选择一条');
            return;
        }
    }

    //批量停用
    function tingyong(){
        var rowsData = $('#payPolicyList').datagrid('getSelections');
        if( rowsData.length > 0){
            var ids = "";
            for(var i = 0;i<rowsData.length;i++){
                if(i==0){
                    ids = rowsData[i].id;
                }else{
                    ids +=","+rowsData[i].id;
                }
            }
            $.ajax({
                url : '/rebate/payPolicyController/stopPayProductPolicy?1=1',
                type : 'post',
                dataType:"json",
                async: false,
                data : {
                    "ids" :ids
                },
                cache : false,
                success : function(data) {
                    tip(data.msg);
                    $("#payPolicyList").datagrid('reload');
                },
                error : function(){
                    tip('服务器繁忙，请稍后再试');
                }
            });

        }else{
            $.messager.alert('提示','至少选择一条');
            return;
        }
    }

</script>

