<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="parameter_manage_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="typeList" idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/sfaapi/tsWorkSignController/findTsSignTypeList" pagination="true" singleSelect="false">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="序号" field="orderNumber" ></t:dgCol>
            <t:dgCol title="名称" field="name" ></t:dgCol>
            <t:dgCol title="拍照要求" field="photoReq" dictionary="is_no"></t:dgCol>
            <t:dgCol title="时间要求" field="timeReq" dictionary="is_no"></t:dgCol>
            <t:dgCol title="备注" field="remarks"></t:dgCol>
            <t:dgCol title="操作" field="opt" sortable="false" width="120"/>
            <t:dgFunOpt title="编辑" funname="edit"/>
            <t:dgFunOpt title="删除" funname="deleteInfo" />
            <t:dgToolBar title="新增" operationCode="add" icon="icon-add" onclick="add()"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>

<script>

    var datagrid = $('#typeList');

    function add() {
        createwindow("新建", "/page/tsWorkSignController/toAddTsSignTypePage", 500, 400);
    }


    function edit(index) {

        var row = datagrid.datagrid('getRows')[index];

        createwindow("编辑", "/page/tsWorkSignController/toAddTsSignTypePage?1=1&id="+row.id, 500, 400);
    }


    function deleteInfo(index) {

        var row = datagrid.datagrid('getRows')[index];

        $.ajax({
            url:'/sfaapi/tsWorkSignController/deleteSignType',
            type:'get',
            data:{id:row.id},
            async:false,
            dataType:'json',
            success:function (result) {
                if(result.success){
                    typeListsearch();
                }else{
                    tip(result.msg);
                }
            }
        });

    }

    function getData() {
        var rows = datagrid.datagrid('getSelections');
        var json = JSON.stringify(rows);
        return json;
    }


</script>
