<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ page language="java"
         contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title></title>
    <t:base type="jquery,easyui,tools,DatePicker"></t:base>
    <style>
        #content .inputxt, #steps form select {
            width: 250px;
        }

        #formobj {
            padding: 0 5px;
            width:880px;
            margin:0 auto;
        }

        #steps form div.form {
            float: left;
            width: 300px;
            min-height: 22px;
        }

        #steps form div.form-2 {
            min-width: 700px;
        }

        #steps form div.form-2 textarea {
            width: 90%;
        }

        #steps form div.form .Validform_label {
            width: 85px;
            margin-right: 5px;
            font-weight: normal;
        }

        #steps form div.form .Validform_label input[type="radio"], #steps form div.form .Validform_label input[type="checkbox"]
        {
            position: absolute;
            left: 3px;
            top: 3px;
            width: 15px;
            height: 15px;
        }

        .formDiv {
            float: left;
        }

        .form {
            min-height:0px !important;
        }

        .line-title {
            font-size: 14px;
            padding: 5px;
            /* background:#b4d2ea; */
        }

        .form_label {
            float: left;
            padding-right: 20px;
            line-height: 26px;
        }

        .form_label input[type="radio"] {
            float: left;
            margin: 5px 0 0 0px;
            width: 17px;
            height: 17px;
        }

        .promotionForm_tem {
            margin-right: 10px;
            margin-bottom: 10px;
            padding: 5px;
            border: 1px solid #a5aeb6;
            background: #f5f5f5;
            line-height: 30px;
        }

        .promotionForm_tem input {
            margin: 0 10px;
            width: 60px;
            border: 0;
        }

        .divbr {
            clear: both;
            padding-top: 12px;
        }







        .link-button {
            color: #0e78c9;
        }




        .select-label-item i {
            opacity: .8;
            margin-left: 8px;
            margin-right: 5px;
            cursor: pointer;
        }

        .select-label-item i:hover {
            opacity: 1;
        }

        .form-group-2 {
            width: 20%;
            box-sizing: border-box;
            float: left;
        }

        .upload-img-con {
            width: 100%;
        }

        .upload-img-item {
            text-align: center;
            width: 25%;
            float: left;
            position: relative;
        }

        .upload-img-item a {
            cursor: pointer;
        }

        .upload-img-item-index {
            width: 100%;
        }

        .click-upload-label {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }
        .click-delete-label{
            position: absolute;
            top: 10%;
            right: 10%;
            transform: translate(-50%, -50%);
        }
        .click-upload-pic {
            cursor: pointer;
        }

        .click-upload-pic:hover {
            opacity: 0.6;
        }

        .upload-img-item img {
            width: 120px;
            height: 120px;
        }

    </style>
</head>
<body>
<t:formvalid formid="formobj" layout="div" dialog="true" refresh="true" beforeSubmit="buildJson()"
             action="/budget/ttCollectionInfoController/saveOrUpdate">
    <input type="hidden" id="id" name="id" value="${vo.id}">
    <div style="margin-top: 10px;">
        <div class="form">
            <label class="Validform_label">编码<span style="color: red">*</span>:</label>
            <input id="code" name="code" class="inputxt" style="margin-left: 0px !important;" value="${vo.code}"  datatype="*" readonly="readonly"/>
            <a href="#" class="easyui-linkbutton" plain="true" icon="icon-search" onClick="selectDict();"></a>
        </div>
        <div class="divbr"></div>
        <div class="form">
            <label class="Validform_label">名称:</label>
            <input id="name" name="name" class="inputxt" style="margin-left: 0px !important;" value="${vo.name}" datatype="*" readonly="readonly" />
        </div>
        <div class="divbr"></div>
        <div class="form">
            <label class="Validform_label">排序:</label>
            <input id="sortNum" name="sortNum" class="inputxt" style="margin-left: 0px !important;" value="${vo.sortNum}"  />
        </div>
        <div class="divbr"></div>
        <div class="form">
            <label class="Validform_label">描述:</label>
            <textarea id="remarks" name="remarks"  style="margin-left: 0px !important;width:250px;"
                      rows="6" cols="20" maxlength="1024" placeholder="最大输入1024个字符">${vo.remarks}</textarea>
        </div>
    </div>
    <div class="divbr"></div>
    <div class="line-title">示例</div>
        <input type="file" style="display: none" id="upload" accept="image/png,image/jpeg" onchange="uploadPicture();">
    <input type="hidden" id="mlamJson" name="mlamJson" value="">
    <div class="divbr"></div>
    <div class="form" id="mlam">
            <a iconcls="icon-append" class="easyui-linkbutton l-btn"  plain="true" href="javascript:;" onclick="addMlamOrQrcode('mlam')">点击选择</a>
    </div>
</t:formvalid>
</body>

<script type="text/javascript">
    //选择
    function selectDict(){
        url = "/page/ttCollectionInfoController/goSelectDict";
        width = 450;
        height = 300;
        id = "collectionSelectList";
        gridname = id;
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: width,
            height: height,
            title: '新增',
            opacity: 0.3,
            zIndex:3100,
            parent:'addCustomerDialog',
            id:'addCustomerDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        var myobj=eval(rowsData);
                        $("#code").val(myobj[0].dictCode);
                        $("#name").val(myobj[0].dictValue);
                        $("#code").focus();
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }


    //当前点击的上传图片的id，用于定位更新上传后图片缩略图
    var currentPicVal;
    var currentPicId;
    var realPath;//真实路径
    var vurlPath;//访问相对路径
    var urlPath; //访问路径
    var fileName; //文件名
    var extend; //扩展类型

    function clickUploadLabel(id,val) {
        if(null!=id&&''!=id){
            if('mlam'==id){
                currentPicId = id;
                currentPicVal = val;
                realPath = "realPath"+val;
                vurlPath = "vurlPath"+val;
                urlPath = "urlPath"+val;
                fileName = "fileName"+val;
                extend = "extend"+val;
                $('#upload').click();
            }
        }
    }

    function removePic(id,val) {

        if(null!=id&&''!=id){
            if('mlam'==id){
                $("#index_"+id+val).find("div").html("<a class='link-button click-upload-label' onclick='clickUploadLabel(\""+id+"\",\""+val+"\")'>点击上传</a><img id='mlam_"+id+val+"'>");
                $('#realPath'+val).val("");
                $('#vurlPath'+val).val("");
                $('#urlPath'+val).val("");
                $('#fileName'+val).val("");
                $('#extend'+val).val("");
            }
        }
    }

    function clickUploadPic(id,val) {
        if(null!=id&&''!=id){
            if('mlam'==id){
                currentPicId = id;
                currentPicVal = val;
                realPath = "realPath"+val;
                vurlPath = "vurlPath"+val;
                urlPath = "urlPath"+val;
                fileName = "fileName"+val;
                extend = "extend"+val;
                $('#upload').click();
            }
        }
    }
    /**
     * 上传图片
     */
    function uploadPicture() {
        var file = document.getElementById("upload").files[0];
        if (file == null || file == undefined) {
            return;
        }
        var formData = new FormData();
        formData.append("picture", file);
        formData.append("pointFolder", "logo");
        $.ajax({
            type : "POST",
            url: "/upload/uploadController/uploadFileold",
            data: formData,
            dataType : "json",
            contentType: false,
            processData: false,
            success: function (data) {
                if (data.success) {
                    //显示缩略图
                    var src = data.obj[0].urlPath;
                    var alt = data.obj[0].fileName
                    $('#' + realPath).val(data.obj[0].realPath);
                    $('#' + vurlPath).val(data.obj[0].vurlPath);
                    $('#' + urlPath).val(data.obj[0].urlPath);
                    $('#' + fileName).val(data.obj[0].fileName);
                    $('#' + extend).val(data.obj[0].extend);
                    if ('mlam'==currentPicId){
                        var row = [
                            '<img src="'+src+'" alt="" id="'+currentPicId+currentPicVal+'"   class="click-upload-pic" onclick="clickUploadPic(\''+currentPicId+'\',\''+currentPicVal+'\')" aria-required="true">',
                            '<a class="click-delete-label" onclick="removePic(\''+currentPicId+'\',\''+currentPicVal+'\')"><span class="fa fa-remove remove-pic"   ></span></a>',
                        ];
                        $("#index_"+currentPicId+currentPicVal).find("div").html(row.join(""));
                    }

                    //清空上传文件域
                    var obj = document.getElementById('upload');
                    obj.outerHTML = obj.outerHTML;
                } else {
                    tip(data.msg);
                }
            },
            error: function () {
                tip('上传失败');
            }
        });
    }
</script>

<script type="text/javascript">
    function addMlamOrQrcode(id) {
        var number = $("#"+id).find("div[name='"+id+"']").length;
        number++;
        var realPath; var vurlPath; var urlPath; var fileName; var extend;
        var span_name;
        if('mlam'==id){
            realPath="realPath"; vurlPath="vurlPath"; urlPath="urlPath"; fileName="fileName"; extend="extend";
            span_name = "示例图";
        }
        var rowStart = [
            '<div id="'+id+number+'" name="'+id+'" class="form form-2" style="padding:10px 40px;">',
            '<label class="control-label qrcode-label" name="qrcode-label"><span style="color:red;">*</span><span name="'+id+'-span">'+span_name+number+'：</span></label>',
            '<div class="form-group-2">',
            '<div class="upload-img-con" name="index_'+id+'" id="index_'+id+number+'">',
            '<div class="upload-img-item upload-img-item-index">',
            '<a class="link-button click-upload-label" name="click-upload-label" onclick="clickUploadLabel(\''+id+'\',\''+number+'\')">点击上传</a>',
            '<img id="'+id+number+'">',
            '</div>',
            '<input type="hidden" id="'+realPath+number+'" name="'+realPath+'" value="">',
            '<input type="hidden" id="'+vurlPath+number+'" name="'+vurlPath+'" value="">',
            '<input type="hidden" id="'+urlPath+number+'" name="'+urlPath+'" value="">',
            '<input type="hidden" id="'+fileName+number+'" name="'+fileName+'" value="">',
            '<input type="hidden" id="'+extend+number+'" name="'+extend+'" value="">',
            '</div>',
            '</div>'
        ];
        var rowEnd = [
            '<a iconcls="icon-remove" name="remove" class="easyui-linkbutton l-btn l-btn-plain" plain="true" href="javascript:;" onclick="removeMlamOrQrcode(\''+id+'\',\''+number+'\')">' +
            '<span class="l-btn-left"><span class="l-btn-text icon-remove l-btn-icon-left">删除</span></span></a>',
            '</div>',
            '<div class="divbr"></div>'
        ];
        if('mlam'==id){
            var row = rowStart.join("")+rowEnd.join("");
            $("#"+id).append(row);
        }
    }

    function removeMlamOrQrcode(id,val) {
        var realPath; var vurlPath; var urlPath; var fileName; var extend;
        var span_name;
        if('mlam'==id){
            realPath="realPath"; vurlPath="vurlPath"; urlPath="urlPath"; fileName="fileName"; extend="extend";
            span_name = "示例";
        }
        var con = 0;
        if("mlam" == id){
            // var mlam_Number = $("#"+id).find("div[name='"+id+"']").length;
            // if(mlam_Number<1){
            //     tip('请上传示例图,至少一张。');
            // }else{
                $("#"+id+val).remove();
                $("#"+id).find("div[name='"+id+"']").each(function (i,r) {
                    con++;
                    var that=$(this);
                    that.prop('id', id+con);
                    that.find("span[name='"+id+"-span']").text(span_name+con+":");
                    that.find("div[name='index_"+id+"']").prop('id', 'index_'+id+con);
                    that.find("img").prop('id', ''+id+con);
                    that.find("input[name='"+realPath+"']").prop('id', realPath+con);
                    that.find("input[name='"+vurlPath+"']").prop('id', vurlPath+con);
                    that.find("input[name='"+urlPath+"']").prop('id', urlPath+con);
                    that.find("input[name='"+fileName+"']").prop('id', fileName+con);
                    that.find("input[name='"+extend+"']").prop('id', extend+con);
                    var imgsrc = that.find("img").attr('src');
                    if(null!=imgsrc&&''!=imgsrc){
                        that.find("img").removeAttr('onclick');
                        that.find("img").attr('onclick', 'clickUploadPic("'+id+'","'+con+'")');
                        that.find("a[class='click-delete-label']").removeAttr('onclick');
                        that.find("a[class='click-delete-label']").attr('onclick', 'removePic("'+id+'","'+con+'")');
                    }else{
                        that.find("a[name='click-upload-label']").removeAttr('onclick');
                        that.find("a[name='click-upload-label']").attr('onclick', 'clickUploadLabel("'+id+'","'+con+'")');
                    }
                    that.find("a[name='remove']").removeAttr('onclick');
                    that.find("a[name='remove']").attr('onclick', 'removeMlamOrQrcode("'+id+'","'+con+'")');
                });
            // }
        }
    }
</script>
<script type="text/javascript">
    var CollectionInfoPicMlam  = function() {
        this.businessKey;
        /** logo真实路径 */
        this.realPath;
        /** logo访问相对路径 */
        this.vurlPath;
        /** logo访问路径 */
        this.urlPath;
        /** logo文件名 */
        this.fileName;
        /** logo扩展类型 */
        this.extend;
    };

    function buildJson() {
        var mlamflag = true;
        var mlamNumber = 0;
        var mlamArray = new Array();
        var mlam_Number = $("#mlam").find("div[name='mlam']").length;
        // if(mlam_Number<=0){
        //     tip('请上传示例图,至少一张。');
        //     return false;
        // }
        for(var i=1;i<=mlam_Number;i++){
            var mlamUrl = $("#urlPath"+i).val();
            if (mlamUrl == '' || mlamUrl == undefined || mlamUrl == null) {
                mlamflag = false;
                mlamNumber=i;
                break;
            }
            var mlamReal = $("#realPath"+i).val();
            var mlamVurl = $("#vurlPath"+i).val();
            var mlamName = $("#fileName"+i).val();
            var mlamExtend = $("#extend"+i).val();
            var collectionInfoPicMlam = new CollectionInfoPicMlam();
            collectionInfoPicMlam.urlPath = mlamUrl;
            collectionInfoPicMlam.realPath = mlamReal;
            collectionInfoPicMlam.vurlPath = mlamVurl;
            collectionInfoPicMlam.fileName = mlamName;
            collectionInfoPicMlam.extend = mlamExtend;
            mlamArray.push(collectionInfoPicMlam);
        }
        if(!mlamflag){
            tip('请上传示例图'+mlamNumber+'。');
            return false;
        }
        $("#mlamJson").val(JSON.stringify(mlamArray));
        return true;
    }

</script>
<script type="text/javascript">
    $(function () {
        var mlamJson = ${vo.mlamJson};
        var realPath="realPath"; var vurlPath="vurlPath"; var urlPath="urlPath"; var fileName="fileName"; var extend="extend";
        setValueMlamOrQrcode('mlam',mlamJson,realPath,vurlPath,urlPath,fileName,extend,"示例图");
    });

    function setValueMlamOrQrcode(id,json,real,vurl,url,file,ext,span_name) {
        var number = 0;
        $(json).each(function (e, v) {
            number++;
            var realPath = v[real];
            var vurlPath = v[vurl];
            var urlPath = v[url];
            var fileName = v[file];
            var extend = v[ext];
            var rowStart = [
                '<div id="'+id+number+'" name="'+id+'" class="form form-2" style="padding:10px 40px;">',
                '<label class="control-label qrcode-label" name="qrcode-label"><span style="color:red;">*</span><span name="'+id+'-span">'+span_name+number+'：</span></label>',
                '<div class="form-group-2">',
                '<div class="upload-img-con" name="index_'+id+'" id="index_'+id+number+'">',
                '<div class="upload-img-item upload-img-item-index">',
                '<img src="'+urlPath+'" alt="" id="'+id+number+'"   class="click-upload-pic" onclick="clickUploadPic(\''+id+'\',\''+number+'\')" aria-required="true">',
                '<a class="click-delete-label" onclick="removePic(\''+id+'\',\''+number+'\')"><span class="fa fa-remove remove-pic"></span></a>',
                '</div>',
                '<input type="hidden" id="'+real+number+'" name="'+real+'" value="'+realPath+'">',
                '<input type="hidden" id="'+vurl+number+'" name="'+vurl+'" value="'+vurlPath+'">',
                '<input type="hidden" id="'+url+number+'" name="'+url+'" value="'+urlPath+'">',
                '<input type="hidden" id="'+file+number+'" name="'+file+'" value="'+fileName+'">',
                '<input type="hidden" id="'+ext+number+'" name="'+ext+'" value="'+extend+'">',
                '</div>',
                '</div>'
            ];
            var rowEnd = [
                '<a iconcls="icon-remove" name="remove" class="easyui-linkbutton l-btn l-btn-plain" plain="true" href="javascript:;" onclick="removeMlamOrQrcode(\''+id+'\',\''+number+'\')">' +
                '<span class="l-btn-left"><span class="l-btn-text icon-remove l-btn-icon-left">删除</span></span></a>',
                '</div>',
                '<div class="divbr"></div>'
            ];

            var row;
            row = rowStart.join("")+rowEnd.join("");
            $("#"+id).append(row);
        });

        if('mlam' == id && number == 0){
            addMlamOrQrcode(id);
        }
    }
</script>
</html>
