<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>事业部销售数据</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <style>
        [v-cloak]{
            display: none;
        }
        .container{
            box-sizing: border-box;
            overflow-y: auto;
        }
        .chart-title {
            text-align: center;
        }

        .sale-chart {
            height: 500px;
        }

        .chart-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .chart-table table td,
        .chart-table table th {
            height: 30px;
            border: 1px solid #eeeeee;
            box-sizing: border-box;
            position: relative;
            text-align: center;
        }

        .chart-table table th {
            background: #f6f6f6;
        }

        .finish-percent {
            position: relative;
            width: 0;
            height: 80%;
            transition: all .5s ease-in;
        }

        .finish-percent span {
            color: #fff;
            position: absolute;
            left: 0;
            top: 2px;
        }

        .text-normal {
            color: green;
        }

        .text-danger {
            color: red;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="container p10">
            <h1 class="chart-title">事业部销售数据分析</h1>
            <div class="month-sale">
                <div class="sale-chart">
                    <div ref="saleLine" style="width: 100%;height: 100%;"></div>
                </div>
                <div class="chart-table mb20">
                    <table>
                        <thead>
                            <tr>
                                <th rowspan="2">组织</th>
                                <th colspan="6">销售额</th>
                                <th colspan="6">销量</th>
                            </tr>
                            <tr>
                                <th>实际</th>
                                <th>预算</th>
                                <th>完成率</th>
                                <th>占比</th>
                                <th>环比增长</th>
                                <th>同比增长</th>
                                <th>实际</th>
                                <th>预算</th>
                                <th>完成率</th>
                                <th>占比</th>
                                <th>环比增长</th>
                                <th>同比增长</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(item,index) in tableData">
                                <td>{{item.groupName}}</td>
                                <td>{{item.mRealSale}}</td>
                                <td>{{item.mBudgeSale}}</td>
                                <td>
                                    <div class="finish-percent" :style="{width:item.mFinish+'%',background:'green'}">
                                        <span>{{item.mFinish}}%</span></div>
                                </td>
                                <td>{{item.mPercent}}%</td>
                                <td>{{item.mIncreaseCir}}%<i class="fa fa-circle ml5 text-danger"></i></td>
                                <td>{{item.mIncreaseRec}}%<i class="fa fa-circle ml5 text-normal"></i></td>
                                <td>{{item.nRealSale}}</td>
                                <td>{{item.nBudgeSale}}</td>
                                <td>
                                    <div class="finish-percent" :style="{width:item.finish+'%',background:'green'}">
                                        <span>{{item.nFinish}}%</span></div>
                                </td>
                                <td>{{item.nPercent}}%</td>
                                <td>{{item.nIncreaseCir}}%<i class="fa fa-circle ml5 text-danger"></i></td>
                                <td>{{item.nIncreaseRec}}%<i class="fa fa-circle ml5 text-normal"></i></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/echarts.min.js"></script>
    <script>
        let vm = new Vue({
            el: "#app",
            data: function () {
                return {
                    saleLine: null,
                    tableData: [{
                        groupName: "CRM事业部",
                        mRealSale: 32892632,
                        mBudgeSale: 29603368.8,
                        mFinish: 93,
                        mPercent:38,
                        mIncreaseCir: 7.60,
                        mIncreaseRec: 2.80,
                        nRealSale: 8223158,
                        nBudgeSale: 6167368.5,
                        nFinish: 95,
                        nPercent:38,
                        nIncreaseCir: 7.60,
                        nIncreaseRec: 2.80
                    }, {
                        groupName: "酒类事业部",
                        mRealSale: 35327648,
                        mBudgeSale: 31794883.2,
                        mFinish: 92,
                        mPercent:32,
                        mIncreaseCir: 3.10,
                        mIncreaseRec: 5.40,
                        nRealSale: 8831912,
                        nBudgeSale: 6623934,
                        nFinish: 93,
                        nPercent:32,
                        nIncreaseCir: 3.10,
                        nIncreaseRec: 5.40
                    }, {
                        groupName: "电商事业部",
                        mRealSale: 15322448,
                        mBudgeSale: 13790203.2,
                        mFinish: 87,
                        mPercent:26,
                        mIncreaseCir: 2.80,
                        mIncreaseRec: -1.10,
                        nRealSale: 3830612,
                        nBudgeSale: 2872959,
                        nFinish: 87,
                        nPercent:26,
                        nIncreaseCir: 2.80,
                        nIncreaseRec: -1.10
                    }, {
                        groupName: "AI事业部",
                        mRealSale: 18328768,
                        mBudgeSale: 16495891.2,
                        mFinish: 90,
                        mPercent:14,
                        mIncreaseCir: 4.20,
                        mIncreaseRec: 4.20,
                        nRealSale: 4582192,
                        nBudgeSale: 3436644,
                        nFinish: 95,
                        nPercent:14,
                        nIncreaseCir: 4.20,
                        nIncreaseRec: 4.20
                    }]
                }
            },
            mounted: function () {
                this.initSaleLine();
            },
            methods: {
                initSaleLine: function () {
                    this.saleLine = echarts.init(this.$refs.saleLine);
                    let option = {
                        legend: {},
                        tooltip: {
                            trigger: 'axis',
                            showContent: false
                        },
                        dataset: {
                            source: [
                                ['business', '1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月',
                                    '10月', '11月', '12月'
                                ],
                                ['CRM事业部', 41.1, 30.4, 65.1, 53.3, 83.8, 98.7, 86.5, 92.1, 85.7,
                                    83.1, 73.4, 55.1
                                ],
                                ['酒类事业部', 86.5, 92.1, 85.7, 83.1, 73.4, 55.1, 24.1, 67.2, 79.5,
                                    86.4, 65.2, 82.5
                                ],
                                ['电商事业部', 24.1, 67.2, 79.5, 86.4, 65.2, 82.5, 41.1, 30.4, 65.1,
                                    53.3, 83.8, 98.7
                                ],
                                ['AI事业部', 55.2, 67.1, 69.2, 72.4, 53.9, 39.1, 86.5, 92.1, 85.7,
                                    83.1, 73.4, 55.1
                                ]
                            ]
                        },
                        xAxis: {
                            type: 'category'
                        },
                        yAxis: {
                            gridIndex: 0
                        },
                        grid: {
                            top: '55%'
                        },
                        series: [{
                                type: 'line',
                                smooth: true,
                                seriesLayoutBy: 'row'
                            },
                            {
                                type: 'line',
                                smooth: true,
                                seriesLayoutBy: 'row'
                            },
                            {
                                type: 'line',
                                smooth: true,
                                seriesLayoutBy: 'row'
                            },
                            {
                                type: 'line',
                                smooth: true,
                                seriesLayoutBy: 'row'
                            },
                            {
                                type: 'pie',
                                id: 'pie',
                                radius: '30%',
                                center: ['50%', '25%'],
                                label: {
                                    formatter: '{b}: {@1月} ({d}%)'
                                },
                                encode: {
                                    itemName: 'business',
                                    value: '1月',
                                    tooltip: '1月'
                                }
                            }
                        ]
                    };

                    this.saleLine.on('updateAxisPointer', (event) => {
                        var xAxisInfo = event.axesInfo[0];
                        if (xAxisInfo) {
                            var dimension = xAxisInfo.value + 1;
                            this.saleLine.setOption({
                                series: {
                                    id: 'pie',
                                    label: {
                                        formatter: '{b}: {@[' + dimension + ']} ({d}%)'
                                    },
                                    encode: {
                                        value: dimension,
                                        tooltip: dimension
                                    }
                                }
                            });
                        }
                    });

                    this.saleLine.setOption(option);
                }
            },
        })
    </script>
</body>

</html>