<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="customerMaterial" tagConf="${clickFunctionId}" controllerTarget="ttFiscalConfigController"
                    methedTarget="getMaiListPage" idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/mdm-api/custProductController/findCustProductByPage" pagination="true">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="客户机构编号" field="custOrgName"></t:dgCol>
            <t:dgCol title="用户编号" field="customerCode"></t:dgCol>
            <t:dgCol title="用户名称" field="customerName"></t:dgCol>
            <t:dgCol title="产品编号" field="productCode"></t:dgCol>
            <t:dgCol title="产品名称" field="productName"></t:dgCol>
            <t:dgCol title="修改时间" field="updateDate"></t:dgCol>
            <t:dgCol title="是否停用" field="enableStatus"></t:dgCol>
            <t:dgCol title="修改人" field="updateName"></t:dgCol>
            <t:dgCol title="创建时间" field="createDate"></t:dgCol>
            <t:dgCol title="创建人" field="createName" query="true"></t:dgCol>

            <t:dgToolBar title="添加" operationCode="add" icon="icon-add"
                         url="/page/tmCustProductPageController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="add" height="300" width="450"></t:dgToolBar>
            <t:dgToolBar title="修改" operationCode="edit" icon="icon-edit"
                         url="/page/tmCustProductPageController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="update" height="300" width="450"></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" icon="icon-look"
                         url="/mdm-api/custProductController/getCustProductById?clickFunctionId=${clickFunctionId}"
                         funname="detail" height="300" width="450"></t:dgToolBar>
            <t:dgToolBar title="删除" funname="deleteALLSelectList" icon="icon-remove"
                         url="/mdm-api/custProductController/deleteCustProduct"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut"
                         url="/mdm-api/commonExcelController/excel" excelName="财年配置" excelSheetName="财年配置"
                         funname="excelCommonExport"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="/page/knlLogController/goShowLog"
                         width="1000" height="500" funname="update"></t:dgToolBar>
            <t:dgToolBar title="个性设置" operationCode="style" icon="icon-add"
                         url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500" funname="addSelect"></t:dgToolBar>

        </t:datagrid>
    </div>
</div>

<script>
    function importFile() {
        customerMaterialsearch();
    }

</script>
