<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <t:base type="jquery,easyui,tools,DatePicker"></t:base>
    <title>核销资料</title>
        <!-- 引入样式 -->
        <link rel="stylesheet" href="https://unpkg.com/element-ui/lib/theme-chalk/index.css">

    <style>

        .clearfix:after{visibility:hidden;display:block;font-size:0;content:" ";clear:both;height:0}
        .clearfix{*zoom:1}

        .table-warp{
            width:100%;
        }

        .table-top{
            width: 100%;
        }

        .table-top .left{
            font-size: 16px;
            font-weight: bold;
            text-align: center;
        }

        .table-top .right>.child-warp>div{
            font-size: 16px;
            font-weight: bold;
            text-align: center;
        }

        .table-content{
            display: flex;
            align-items: center;
            width: 100%;
            border-bottom: 1px solid #ccc;
        }

        .table-content .left{
            float: left;
            width: 15%;
            text-align: center;
        }

        .table-content .right{
            float: right;
            width: 85%;
        }

        .table-content .right>.child-warp{
            display: flex;
            align-items: center;
            width: 100%;
            font-size: 0;
            border-bottom: 1px dashed  #ccc;
        }

        .table-content .right>.child-warp:last-child{
            border-bottom: none;
        }

        .table-content .right>.child-warp .img{
            width: 100px;
            height: auto;
        }

        .table-content .right>.child-warp>div{
            display: inline-block;
            width: 20%;
            padding: 10px 0;
            font-size: 16px;
            text-align: center;
        }

        .table-content .right>.child-warp .el-button{
            background-color: #0F467C;
            border-color: #0F467C;
        }

        .submit-btn-warp{
            text-align: right;
            padding: 20px 0;
            margin-right: 30px;
        }

        .submit-btn-warp .el-button{
            background-color: #0F467C;
            border-color: #0F467C;
        }
        .upload-container{
            overflow:auto;
            position:relative
        }
        .upload-demo{
            margin-top: 10px;
        }
        .upload-demo > .el-upload{
            position:absolute;
            left:0;
            top:10px;
        }
        .upload-demo .el-upload-list.el-upload-list--picture{
            display:flex;
            display: -webkit-flex; /* Safari */
        }
        .upload-demo .el-upload-list--picture .el-upload-list__item{
            width:220px;
            flex-shrink:0;
            margin-right:10px;
        }
        upload-demo .el-upload-list--picture .el-upload-list__item:last-child{
            margin-right:0;
        }
    </style>
<body>

        <div class="table-warp" id="app">
            <div class="table-top table-content clearfix">
                <div class="left">活动细类</div>
                <div class="right">
                    <div class="child-warp">
                        <div>核销资料</div>
                        <div>描述</div>
                        <div>示例</div>
                        <div style="width:40%;">上传</div>
                    </div>
                </div>
            </div>

            <div class="table-content clearfix" v-for="(item,index) in actSubclassList">
                <div class="left">{{item.actSubclassName || "-"}}</div>
                <div class="right">
                    <div class="child-warp" v-for="(item2,index2) in item.demoFiles">
                        <div>{{item2.name || "-"}}</div>
                        <div>{{item2.auditInfoDesc || "-"}}</div>
                        <div><img class="img" @click="demoFilePreview(item2.budgetAttachmentEntitys)" :src="item2.budgetAttachmentEntitys | img"></div>
                        <div style="width:40%;padding-top:30px;" class="upload-container">
                            <el-upload
                                    class="upload-demo"
                                    action="/upload/uploadController/uploadFileold?1=1"
                                    :on-preview="handlePreview"
                                    :on-remove="handleRemove"
                                    :on-success="function (response, file, fileList){return constractSuccUpload(response, file, fileList,item2.id,index,index2)}"
                                    :file-list="item2.fileList"
                                    :disabled="disabled"
                                    list-type="picture">
                                <el-button size="small" v-if="isShow" type="primary">点击上传</el-button>
<%--                                <div slot="tip" class="el-upload__tip">只能上传jpg/png文件，且不超过500kb</div>--%>
                            </el-upload>
                        </div>
                    </div>
                </div>
            </div>




            <el-dialog :visible.sync="dialogVisible">
                <img width="100%" :src="dialogImageUrl" alt="">
            </el-dialog>

<%--            <div class="submit-btn-warp">--%>
<%--                <el-button type="primary" @click="submit">提交</el-button>--%>
<%--            </div>--%>


        </div>



        <!-- 引入组件库 -->
        <script src="https://unpkg.com/element-ui/lib/index.js"></script>

<script type="text/javascript">

    var list = null;
    var allObj = null;
    var clickFlg = false;

    var vm = new Vue({
        el: '#app',
        data: function(){
            return {
                disabled:!${editable},
                isShow:${editable},
                dialogImageUrl: '',
                dialogVisible: false,
            "actSubclassList" : [],
                fileList: [{name: 'food.jpeg', url: 'https://fuss10.elemecdn.com/3/63/4e7f3a15429bfda99bce42a18cdd1jpeg.jpeg?imageMogr2/thumbnail/360x360/format/webp/quality/100'}, {name: 'food2.jpeg', url: 'https://fuss10.elemecdn.com/3/63/4e7f3a15429bfda99bce42a18cdd1jpeg.jpeg?imageMogr2/thumbnail/360x360/format/webp/quality/100'}]
            }
        },
        filters: {
            'img': function (item) {
                if(item && item[0] && item[0].urlPath){
                    return item[0].urlPath;
                }
            }
        },
        created: function () {
            getList();
        },
        methods:{
            // success:function(response, file, fileList,success){
            //     console.log(response);
            //     console.log(file);
            //     console.log(fileList);
            //     console.log(success);
            // },
            submit:function(){
                if(list){
                    save();
                }
            },
            constractSuccUpload:function(response, file, fileList,id,index,index2){
                //console.log(index);
                if(response && response.success == true){
                    var flg = true;
                    //逻辑变更，次代码可优化
                    for (var i = 0;i<list.length;i++) {
                        var uploadFilesMapping =list[index].uploadFilesMapping;
                        for (var j = 0;j<list[i].demoFiles.length;j++) {
                            var demoFilesId = list[i].demoFiles[j].id;
                            if(demoFilesId == id){
                                var code = list[index].demoFiles[index2].code;
                                for(var item in uploadFilesMapping){
                                    if( item == code){
                                        if(flg == true){
                                        if(list[index].uploadFilesMapping[item] && list[index].uploadFilesMapping[item].attachs && list[index].uploadFilesMapping[item].attachs.length > 0){
                                            var attachs = list[index].uploadFilesMapping[item].attachs;
                                            attachs.push(response.obj[0]);
                                            list[index].uploadFilesMapping[item].attachs = attachs;
                                            flg = false;
                                        }else{
                                            list[index].uploadFilesMapping[item] ={
                                                attachs:response.obj
                                            }
                                            list[index].uploadFilesMapping[item].actSubclassCode = list[index].actSubclassCode;
                                            list[index].uploadFilesMapping[item].actSubclassName = list[index].actSubclassName;
                                            list[index].uploadFilesMapping[item].tempUuid = allObj.tempUuid;
                                            list[index].uploadFilesMapping[item].exampleCode = item;
                                            flg = false;
                                        }
                                        }
                                    }
                                }
                            }
                        }
                    }

                    setTimeout(function () {
                        uploadImg();
                    },100)
                    // 上传成功后用线上地址区分文件类型
                    console.log(response.obj[0])
                    let fileUrl = response.obj[0].urlPath;
                    // uploadImg(fileUrl);
                    //console.log(list);

                }
            },
            handlePreview:function(file) {
                var extend = null;
                if(file.response){
                    extend = file.response.obj[0].extend;
                }else{
                    extend = file.extend;
                }
                extend = extend.toLowerCase();
                // 图片预览，其他的文件下载；
                if(extend == "jpg" || extend == "png"|| extend == "jpeg"){
                    this.dialogImageUrl = file.url;
                    this.dialogVisible = true;
                }else{
                    window.open(file.url);
                }
            },
            handleRemove:function(file, fileList) {
                var id = null;
                if(file.response){
                    id = file.response.obj[0].id;
                }
                var imgid = file.imgid;
                for (var i = 0;i<list.length;i++) {
                    var uploadFilesMapping =list[i].uploadFilesMapping;
                    if(uploadFilesMapping){
                        for(var item in uploadFilesMapping){
                            if(uploadFilesMapping[item] && uploadFilesMapping[item].attachs && uploadFilesMapping[item].attachs.length>0){
                                var attachs = uploadFilesMapping[item].attachs;
                                for (var k = 0; k<attachs.length;k++){
                                    if(attachs[k].id == id || attachs[k].id == imgid){
                                        attachs.splice(k, 1);
                                    }
                                }
                                uploadFilesMapping[item].attachs = attachs;
                            }
                        }
                    }
                }
                //console.log(list);
            },
            demoFilePreview:function (item) {
                if(item && item[0] && item[0].urlPath){
                    this.dialogImageUrl = item[0].urlPath;
                    this.dialogVisible = true;
                }
            }
        }
    });


    //替换图片
    function uploadImg(fileUrl) {

        $(".upload-demo .el-upload-list .el-upload-list__item>img").each(function () {
            var src = $(this).attr("src");
            console.log(src, 292)
           if(src){
               //单独处理图片
               if(src.indexOf("blob") >-1){
                   //获取blob url 的图片类型进行替换
                   $(this).attr("src","/resources/img/wenjian.png");
               }else{
                   var arr = src.split(".");
                   var type =arr[arr.length - 1].toLowerCase();

                   if(type === "jpg" || type === "png" || type === "jpeg" || type=="gif"){
                       $(this).attr("src",src);
                   } else {
                       $(this).attr("src","/resources/img/wenjian.png");
                   }
               }

           }

        })
    }


    // ================================ajax 方法============================

    // 获取列表
    function getList() {
        var formData={
            ids:"${ids}",
            editable:"${editable}",
            tempUuid:"${tempUuid}"
        }
        $.ajax({
            type: "GET",
            url: "/pay/ttAuditActDetailController/getTtAuditActDetailUploadPageData",
            contentType: "application/json; charset=utf-8",
            data: formData,
            dataType : "json",
            success: function(res){
                if(res.success == true){
                    if(res.obj && res.obj.actSubclassList){
                        var actSubclassList = res.obj.actSubclassList;
                        allObj = res.obj;
                        list = JSON.parse(JSON.stringify(actSubclassList));
                        for (var i = 0;i<actSubclassList.length;i++) {
                            var uploadFilesMapping =actSubclassList[i].uploadFilesMapping;
                            for (var j = 0;j<actSubclassList[i].demoFiles.length;j++) {
                                var code = actSubclassList[i].demoFiles[j].code;
                                for(var item in uploadFilesMapping){
                                    if( item == code && uploadFilesMapping[item]){
                                        if(uploadFilesMapping[item].attachs && uploadFilesMapping[item].attachs.length > 0 ){
                                            var arr = [];
                                            for (var k = 0; k<uploadFilesMapping[item].attachs.length;k++){
                                                var obj = {
                                                    name:uploadFilesMapping[item].attachs[k].fileName,
                                                    url:uploadFilesMapping[item].attachs[k].urlPath,
                                                    imgid:uploadFilesMapping[item].attachs[k].id,
                                                    extend:uploadFilesMapping[item].attachs[k].extend
                                                }
                                                arr.push(obj);
                                            }
                                            actSubclassList[i].demoFiles[j].fileList = arr;
                                        }
                                    }
                                }

                            }
                        }
                        //console.log(actSubclassList);
                        vm.actSubclassList = actSubclassList;
                        // uploadImg();
                    }
                    setTimeout(function () {
                        uploadImg();
                    },100)
                    console.log('initData')
                }
            }
        });
    }

    // 提交
    function saveData_() {
        allObj.actSubclassList = list;
        var formData= allObj;
        if(clickFlg){
            return;
        }
        clickFlg = true;
        $.ajax({
            type: "POST",
            url: "/pay/ttAuditActDetailController/saveTtAuditActDetailUploadPageData",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(formData),
            dataType : "json",
            success: function(res){
                clickFlg = false;
                var api = frameElement.api,
                    W = api.opener;
                // W.tip(res.msg);
                if(res.success == true){
                    api.close();

                } else {
                    tip(res.msg)
                }
            }
        });
    }

</script>
</body>
</html>
